/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.blocks.tileentity;

import dan200.computercraft.shared.util.RedstoneUtil;
import de.srendi.advancedperipherals.common.addons.computercraft.peripheral.RedstoneIntegratorPeripheral;
import de.srendi.advancedperipherals.common.blocks.base.PeripheralTileEntity;
import de.srendi.advancedperipherals.common.setup.TileEntityTypes;
import java.util.Objects;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.RedstoneWireBlock;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class RedstoneIntegratorTile
extends PeripheralTileEntity<RedstoneIntegratorPeripheral> {
    public int[] power = new int[Direction.values().length];

    public RedstoneIntegratorTile() {
        super((TileEntityType)TileEntityTypes.REDSTONE_INTEGRATOR.get());
    }

    @Override
    @NotNull
    protected RedstoneIntegratorPeripheral createPeripheral() {
        return new RedstoneIntegratorPeripheral(this);
    }

    public int getRedstoneInput(Direction direction) {
        Objects.requireNonNull(this.field_145850_b);
        BlockPos neighbourPos = this.func_174877_v().func_177972_a(direction);
        int power = this.field_145850_b.func_175651_c(neighbourPos, direction);
        if (power >= 15) {
            return power;
        }
        BlockState neighbourState = this.field_145850_b.func_180495_p(neighbourPos);
        return neighbourState.func_177230_c() == Blocks.field_150488_af ? Math.max(power, (Integer)neighbourState.func_177229_b((Property)RedstoneWireBlock.field_176351_O)) : power;
    }

    public void setRedstoneOutput(Direction direction, int power) {
        int old = this.power[direction.func_176745_a()];
        this.power[direction.func_176745_a()] = power;
        if (old != power) {
            if (this.field_145850_b != null) {
                RedstoneUtil.propagateRedstoneOutput((World)this.field_145850_b, (BlockPos)this.func_174877_v(), (Direction)direction);
            }
            this.func_70296_d();
        }
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        for (Direction direction : Direction.values()) {
            this.setRedstoneOutput(direction, compound.func_74762_e(direction.name() + "Power"));
        }
        super.func_230337_a_(state, compound);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        int i = 0;
        for (Direction direction : Direction.values()) {
            compound.func_74768_a(direction.name() + "Power", this.power[i]);
            ++i;
        }
        return compound;
    }
}

