/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.util;

import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import de.srendi.advancedperipherals.common.util.LuaConverter;
import de.srendi.advancedperipherals.common.util.Pair;
import de.srendi.advancedperipherals.lib.peripherals.owner.IPeripheralOwner;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public class InventoryUtil {
    private static final List<Pair<Predicate<Object>, Function<Object, IItemHandler>>> EXTRACTORS = new ArrayList<Pair<Predicate<Object>, Function<Object, IItemHandler>>>();

    public static void registerExtractor(Predicate<Object> predicate, Function<Object, IItemHandler> handlerGenerator) {
        EXTRACTORS.add(Pair.of(predicate, handlerGenerator));
    }

    public static IItemHandler extractHandler(@Nullable Object object) {
        LazyOptional cap;
        for (Pair<Predicate<Object>, Function<Object, IItemHandler>> extractor : EXTRACTORS) {
            if (!extractor.getLeft().test(object)) continue;
            return extractor.getRight().apply(object);
        }
        if (object instanceof ICapabilityProvider && (cap = ((ICapabilityProvider)object).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)).isPresent()) {
            return (IItemHandler)cap.orElseThrow(NullPointerException::new);
        }
        if (object instanceof IItemHandler) {
            return (IItemHandler)object;
        }
        if (object instanceof IInventory) {
            return new InvWrapper((IInventory)object);
        }
        return null;
    }

    public static int moveItem(IItemHandler from, int fromSlot, IItemHandler to, int toSlot, int limit) {
        int inserted;
        ItemStack extracted = from.extractItem(fromSlot, limit, true);
        if (extracted.func_190926_b()) {
            return 0;
        }
        int extractCount = Math.min(extracted.func_190916_E(), limit);
        extracted.func_190920_e(extractCount);
        ItemStack remainder = toSlot < 0 ? ItemHandlerHelper.insertItem((IItemHandler)to, (ItemStack)extracted, (boolean)false) : to.insertItem(toSlot, extracted, false);
        int n = inserted = remainder.func_190926_b() ? extractCount : extractCount - remainder.func_190916_E();
        if (inserted <= 0) {
            return 0;
        }
        from.extractItem(fromSlot, inserted, false);
        return inserted;
    }

    public static MethodResult pushItems(@NotNull IArguments arguments, @NotNull IComputerAccess access, @NotNull IItemHandler source) throws LuaException {
        String toName = arguments.getString(0);
        int fromSlot = arguments.getInt(1);
        int limit = arguments.optInt(2, Integer.MAX_VALUE);
        int toSlot = arguments.optInt(3, -1);
        if (fromSlot < 1 || fromSlot > source.getSlots()) {
            return MethodResult.of((Object[])new Object[]{null, "From slot is incorrect"});
        }
        IItemHandler to = InventoryUtil.getHandlerFromName(access, toName);
        if (toSlot != -1 && (toSlot < 1 || toSlot > to.getSlots())) {
            return MethodResult.of((Object[])new Object[]{null, "To slot is incorrect"});
        }
        if (limit <= 0) {
            return MethodResult.of((Object)0);
        }
        return MethodResult.of((Object)InventoryUtil.moveItem(source, fromSlot - 1, to, toSlot - 1, limit));
    }

    public static MethodResult pullItems(@NotNull IArguments arguments, @NotNull IComputerAccess access, @NotNull IItemHandler source) throws LuaException {
        String fromName = arguments.getString(0);
        int fromSlot = arguments.getInt(1);
        int limit = arguments.optInt(2, Integer.MAX_VALUE);
        int toSlot = arguments.optInt(3, -1);
        if (toSlot != -1 && (toSlot < 1 || toSlot > source.getSlots())) {
            return MethodResult.of((Object[])new Object[]{null, "To slot is incorrect"});
        }
        IItemHandler from = InventoryUtil.getHandlerFromName(access, fromName);
        if (fromSlot < 1 || fromSlot > from.getSlots()) {
            return MethodResult.of((Object[])new Object[]{null, "From slot is incorrect"});
        }
        if (limit <= 0) {
            return MethodResult.of((Object)0);
        }
        return MethodResult.of((Object)InventoryUtil.moveItem(from, fromSlot - 1, source, toSlot - 1, limit));
    }

    @NotNull
    public static IItemHandler getHandlerFromName(@NotNull IComputerAccess access, String name) throws LuaException {
        IPeripheral location = access.getAvailablePeripheral(name);
        if (location == null) {
            throw new LuaException("Target '" + name + "' does not exist");
        }
        IItemHandler handler = InventoryUtil.extractHandler(location.getTarget());
        if (handler == null) {
            throw new LuaException("Target '" + name + "' is not an inventory");
        }
        return handler;
    }

    @NotNull
    public static IItemHandler getHandlerFromDirection(@NotNull String direction, @NotNull IPeripheralOwner owner) throws LuaException {
        World world = owner.getWorld();
        Objects.requireNonNull(world);
        Direction relativeDirection = LuaConverter.getDirection(owner.getFacing(), direction);
        TileEntity target = world.func_175625_s(owner.getPos().func_177972_a(relativeDirection));
        if (target == null) {
            throw new LuaException("Target '" + direction + "' is empty or defenetly not inventory");
        }
        IItemHandler handler = InventoryUtil.extractHandler(target);
        if (handler == null) {
            throw new LuaException("Target '" + direction + "' is not an inventory");
        }
        return handler;
    }
}

