/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.lib.peripherals.owner;

import de.srendi.advancedperipherals.common.util.fakeplayer.APFakePlayer;
import de.srendi.advancedperipherals.lib.peripherals.IPeripheralOperation;
import de.srendi.advancedperipherals.lib.peripherals.owner.IOwnerAbility;
import de.srendi.advancedperipherals.lib.peripherals.owner.OperationAbility;
import de.srendi.advancedperipherals.lib.peripherals.owner.PeripheralOwnerAbility;
import java.util.Collection;
import java.util.function.Function;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IPeripheralOwner {
    @Nullable
    public String getCustomName();

    @Nullable
    public World getWorld();

    @NotNull
    public BlockPos getPos();

    @NotNull
    public Direction getFacing();

    @Nullable
    public PlayerEntity getOwner();

    @NotNull
    public CompoundNBT getDataStorage();

    public void markDataStorageDirty();

    public <T> T withPlayer(Function<APFakePlayer, T> var1);

    public ItemStack getToolInMainHand();

    public ItemStack storeItem(ItemStack var1);

    public void destroyUpgrade();

    public boolean isMovementPossible(@NotNull World var1, @NotNull BlockPos var2);

    public boolean move(@NotNull World var1, @NotNull BlockPos var2);

    public <T extends IOwnerAbility> void attachAbility(PeripheralOwnerAbility<T> var1, T var2);

    @Nullable
    public <T extends IOwnerAbility> T getAbility(PeripheralOwnerAbility<T> var1);

    public Collection<IOwnerAbility> getAbilities();

    default public void attachOperation(IPeripheralOperation<?> ... operations) {
        OperationAbility operationAbility = new OperationAbility(this);
        this.attachAbility(PeripheralOwnerAbility.OPERATION, operationAbility);
        for (IPeripheralOperation<?> operation : operations) {
            operationAbility.registerOperation(operation);
        }
    }

    default public void attachOperation(Collection<IPeripheralOperation<?>> operations) {
        OperationAbility operationAbility = new OperationAbility(this);
        this.attachAbility(PeripheralOwnerAbility.OPERATION, operationAbility);
        for (IPeripheralOperation<?> operation : operations) {
            operationAbility.registerOperation(operation);
        }
    }
}

