/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.lib.peripherals.owner;

import de.srendi.advancedperipherals.common.blocks.base.APTileEntityBlock;
import de.srendi.advancedperipherals.common.blocks.tileentity.InventoryManagerTile;
import de.srendi.advancedperipherals.common.util.DataStorageUtil;
import de.srendi.advancedperipherals.common.util.fakeplayer.APFakePlayer;
import de.srendi.advancedperipherals.lib.peripherals.IPeripheralTileEntity;
import de.srendi.advancedperipherals.lib.peripherals.owner.BasePeripheralOwner;
import de.srendi.advancedperipherals.lib.peripherals.owner.PeripheralOwnerAbility;
import de.srendi.advancedperipherals.lib.peripherals.owner.TileEntityFuelAbility;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityPeripheralOwner<T extends TileEntity>
extends BasePeripheralOwner {
    public final T tileEntity;

    public TileEntityPeripheralOwner(T tileEntity) {
        this.tileEntity = tileEntity;
    }

    @Override
    @Nullable
    public String getCustomName() {
        return this.tileEntity.getTileData().func_74779_i("CustomName");
    }

    @Override
    @NotNull
    public World getWorld() {
        return Objects.requireNonNull(this.tileEntity.func_145831_w());
    }

    @Override
    @NotNull
    public BlockPos getPos() {
        return this.tileEntity.func_174877_v();
    }

    @Override
    @NotNull
    public Direction getFacing() {
        return (Direction)this.tileEntity.func_195044_w().func_177229_b((Property)APTileEntityBlock.FACING);
    }

    @Override
    @Nullable
    public PlayerEntity getOwner() {
        if (this.tileEntity instanceof InventoryManagerTile) {
            return ((InventoryManagerTile)this.tileEntity).getOwnerPlayer();
        }
        return null;
    }

    @Override
    @NotNull
    public CompoundNBT getDataStorage() {
        return DataStorageUtil.getDataStorage((IPeripheralTileEntity)this.tileEntity);
    }

    @Override
    public void markDataStorageDirty() {
        this.tileEntity.func_70296_d();
    }

    public <T1> T1 withPlayer(Function<APFakePlayer, T1> function) {
        throw new RuntimeException("Not implemented yet");
    }

    @Override
    public ItemStack getToolInMainHand() {
        return ItemStack.field_190927_a;
    }

    @Override
    public ItemStack storeItem(ItemStack stored) {
        throw new RuntimeException("Not implemented yet");
    }

    @Override
    public void destroyUpgrade() {
        World world = this.getWorld();
        if (world != null) {
            this.getWorld().func_217377_a(this.tileEntity.func_174877_v(), false);
        }
    }

    @Override
    public boolean isMovementPossible(@NotNull World world, @NotNull BlockPos pos) {
        return false;
    }

    @Override
    public boolean move(@NotNull World world, @NotNull BlockPos pos) {
        return false;
    }

    public TileEntityPeripheralOwner<T> attachFuel() {
        this.attachAbility(PeripheralOwnerAbility.FUEL, new TileEntityFuelAbility(this));
        return this;
    }
}

