/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.lib.peripherals.owner;

import com.mojang.authlib.GameProfile;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.api.turtle.event.TurtleBlockEvent;
import dan200.computercraft.shared.turtle.core.TurtlePlayer;
import dan200.computercraft.shared.util.InventoryUtil;
import de.srendi.advancedperipherals.common.util.DataStorageUtil;
import de.srendi.advancedperipherals.common.util.fakeplayer.APFakePlayer;
import de.srendi.advancedperipherals.common.util.fakeplayer.FakePlayerProviderTurtle;
import de.srendi.advancedperipherals.lib.peripherals.owner.BasePeripheralOwner;
import de.srendi.advancedperipherals.lib.peripherals.owner.PeripheralOwnerAbility;
import de.srendi.advancedperipherals.lib.peripherals.owner.TurtleFuelAbility;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TurtlePeripheralOwner
extends BasePeripheralOwner {
    public final ITurtleAccess turtle;
    public final TurtleSide side;

    public TurtlePeripheralOwner(ITurtleAccess turtle, TurtleSide side) {
        this.turtle = turtle;
        this.side = side;
    }

    @Override
    @Nullable
    public String getCustomName() {
        return null;
    }

    @Override
    @NotNull
    public World getWorld() {
        return this.turtle.getWorld();
    }

    @Override
    @NotNull
    public BlockPos getPos() {
        return this.turtle.getPosition();
    }

    @Override
    @NotNull
    public Direction getFacing() {
        return this.turtle.getDirection();
    }

    @Override
    @Nullable
    public PlayerEntity getOwner() {
        GameProfile owningPlayer = this.turtle.getOwningPlayer();
        if (owningPlayer == null) {
            return null;
        }
        return this.turtle.getWorld().func_217371_b(owningPlayer.getId());
    }

    @Override
    @NotNull
    public CompoundNBT getDataStorage() {
        return DataStorageUtil.getDataStorage(this.turtle, this.side);
    }

    @Override
    public void markDataStorageDirty() {
        this.turtle.updateUpgradeNBTData(this.side);
    }

    @Override
    public <T> T withPlayer(Function<APFakePlayer, T> function) {
        return FakePlayerProviderTurtle.withPlayer(this.turtle, function);
    }

    @Override
    public ItemStack getToolInMainHand() {
        return this.turtle.getInventory().func_70301_a(this.turtle.getSelectedSlot());
    }

    @Override
    public ItemStack storeItem(ItemStack stored) {
        return InventoryUtil.storeItems((ItemStack)stored, (IItemHandler)this.turtle.getItemHandler(), (int)this.turtle.getSelectedSlot());
    }

    @Override
    public void destroyUpgrade() {
        this.turtle.setUpgrade(this.side, null);
    }

    @Override
    public boolean isMovementPossible(@Nonnull World world, @Nonnull BlockPos pos) {
        TurtlePlayer turtlePlayer = TurtlePlayer.getWithPosition((ITurtleAccess)this.turtle, (BlockPos)this.getPos(), (Direction)this.turtle.getDirection());
        TurtleBlockEvent.Move moveEvent = new TurtleBlockEvent.Move(this.turtle, (FakePlayer)turtlePlayer, world, pos);
        return !MinecraftForge.EVENT_BUS.post((Event)moveEvent);
    }

    @Override
    public boolean move(@Nonnull World world, @Nonnull BlockPos pos) {
        return this.turtle.teleportTo(world, pos);
    }

    @NotNull
    public ITurtleAccess getTurtle() {
        return this.turtle;
    }

    @NotNull
    public TurtleSide getSide() {
        return this.side;
    }

    public TurtlePeripheralOwner attachFuel(int maxFuelConsumptionLevel) {
        this.attachAbility(PeripheralOwnerAbility.FUEL, new TurtleFuelAbility(this, maxFuelConsumptionLevel));
        return this;
    }
}

