/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.client.gui.frame;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import lehjr.numina.client.gui.IContainerULOffSet;
import lehjr.numina.client.gui.frame.ScrollableFrame;
import lehjr.numina.client.gui.gemoetry.DrawableTile;
import lehjr.numina.client.gui.gemoetry.MusePoint2D;
import lehjr.numina.client.gui.slot.IHideableSlot;
import lehjr.numina.client.gui.slot.UniversalSlot;
import lehjr.numina.common.math.Colour;
import lehjr.numina.common.math.MathUtils;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.Pair;

public class InventoryFrame
extends ScrollableFrame
implements IContainerULOffSet {
    IContainerULOffSet.ulGetter ulGetter;
    Container container;
    public final int gridWidth;
    public final int gridHeight;
    List<Integer> slotIndexes;
    List<DrawableTile> tiles;
    MusePoint2D slot_ulShift = new MusePoint2D(0.0, 0.0);
    int slotWidth = 18;
    int slotHeight = 18;
    int visibleRows = -1;
    int scrollLimit = -1;
    int currentScroll = 0;

    public InventoryFrame(Container containerIn, int gridWidth, int gridHeight, List<Integer> slotIndexesIn, IContainerULOffSet.ulGetter ulGetter2) {
        this(containerIn, Colour.BLACK, new Colour(0.216f, 0.216f, 0.216f, 1.0f), Colour.WHITE.withAlpha(0.8f), gridWidth, gridHeight, slotIndexesIn, ulGetter2);
    }

    public InventoryFrame(Container containerIn, int gridWidth, int gridHeight, int visibleRows, List<Integer> slotIndexesIn, IContainerULOffSet.ulGetter ulGetter2) {
        this(containerIn, Colour.BLACK, new Colour(0.216f, 0.216f, 0.216f, 1.0f), Colour.WHITE.withAlpha(0.8f), gridWidth, gridHeight, visibleRows, slotIndexesIn, ulGetter2);
    }

    public InventoryFrame(Container containerIn, Colour backgroundColour, Colour topBorderColour, Colour bottomBorderColour, int gridWidth, int gridHeight, List<Integer> slotIndexesIn, IContainerULOffSet.ulGetter ulGetter2) {
        this(containerIn, backgroundColour, topBorderColour, bottomBorderColour, gridWidth, gridHeight, -1, slotIndexesIn, ulGetter2);
    }

    public InventoryFrame(Container containerIn, Colour background, Colour topBorder, Colour bottomBorder, int gridWidth, int gridHeight, int visibleRows, List<Integer> slotIndexesIn, IContainerULOffSet.ulGetter ulGetter2) {
        super.setBackgroundColour(background);
        super.setTopBorderColour(topBorder);
        super.setBottomBorderColour(bottomBorder);
        this.ulGetter = ulGetter2;
        this.container = containerIn;
        this.gridWidth = gridWidth;
        this.gridHeight = gridHeight;
        this.slotIndexes = slotIndexesIn;
        this.tiles = new ArrayList<DrawableTile>();
        this.visibleRows = visibleRows;
        int totalRows = (int)Math.ceil((double)slotIndexesIn.size() / (double)gridWidth);
        if (totalRows > gridHeight) {
            this.visibleRows = gridHeight;
            this.scrollLimit = totalRows - gridHeight;
        }
        super.setWidth(this.slotWidth * gridWidth).setHeight(this.slotHeight * gridHeight);
        this.setUL(new MusePoint2D(0.0, 0.0));
    }

    public InventoryFrame setNewValues(List<Integer> slotIndexesIn) {
        for (int index : this.slotIndexes) {
            Slot slot = this.container.func_75139_a(index);
            if (!(slot instanceof IHideableSlot)) continue;
            ((IHideableSlot)slot).disable();
            ((IHideableSlot)slot).setPosition(new MusePoint2D(-1000.0, -1000.0));
        }
        this.slotIndexes = slotIndexesIn;
        int totalRows = (int)Math.ceil((double)slotIndexesIn.size() / (double)this.gridWidth);
        if (totalRows > this.gridHeight) {
            this.visibleRows = this.gridHeight;
            this.scrollLimit = totalRows - this.gridHeight;
        }
        this.loadSlots();
        return this;
    }

    @Override
    public DrawableTile setBackgroundColour(Colour backgroundColour) {
        super.setBackgroundColour(backgroundColour);
        return this;
    }

    @Override
    public DrawableTile setTopBorderColour(Colour borderColour) {
        super.setTopBorderColour(borderColour);
        return this;
    }

    @Override
    public DrawableTile setBottomBorderColour(Colour borderColour) {
        super.setBottomBorderColour(borderColour);
        return this;
    }

    @Override
    public void setDrawBackground(boolean drawBackground) {
        this.drawBackground = drawBackground;
    }

    @Override
    public void setDrawBorder(boolean drawBorder) {
        this.drawBorder = drawBorder;
    }

    Pair<Integer, Integer> getVisibleRows() {
        int totalRows = this.getTotalRows();
        if (this.visibleRows < totalRows) {
            return Pair.of((Object)this.currentScroll, (Object)(this.gridHeight + this.currentScroll));
        }
        return Pair.of((Object)0, (Object)this.gridHeight);
    }

    int getVisibileGridHeight() {
        return (this.visibleRows > 0 ? this.visibleRows : this.gridHeight) * this.slotHeight;
    }

    int getTotalRows() {
        return (int)Math.ceil((double)this.slotIndexes.size() / (double)this.gridWidth);
    }

    public void loadSlots() {
        this.tiles = new ArrayList<DrawableTile>();
        if (this.slotIndexes.isEmpty()) {
            return;
        }
        this.slot_ulShift = this.getULShift();
        Pair<Integer, Integer> gridRange = this.getVisibleRows();
        MusePoint2D ul = new MusePoint2D(this.finalLeft(), this.finalTop());
        int i = (Integer)gridRange.getLeft() * this.gridWidth;
        block0: for (int row = ((Integer)gridRange.getLeft()).intValue(); row < (Integer)gridRange.getRight(); ++row) {
            for (int col = 0; col < this.gridWidth; ++col) {
                if (i == this.slotIndexes.size()) break block0;
                this.tiles.add(new DrawableTile(ul, ul.plus(new MusePoint2D(this.slotWidth, this.slotHeight))).setBorderShrinkValue(0.5f));
                if (i > 0) {
                    if (col > 0) {
                        this.tiles.get(i).setMeRightOf(this.tiles.get(i - 1));
                    }
                    if (row > 0) {
                        this.tiles.get(i).setMeBelow(this.tiles.get(i - this.gridWidth));
                    }
                }
                MusePoint2D position = new MusePoint2D(this.tiles.get(i).finalLeft(), this.tiles.get(i).finalTop()).minus(this.slot_ulShift);
                Slot slot = this.container.func_75139_a(this.slotIndexes.get(i).intValue());
                if (slot instanceof UniversalSlot) {
                    ((UniversalSlot)slot).setPosition(position);
                } else if (slot instanceof IHideableSlot) {
                    ((IHideableSlot)slot).setPosition(position);
                    ((IHideableSlot)slot).enable();
                } else {
                    slot.field_75223_e = (int)position.getX();
                    slot.field_75221_f = (int)position.getY();
                }
                ++i;
            }
        }
    }

    public InventoryFrame setSlotWidth(int slotWidthIn) {
        this.slotWidth = slotWidthIn;
        this.setWH(new MusePoint2D(this.slotWidth, this.slotHeight));
        return this;
    }

    public InventoryFrame setSlotHeight(int slotHeightIn) {
        this.slotHeight = slotHeightIn;
        this.setWH(new MusePoint2D(this.slotWidth, this.slotHeight));
        return this;
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        return false;
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int buton) {
        return false;
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double dWheel) {
        this.currentScroll = (int)MathUtils.clampDouble((double)this.currentScroll + dWheel, 0.0, this.scrollLimit > 0 ? this.scrollLimit : 0);
        return false;
    }

    @Override
    public void initGrowth() {
        super.initGrowth();
        this.loadSlots();
    }

    @Override
    public void update(double mouseX, double mouseY) {
        super.update(mouseX, mouseY);
        this.loadSlots();
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float frameTime) {
        if (this.drawBackground) {
            this.drawBackground(matrixStack);
        }
        if (this.tiles != null && !this.tiles.isEmpty()) {
            for (DrawableTile tile : this.tiles) {
                tile.func_230430_a_(matrixStack, mouseX, mouseY, frameTime);
            }
        }
        if (this.drawBorder) {
            this.drawBorder(matrixStack, 0.0);
        }
    }

    @Override
    public List<ITextComponent> getToolTip(int i, int i1) {
        return null;
    }

    @Override
    public void setULGetter(IContainerULOffSet.ulGetter ulGetter2) {
        this.ulGetter = ulGetter2;
    }

    @Override
    public MusePoint2D getULShift() {
        int offset = 16;
        if (this.ulGetter == null) {
            return new MusePoint2D(0.0, 0.0).plus((double)(offset - this.slotWidth) * 0.5, (double)(offset - this.slotHeight) * 0.5);
        }
        return this.ulGetter.getULShift().plus((double)(offset - this.slotWidth) * 0.5, (double)(offset - this.slotHeight) * 0.5);
    }
}

