/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.common.capabilities.module.powermodule;

import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import lehjr.numina.common.capabilities.module.powermodule.ModuleCategory;
import lehjr.numina.common.capabilities.module.powermodule.ModuleTarget;
import lehjr.numina.common.capabilities.module.powermodule.UnitMap;
import lehjr.numina.common.tags.TagUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public interface IPowerModule {
    public ItemStack getModuleStack();

    public ModuleTarget getTarget();

    public ModuleCategory getCategory();

    default public int getTier() {
        return -1;
    }

    default public String getModuleGroup() {
        return "";
    }

    public void addTradeoffProperty(String var1, String var2, double var3);

    public void addPropertyModifier(String var1, IPropertyModifier var2);

    public void addTradeoffProperty(String var1, String var2, double var3, String var5);

    public void addBaseProperty(String var1, double var2);

    public void addBaseProperty(String var1, double var2, String var4);

    public double applyPropertyModifiers(String var1);

    public double applyPropertyModifiers(String var1, CompoundNBT var2);

    public Map<String, List<IPropertyModifier>> getPropertyModifiers();

    public void addIntTradeoffProperty(String var1, String var2, int var3, String var4, int var5, int var6);

    public boolean isAllowed();

    default public CompoundNBT getModuleTag() {
        return TagUtils.getModuleTag(this.getModuleStack());
    }

    default public boolean isModuleOnline() {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    default public String getUnit(@Nonnull String propertyName) {
        return UnitMap.MAP.getUnit(propertyName);
    }

    default public void addUnitLabel(@Nonnull String propertyName, String unit) {
        UnitMap.MAP.addUnitLabel(propertyName, unit);
    }

    public static class PropertyModifierLinearAdditive
    implements IPropertyModifier {
        public final String tradeoffName;
        public double multiplier;

        public PropertyModifierLinearAdditive(String tradeoffName, double multiplier) {
            this.multiplier = multiplier;
            this.tradeoffName = tradeoffName;
        }

        @Override
        public double applyModifier(CompoundNBT moduleTag, double value) {
            return value + this.multiplier * TagUtils.getDoubleOrZero(moduleTag, this.tradeoffName);
        }

        public String getTradeoffName() {
            return this.tradeoffName;
        }
    }

    public static class PropertyModifierIntLinearAdditive
    extends PropertyModifierLinearAdditive {
        protected int roundTo = 1;
        protected int offset = 0;

        public PropertyModifierIntLinearAdditive(String tradeoffName, double multiplier, int roundTo, int offset) {
            super(tradeoffName, multiplier);
            this.roundTo = roundTo;
            this.offset = offset;
        }

        @Override
        public double applyModifier(CompoundNBT moduleTag, double value) {
            long result = (long)(value + this.multiplier * TagUtils.getDoubleOrZero(moduleTag, this.tradeoffName));
            return this.roundWithOffset(result, this.roundTo, this.offset);
        }

        public double getScaledDouble(CompoundNBT moduleTag, double value) {
            double scaledVal = this.applyModifier(moduleTag, value);
            double ret = (scaledVal - value) / this.multiplier;
            TagUtils.setDoubleOrRemove(moduleTag, this.tradeoffName, ret);
            return ret;
        }

        public long roundWithOffset(double input, int roundTo, int offset) {
            return Math.round((input + (double)offset) / (double)roundTo) * (long)roundTo - (long)offset;
        }

        public int getRoundTo() {
            return this.roundTo;
        }

        public int getOffset() {
            return this.offset;
        }
    }

    public static class PropertyModifierFlatAdditive
    implements IPropertyModifier {
        public double valueAdded;

        public PropertyModifierFlatAdditive(double valueAdded) {
            this.valueAdded = valueAdded;
        }

        @Override
        public double applyModifier(CompoundNBT moduleTag, double value) {
            return value + this.valueAdded;
        }
    }

    public static interface IPropertyModifier {
        public double applyModifier(CompoundNBT var1, double var2);
    }
}

