/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.common.container;

import com.mojang.blaze3d.matrix.MatrixStack;
import lehjr.numina.client.gui.slot.IconSlotItemHandler;
import lehjr.numina.client.render.IconUtils;
import lehjr.numina.common.base.NuminaObjects;
import lehjr.numina.common.blockentity.ChargingBaseTileEntity;
import lehjr.numina.common.capabilities.energy.BlockEnergyStorage;
import lehjr.numina.common.math.Colour;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.IntReferenceHolder;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class ChargingBaseMenu
extends Container {
    private TileEntity blockEntity;
    private PlayerEntity player;
    private IItemHandler playerInventory;

    public ChargingBaseMenu(int windowID, BlockPos pos, PlayerInventory playerInventory) {
        super((ContainerType)NuminaObjects.CHARGING_BASE_CONTAINER_TYPE.get(), windowID);
        Slot slot;
        int col;
        this.player = playerInventory.field_70458_d;
        this.blockEntity = this.player.field_70170_p.func_175625_s(pos);
        this.playerInventory = new InvWrapper((IInventory)playerInventory);
        if (this.blockEntity != null) {
            this.blockEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(h -> this.func_75146_a((Slot)new IconSlotItemHandler((IItemHandler)h, 0, 79, 35){

                @Override
                public void drawIconAt(MatrixStack matrixStack, double posX, double posY, Colour colour) {
                    IconUtils.getIcon().energyStorageBackground.renderIconScaledWithColour(matrixStack, posX, posY, 16.0, 16.0, Colour.WHITE);
                }
            }));
        }
        for (int row = 0; row < 3; ++row) {
            for (col = 0; col < 9; ++col) {
                slot = this.func_75146_a(new Slot((IInventory)playerInventory, col + row * 9 + 9, 8 + col * 18, 84 + row * 18));
            }
        }
        for (col = 0; col < 9; ++col) {
            slot = this.func_75146_a(new Slot((IInventory)playerInventory, col, 8 + col * 18, 142));
        }
        this.trackPower();
    }

    private void trackPower() {
        this.func_216958_a(new IntReferenceHolder(){

            public int func_221495_b() {
                return ChargingBaseMenu.this.getTileEnergy() & 0xFFFF;
            }

            public void func_221494_a(int value) {
                if (ChargingBaseMenu.this.blockEntity instanceof ChargingBaseTileEntity) {
                    ((ChargingBaseTileEntity)ChargingBaseMenu.this.blockEntity).getTileEnergyHandler().ifPresent(h -> {
                        int energyStored = h.getEnergyStored() & 0xFFFF0000;
                        ((BlockEnergyStorage)((Object)h)).setEnergy(energyStored + (value & 0xFFFF));
                    });
                }
            }
        });
        this.func_216958_a(new IntReferenceHolder(){

            public int func_221495_b() {
                return ChargingBaseMenu.this.getTileEnergy() >> 16 & 0xFFFF;
            }

            public void func_221494_a(int value) {
                if (ChargingBaseMenu.this.blockEntity instanceof ChargingBaseTileEntity) {
                    ((ChargingBaseTileEntity)ChargingBaseMenu.this.blockEntity).getTileEnergyHandler().ifPresent(h -> {
                        int energyStored = h.getEnergyStored() & 0xFFFF;
                        ((BlockEnergyStorage)((Object)h)).setEnergy(energyStored | value << 16);
                    });
                }
            }
        });
    }

    public int getEnergy() {
        return this.blockEntity.getCapability(CapabilityEnergy.ENERGY).map(IEnergyStorage::getEnergyStored).orElse(0);
    }

    public int getMaxEnergy() {
        return this.blockEntity.getCapability(CapabilityEnergy.ENERGY).map(IEnergyStorage::getMaxEnergyStored).orElse(0);
    }

    public float getEnergyForMeter() {
        return this.blockEntity.getCapability(CapabilityEnergy.ENERGY).map(energy -> Float.valueOf((float)energy.getEnergyStored() / (float)energy.getMaxEnergyStored())).orElse(Float.valueOf(0.0f)).floatValue();
    }

    public int getTileEnergy() {
        return this.blockEntity instanceof ChargingBaseTileEntity ? ((ChargingBaseTileEntity)this.blockEntity).getTileEnergyHandler().map(IEnergyStorage::getEnergyStored).orElse(0) : 0;
    }

    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack stack = slot.func_75211_c();
            itemstack = stack.func_77946_l();
            if (index == 0) {
                if (!this.func_75135_a(stack, 1, 37, true)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(stack, itemstack);
            } else if (this.blockEntity != null && this.blockEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).map(h -> h.isItemValid(0, stack)).orElse(false) != false ? !this.func_75135_a(stack, 0, 1, false) : (index < 28 ? !this.func_75135_a(stack, 28, 37, false) : index < 37 && !this.func_75135_a(stack, 1, 28, false))) {
                return ItemStack.field_190927_a;
            }
            if (stack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (stack.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(playerIn, stack);
        }
        return itemstack;
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return ChargingBaseMenu.func_216963_a((IWorldPosCallable)IWorldPosCallable.func_221488_a((World)this.blockEntity.func_145831_w(), (BlockPos)this.blockEntity.func_174877_v()), (PlayerEntity)this.player, (Block)((Block)NuminaObjects.CHARGING_BASE_BLOCK.get()));
    }
}

