/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.common.integration.scannable;

import java.util.Optional;
import lehjr.numina.common.capabilities.inventory.modechanging.IModeChangingItem;
import lehjr.numina.common.item.ItemUtils;
import li.cil.scannable.common.Scannable;
import li.cil.scannable.common.inventory.ItemHandlerScanner;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class MPSContainerScanner
extends Container {
    private final PlayerEntity player;
    private final Hand hand;
    private final ItemStack tool;
    private final ItemHandlerScanner itemHandler;

    public static MPSContainerScanner createForServer(int windowId, PlayerInventory inventory, Hand hand, ItemHandlerScanner itemHandler) {
        return new MPSContainerScanner(windowId, inventory, hand, itemHandler);
    }

    public static MPSContainerScanner createForClient(int windowId, PlayerInventory inventory, PacketBuffer buffer) {
        Hand hand = (Hand)buffer.func_179257_a(Hand.class);
        return new MPSContainerScanner(windowId, inventory, hand, new ItemHandlerScanner(ItemUtils.getActiveModuleOrEmpty(inventory.field_70458_d.func_184586_b(hand))));
    }

    public MPSContainerScanner(int windowId, PlayerInventory inventory, Hand hand, ItemHandlerScanner itemHandler) {
        super((ContainerType)Scannable.SCANNER_CONTAINER.get(), windowId);
        int slot;
        this.itemHandler = itemHandler;
        this.player = inventory.field_70458_d;
        this.hand = hand;
        this.tool = this.player.func_184586_b(hand);
        IItemHandler activeModules = itemHandler.getActiveModules();
        for (int slot2 = 0; slot2 < activeModules.getSlots(); ++slot2) {
            this.func_75146_a((Slot)new SlotItemHandler(activeModules, slot2, 62 + slot2 * 18, 20){

                public void func_75218_e() {
                    super.func_75218_e();
                    MPSContainerScanner.this.update();
                }
            });
        }
        IItemHandler storedModules = itemHandler.getInactiveModules();
        for (slot = 0; slot < storedModules.getSlots(); ++slot) {
            this.func_75146_a((Slot)new SlotItemHandler(storedModules, slot, 62 + slot * 18, 46){

                public void func_75218_e() {
                    super.func_75218_e();
                    MPSContainerScanner.this.update();
                }
            });
        }
        for (slot = 0; slot < 3; ++slot) {
            for (int col = 0; col < 9; ++col) {
                this.func_75146_a(new Slot((IInventory)inventory, col + slot * 9 + 9, 8 + col * 18, slot * 18 + 77));
            }
        }
        for (slot = 0; slot < 9; ++slot) {
            this.func_75146_a(new Slot((IInventory)inventory, slot, 8 + slot * 18, 135));
        }
    }

    public Hand getHand() {
        return this.hand;
    }

    public boolean func_75145_c(PlayerEntity player) {
        return player == this.player && ItemStack.func_77989_b((ItemStack)this.tool, (ItemStack)player.func_184586_b(this.hand));
    }

    public ItemStack func_82846_b(PlayerEntity player, int index) {
        Slot into;
        int i;
        int begin;
        int step;
        Slot from = (Slot)this.field_75151_b.get(index);
        if (from == null) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = from.func_75211_c().func_77946_l();
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        boolean intoPlayerInventory = from.field_75224_c != player.field_71071_by;
        ItemStack fromStack = from.func_75211_c();
        if (intoPlayerInventory) {
            step = -1;
            begin = this.field_75151_b.size() - 1;
        } else {
            step = 1;
            begin = 0;
        }
        if (fromStack.func_77976_d() > 1) {
            for (i = begin; i >= 0 && i < this.field_75151_b.size(); i += step) {
                int itemsMoved;
                int maxSizeInSlot;
                int spaceInSlot;
                boolean itemsAreEqual;
                ItemStack intoStack;
                into = (Slot)this.field_75151_b.get(i);
                if (into.field_75224_c == from.field_75224_c || (intoStack = into.func_75211_c()).func_190926_b()) continue;
                boolean bl = itemsAreEqual = fromStack.func_77969_a(intoStack) && ItemStack.func_77970_a((ItemStack)fromStack, (ItemStack)intoStack);
                if (!itemsAreEqual || (spaceInSlot = (maxSizeInSlot = Math.min(fromStack.func_77976_d(), into.func_178170_b(stack))) - intoStack.func_190916_E()) <= 0 || (itemsMoved = Math.min(spaceInSlot, fromStack.func_190916_E())) <= 0) continue;
                intoStack.func_190917_f(from.func_75209_a(itemsMoved).func_190916_E());
                into.func_75218_e();
                if (from.func_75211_c().func_190926_b()) break;
            }
        }
        for (i = begin; i >= 0 && i < this.field_75151_b.size() && !from.func_75211_c().func_190926_b(); i += step) {
            into = (Slot)this.field_75151_b.get(i);
            if (into.field_75224_c == from.field_75224_c || into.func_75216_d() || !into.func_75214_a(fromStack)) continue;
            int maxSizeInSlot = Math.min(fromStack.func_77976_d(), into.func_178170_b(fromStack));
            int itemsMoved = Math.min(maxSizeInSlot, fromStack.func_190916_E());
            into.func_75215_d(from.func_75209_a(itemsMoved));
        }
        return from.func_75211_c().func_190916_E() < stack.func_190916_E() ? from.func_75211_c() : ItemStack.field_190927_a;
    }

    void update() {
        ItemStack tool = this.player.field_71071_by.func_70301_a(this.player.field_71071_by.field_70461_c);
        Optional<IModeChangingItem> modeChangingItem = tool.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).filter(IModeChangingItem.class::isInstance).map(IModeChangingItem.class::cast);
        modeChangingItem.ifPresent(iModeChangingItem -> {
            int activeModule = iModeChangingItem.getActiveMode();
            ItemStack module = iModeChangingItem.getActiveModule();
            module.func_77983_a("items", (INBT)this.itemHandler.serializeNBT());
            iModeChangingItem.setStackInSlot(activeModule, module);
        });
    }
}

