/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.block.blocks;

import javax.annotation.Nullable;
import net.mehvahdjukaar.selene.blocks.WaterBlock;
import net.mehvahdjukaar.supplementaries.block.BlockProperties;
import net.mehvahdjukaar.supplementaries.block.tiles.BookPileBlockTile;
import net.mehvahdjukaar.supplementaries.common.ModTags;
import net.mehvahdjukaar.supplementaries.compat.CompatHandler;
import net.mehvahdjukaar.supplementaries.compat.quark.QuarkPlugin;
import net.mehvahdjukaar.supplementaries.configs.ServerConfigs;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.WritableBookItem;
import net.minecraft.item.WrittenBookItem;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class BookPileBlock
extends WaterBlock {
    private static final VoxelShape SHAPE_1 = Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)4.0, (double)13.0);
    private static final VoxelShape SHAPE_2 = Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)8.0, (double)13.0);
    private static final VoxelShape SHAPE_3 = Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)12.0, (double)13.0);
    private static final VoxelShape SHAPE_4 = Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    public static final IntegerProperty BOOKS = BlockProperties.BOOKS;

    public BookPileBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)BOOKS, (Comparable)Integer.valueOf(1)));
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity entity2, ItemStack stack) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof BookPileBlockTile) {
            ItemStack copy = stack.func_77946_l();
            copy.func_190920_e(1);
            ((IInventory)te).func_70299_a((Integer)state.func_177229_b((Property)BOOKS) - 1, copy);
        }
    }

    public boolean isAcceptedItem(Item i) {
        return BookPileBlock.isEnchantedBook(i) || ServerConfigs.cached.MIXED_BOOKS && BookPileBlock.isNormalBook(i);
    }

    public static boolean isEnchantedBook(Item i) {
        return i == Items.field_151134_bR || BookPileBlock.isQuarkTome(i);
    }

    public static boolean isNormalBook(Item i) {
        return i.func_206844_a(ModTags.BOOKS) || ServerConfigs.cached.WRITTEN_BOOKS && BookPileBlock.isWrittenBook(i);
    }

    public static boolean isWrittenBook(Item i) {
        return i instanceof WrittenBookItem || i instanceof WritableBookItem;
    }

    public static boolean isQuarkTome(Item i) {
        return CompatHandler.quark && QuarkPlugin.isTome(i);
    }

    public boolean func_196253_a(BlockState state, BlockItemUseContext context) {
        Item item2;
        if ((Integer)state.func_177229_b((Property)BOOKS) < 4 && this.isAcceptedItem(item2 = context.func_195996_i().func_77973_b())) {
            return true;
        }
        return super.func_196253_a(state, context);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{BOOKS});
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState blockstate = context.func_195991_k().func_180495_p(context.func_195995_a());
        if (blockstate.func_177230_c() instanceof BookPileBlock) {
            return (BlockState)blockstate.func_206870_a((Property)BOOKS, (Comparable)Integer.valueOf((Integer)blockstate.func_177229_b((Property)BOOKS) + 1));
        }
        return super.func_196258_a(context);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new BookPileBlockTile(false);
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileEntity tileentity = world.func_175625_s(pos);
            if (tileentity instanceof BookPileBlockTile) {
                InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)((IInventory)tileentity));
                world.func_175666_e(pos, (Block)this);
            }
            super.func_196243_a(state, world, pos, newState, isMoving);
        }
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof BookPileBlockTile) {
            return ((IInventory)tileentity).func_70301_a(Math.max(0, (Integer)state.func_177229_b((Property)BOOKS) - 1));
        }
        return Items.field_151122_aG.func_190903_i();
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        switch ((Integer)state.func_177229_b((Property)BOOKS)) {
            default: {
                return SHAPE_1;
            }
            case 2: {
                return SHAPE_2;
            }
            case 3: {
                return SHAPE_3;
            }
            case 4: 
        }
        return SHAPE_4;
    }

    public float getEnchantPowerBonus(BlockState state, IWorldReader world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof BookPileBlockTile) {
            return ((BookPileBlockTile)te).getEnchantPower();
        }
        return 0.0f;
    }
}

