/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.block.blocks;

import java.util.Collections;
import java.util.List;
import net.mehvahdjukaar.selene.blocks.WaterBlock;
import net.mehvahdjukaar.supplementaries.block.BlockProperties;
import net.mehvahdjukaar.supplementaries.block.tiles.PresentBlockTile;
import net.mehvahdjukaar.supplementaries.block.util.IColored;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.piglin.PiglinTasks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.LockableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class PresentBlock
extends WaterBlock
implements IColored {
    public static final BooleanProperty PACKED = BlockProperties.PACKED;
    private final DyeColor color;
    public static final VoxelShape SHAPE_OPEN = Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)10.0, (double)14.0);
    public static final VoxelShape SHAPE_CLOSED = VoxelShapes.func_197872_a((VoxelShape)SHAPE_OPEN, (VoxelShape)Block.func_208617_a((double)1.0, (double)10.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0));

    @Override
    @Nullable
    public DyeColor getColor() {
        return this.color;
    }

    public PresentBlock(DyeColor color, AbstractBlock.Properties properties) {
        super(properties);
        this.color = color;
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)PACKED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{PACKED, WATERLOGGED});
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new PresentBlockTile();
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (worldIn.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        if (player.func_175149_v()) {
            return ActionResultType.CONSUME;
        }
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof PresentBlockTile) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((INamedContainerProvider)tileentity), (BlockPos)tileentity.func_174877_v());
            PiglinTasks.func_234478_a_((PlayerEntity)player, (boolean)true);
            return ActionResultType.CONSUME;
        }
        return ActionResultType.PASS;
    }

    public ItemStack getPresentItem(PresentBlockTile te) {
        CompoundNBT compoundnbt = te.func_189515_b(new CompoundNBT());
        ItemStack itemstack = new ItemStack((IItemProvider)this.getBlock());
        if (!compoundnbt.isEmpty()) {
            itemstack.func_77983_a("BlockEntityTag", (INBT)compoundnbt);
        }
        if (te.func_145818_k_()) {
            itemstack.func_200302_a(te.func_200201_e());
        }
        return itemstack;
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof PresentBlockTile) {
            PresentBlockTile te = (PresentBlockTile)tileentity;
            if (!worldIn.field_72995_K && player.func_184812_l_() && !te.func_191420_l()) {
                ItemStack itemstack = this.getPresentItem(te);
                ItemEntity itementity = new ItemEntity(worldIn, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, itemstack);
                itementity.func_174869_p();
                worldIn.func_217376_c((Entity)itementity);
            } else {
                te.func_184281_d(player);
            }
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        TileEntity tileentity = (TileEntity)builder.func_216019_b(LootParameters.field_216288_h);
        if (tileentity instanceof PresentBlockTile) {
            PresentBlockTile te = (PresentBlockTile)tileentity;
            ItemStack itemstack = this.getPresentItem(te);
            return Collections.singletonList(itemstack);
        }
        return super.func_220076_a(state, builder);
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        ItemStack itemstack = super.getPickBlock(state, target, world, pos, player);
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof PresentBlockTile) {
            return this.getPresentItem((PresentBlockTile)te);
        }
        return itemstack;
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        TileEntity tileentity;
        if (stack.func_82837_s() && (tileentity = worldIn.func_175625_s(pos)) instanceof PresentBlockTile) {
            ((LockableTileEntity)tileentity).func_213903_a(stack.func_200301_q());
        }
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.DESTROY;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        if (((Boolean)state.func_177229_b((Property)PACKED)).booleanValue()) {
            return SHAPE_CLOSED;
        }
        return SHAPE_OPEN;
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.func_203425_a(newState.func_177230_c())) {
            TileEntity tileentity = worldIn.func_175625_s(pos);
            if (tileentity instanceof PresentBlockTile) {
                worldIn.func_175666_e(pos, state.func_177230_c());
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        return Container.func_178144_a((TileEntity)worldIn.func_175625_s(pos));
    }

    public INamedContainerProvider func_220052_b(BlockState state, World worldIn, BlockPos pos) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        return tileentity instanceof INamedContainerProvider ? (INamedContainerProvider)tileentity : null;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        CompoundNBT t;
        BlockState state = super.func_196258_a(context);
        CompoundNBT tag = context.func_195996_i().func_77978_p();
        if (tag != null && tag.func_74764_b("BlockEntityTag") && (t = tag.func_74775_l("BlockEntityTag")).func_74764_b("Items")) {
            state = (BlockState)state.func_206870_a((Property)PACKED, (Comparable)Boolean.valueOf(true));
        }
        return state;
    }
}

