/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.gui;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.fonts.TextInputUtil;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.Util;
import net.minecraft.util.text.CharacterManager;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableInt;

public class MultiLineEditBoxWidget
extends Widget {
    protected final int x1;
    protected final int y1;
    protected final Minecraft minecraft;
    protected final FontRenderer font;
    protected final TextInputUtil pageEdit;
    @Nullable
    private Consumer<Boolean> onOutOfBounds = null;
    @Nonnull
    private String text = "";
    private int frameTick;
    private long lastClickTime;
    private int lastIndex = -1;
    @Nullable
    private DisplayCache displayCache = DisplayCache.EMPTY;

    public MultiLineEditBoxWidget(Minecraft mc, int x, int y, int width, int height) {
        super(x, y, width, height, (ITextComponent)new StringTextComponent("hhhhh"));
        this.minecraft = mc;
        this.font = mc.field_71466_p;
        this.x1 = x + width;
        this.y1 = y + height;
        this.pageEdit = new TextInputUtil(this::getText, this::setText, this::getClipboard, this::setClipboard, this::isStringValid);
        this.clearDisplayCache();
    }

    public void setOutOfBoundResponder(Consumer<Boolean> onOutOfBounds) {
        this.onOutOfBounds = onOutOfBounds;
    }

    public void setState(boolean hasItem, boolean packed) {
        this.func_230996_d_(false);
        if (packed) {
            this.field_230693_o_ = false;
        } else {
            this.field_230693_o_ = hasItem;
            if (!hasItem) {
                this.setText("");
            }
        }
    }

    private boolean isStringValid(String s) {
        if (s != null && s.length() < 256) {
            if (s.endsWith("\n")) {
                s = s + "-";
            }
            return this.font.func_78267_b(s, this.field_230688_j_) <= this.field_230689_k_;
        }
        return false;
    }

    private void setClipboard(String p_98148_) {
        if (this.minecraft != null) {
            TextInputUtil.func_238571_a_((Minecraft)this.minecraft, (String)p_98148_);
        }
    }

    private String getClipboard() {
        return this.minecraft != null ? TextInputUtil.func_238576_b_((Minecraft)this.minecraft) : "";
    }

    public void tick() {
        ++this.frameTick;
    }

    public boolean func_231042_a_(char c, int key) {
        if (this.canConsumeInput() && SharedConstants.func_71566_a((char)c)) {
            this.pageEdit.func_216892_a(Character.toString(c));
            this.clearDisplayCache();
            return true;
        }
        return false;
    }

    public boolean canConsumeInput() {
        return this.func_230999_j_() && this.field_230693_o_;
    }

    public boolean func_231046_a_(int key, int alt, int ctrl) {
        if (this.canConsumeInput() && this.bookKeyPressed(key, alt, ctrl)) {
            this.clearDisplayCache();
            return true;
        }
        return false;
    }

    private boolean bookKeyPressed(int key, int alt, int ctrl) {
        if (Screen.func_231170_j_((int)key)) {
            this.pageEdit.func_238585_d_();
            return true;
        }
        if (Screen.func_231169_i_((int)key)) {
            this.pageEdit.func_238580_c_();
            return true;
        }
        if (Screen.func_231168_h_((int)key)) {
            this.pageEdit.func_238574_b_();
            return true;
        }
        if (Screen.func_231166_g_((int)key)) {
            this.pageEdit.func_238567_a_();
            return true;
        }
        switch (key) {
            case 257: 
            case 335: {
                int p = this.pageEdit.func_216896_c();
                this.pageEdit.func_216892_a("\n");
                if (p == this.pageEdit.func_216896_c()) {
                    this.callOutOfBounds(false);
                }
                return true;
            }
            case 259: {
                this.pageEdit.func_238586_d_(-1);
                return true;
            }
            case 261: {
                this.pageEdit.func_238586_d_(1);
                return true;
            }
            case 262: {
                this.pageEdit.func_238569_a_(1, Screen.func_231173_s_());
                return true;
            }
            case 263: {
                this.pageEdit.func_238569_a_(-1, Screen.func_231173_s_());
                return true;
            }
            case 264: {
                this.keyDown();
                return true;
            }
            case 265: {
                this.keyUp();
                return true;
            }
            case 268: {
                this.keyHome();
                return true;
            }
            case 269: {
                this.moveCursorToEnd();
                return true;
            }
        }
        return false;
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double amount) {
        if (this.canConsumeInput() && this.field_230694_p_) {
            if (amount >= 1.0) {
                this.keyUp();
                this.clearDisplayCache();
                return true;
            }
            if (amount <= -1.0) {
                this.keyDown();
                this.clearDisplayCache();
                return true;
            }
        }
        return false;
    }

    private void callOutOfBounds(boolean up) {
        if (this.onOutOfBounds != null) {
            this.onOutOfBounds.accept(up);
        }
    }

    private void keyUp() {
        this.changeLine(-1);
    }

    private void keyDown() {
        this.changeLine(1);
    }

    private void changeLine(int amount) {
        int i = this.pageEdit.func_216896_c();
        int j = this.getDisplayCache().changeLine(i, amount);
        this.pageEdit.func_238581_c_(j, Screen.func_231173_s_());
        if (i == j) {
            this.callOutOfBounds(amount < 0);
        }
    }

    private void keyHome() {
        int i = this.pageEdit.func_216896_c();
        int j = this.getDisplayCache().findLineStart(i);
        this.pageEdit.func_238581_c_(j, Screen.func_231173_s_());
    }

    public void moveCursorToEnd() {
        DisplayCache displayCache = this.getDisplayCache();
        int i = this.pageEdit.func_216896_c();
        int j = displayCache.findLineEnd(i);
        this.pageEdit.func_238581_c_(j, Screen.func_231173_s_());
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        this.clearDisplayCache();
        this.onValueChanged();
    }

    public void onValueChanged() {
    }

    public void func_230430_a_(MatrixStack poseStack, int mouseX, int museY, float partialTicks) {
        if (this.field_230694_p_) {
            DisplayCache displayCache = this.getDisplayCache();
            for (LineInfo lineInfo : displayCache.lines) {
                this.font.func_243248_b(poseStack, lineInfo.asComponent, (float)lineInfo.x, (float)lineInfo.y, -16777216);
            }
            if (this.func_230999_j_()) {
                this.renderHighlight(displayCache.selection);
                this.renderCursor(poseStack, displayCache.cursor, displayCache.cursorAtEnd);
            }
        }
    }

    private void renderCursor(MatrixStack poseStack, Pos2i pos2i, boolean p_98111_) {
        if (this.frameTick / 6 % 2 == 0) {
            pos2i = this.convertLocalToScreen(pos2i);
            if (!p_98111_) {
                AbstractGui.func_238467_a_((MatrixStack)poseStack, (int)pos2i.x, (int)(pos2i.y - 1), (int)(pos2i.x + 1), (int)(pos2i.y + 9), (int)-16777216);
            } else {
                this.font.func_238421_b_(poseStack, "_", (float)pos2i.x, (float)pos2i.y, 0);
            }
        }
    }

    private void renderHighlight(Rectangle2d[] pSelected) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        RenderSystem.color4f((float)0.0f, (float)0.0f, (float)255.0f, (float)255.0f);
        RenderSystem.disableTexture();
        RenderSystem.enableColorLogicOp();
        RenderSystem.logicOp((GlStateManager.LogicOp)GlStateManager.LogicOp.OR_REVERSE);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        for (Rectangle2d rectangle2d : pSelected) {
            int i = rectangle2d.func_199318_a();
            int j = rectangle2d.func_199319_b();
            int k = i + rectangle2d.func_199316_c();
            int l = j + rectangle2d.func_199317_d();
            bufferbuilder.func_225582_a_((double)i, (double)l, 0.0).func_181675_d();
            bufferbuilder.func_225582_a_((double)k, (double)l, 0.0).func_181675_d();
            bufferbuilder.func_225582_a_((double)k, (double)j, 0.0).func_181675_d();
            bufferbuilder.func_225582_a_((double)i, (double)j, 0.0).func_181675_d();
        }
        tessellator.func_78381_a();
        RenderSystem.disableColorLogicOp();
        RenderSystem.enableTexture();
    }

    private Pos2i convertScreenToLocal(Pos2i pos2i) {
        return new Pos2i(pos2i.x - this.field_230690_l_, pos2i.y - this.field_230691_m_);
    }

    private Pos2i convertLocalToScreen(Pos2i pos2i) {
        return new Pos2i(pos2i.x + this.field_230690_l_, pos2i.y + this.field_230691_m_);
    }

    public void func_230996_d_(boolean b) {
        super.func_230996_d_(b);
    }

    public void func_230982_a_(double mouseX, double mouseY) {
        this.func_230996_d_(true);
    }

    public boolean func_230992_c_(double mouseX, double mouseY) {
        if (this.func_231047_b_(mouseX, mouseY)) {
            long i = Util.func_211177_b();
            DisplayCache displayCache = this.getDisplayCache();
            int j = displayCache.getIndexAtPosition(this.font, this.convertScreenToLocal(new Pos2i((int)mouseX, (int)mouseY)));
            if (j >= 0) {
                if (j == this.lastIndex && i - this.lastClickTime < 250L) {
                    if (!this.pageEdit.func_238590_i_()) {
                        this.selectWord(j);
                    } else {
                        this.pageEdit.func_238585_d_();
                    }
                } else {
                    this.pageEdit.func_238581_c_(j, Screen.func_231173_s_());
                }
                this.clearDisplayCache();
            }
            this.lastIndex = j;
            this.lastClickTime = i;
            return true;
        }
        return false;
    }

    private void selectWord(int p_98142_) {
        String s = this.getText();
        this.pageEdit.func_238568_a_(CharacterManager.func_238351_a_((String)s, (int)-1, (int)p_98142_, (boolean)false), CharacterManager.func_238351_a_((String)s, (int)1, (int)p_98142_, (boolean)false));
    }

    public void func_230983_a_(double mouseX, double mouseY, double dx, double dy) {
        DisplayCache displayCache = this.getDisplayCache();
        int i = displayCache.getIndexAtPosition(this.font, this.convertScreenToLocal(new Pos2i((int)mouseX, (int)mouseY)));
        this.pageEdit.func_238581_c_(i, true);
        this.clearDisplayCache();
    }

    protected DisplayCache getDisplayCache() {
        if (this.displayCache == null) {
            this.displayCache = this.rebuildDisplayCache();
        }
        return this.displayCache;
    }

    protected void clearDisplayCache() {
        this.displayCache = null;
    }

    private DisplayCache rebuildDisplayCache() {
        Pos2i pos2i;
        boolean flag;
        String s = this.getText();
        if (s.isEmpty()) {
            return DisplayCache.EMPTY;
        }
        int i = this.pageEdit.func_216896_c();
        int j = this.pageEdit.func_216898_d();
        IntArrayList intlist = new IntArrayList();
        ArrayList list = Lists.newArrayList();
        MutableInt mutableint = new MutableInt();
        MutableBoolean mutableboolean = new MutableBoolean();
        CharacterManager stringsplitter = this.font.func_238420_b_();
        stringsplitter.func_238353_a_(s, this.field_230688_j_, Style.field_240709_b_, true, (arg_0, arg_1, arg_2) -> this.lambda$rebuildDisplayCache$0(mutableint, s, mutableboolean, (IntList)intlist, list, arg_0, arg_1, arg_2));
        int[] toIntArray = intlist.toIntArray();
        boolean bl = flag = i == s.length();
        if (flag && mutableboolean.isTrue()) {
            pos2i = new Pos2i(0, list.size() * 9);
        } else {
            int k = MultiLineEditBoxWidget.findLineFromPos(toIntArray, i);
            int l = this.font.func_78256_a(s.substring(toIntArray[k], i));
            pos2i = new Pos2i(l, k * 9);
        }
        ArrayList list1 = Lists.newArrayList();
        if (i != j) {
            int k1;
            int l2 = Math.min(i, j);
            int i1 = Math.max(i, j);
            int j1 = MultiLineEditBoxWidget.findLineFromPos(toIntArray, l2);
            if (j1 == (k1 = MultiLineEditBoxWidget.findLineFromPos(toIntArray, i1))) {
                int l1 = j1 * 9;
                int i2 = toIntArray[j1];
                list1.add(this.createPartialLineSelection(s, stringsplitter, l2, i1, l1, i2));
            } else {
                int i3 = j1 + 1 > toIntArray.length ? s.length() : toIntArray[j1 + 1];
                list1.add(this.createPartialLineSelection(s, stringsplitter, l2, i3, j1 * 9, toIntArray[j1]));
                for (int j3 = j1 + 1; j3 < k1; ++j3) {
                    int j2 = j3 * 9;
                    String s1 = s.substring(toIntArray[j3], toIntArray[j3 + 1]);
                    int k2 = (int)stringsplitter.func_238350_a_(s1);
                    list1.add(this.createSelection(new Pos2i(0, j2), new Pos2i(k2, j2 + 9)));
                }
                list1.add(this.createPartialLineSelection(s, stringsplitter, toIntArray[k1], i1, k1 * 9, toIntArray[k1]));
            }
        }
        return new DisplayCache(s, pos2i, flag, toIntArray, list.toArray(new LineInfo[0]), list1.toArray(new Rectangle2d[0]));
    }

    static int findLineFromPos(int[] p_98150_, int p_98151_) {
        int i = Arrays.binarySearch(p_98150_, p_98151_);
        return i < 0 ? -(i + 2) : i;
    }

    private Rectangle2d createPartialLineSelection(String p_98120_, CharacterManager p_98121_, int p_98122_, int p_98123_, int p_98124_, int p_98125_) {
        String s = p_98120_.substring(p_98125_, p_98122_);
        String s1 = p_98120_.substring(p_98125_, p_98123_);
        Pos2i pos2i = new Pos2i((int)p_98121_.func_238350_a_(s), p_98124_);
        Pos2i pos2i1 = new Pos2i((int)p_98121_.func_238350_a_(s1), p_98124_ + 9);
        return this.createSelection(pos2i, pos2i1);
    }

    private Rectangle2d createSelection(Pos2i p_98117_, Pos2i p_98118_) {
        Pos2i pos2i = this.convertLocalToScreen(p_98117_);
        Pos2i pos2i1 = this.convertLocalToScreen(p_98118_);
        int i = Math.min(pos2i.x, pos2i1.x);
        int j = Math.max(pos2i.x, pos2i1.x);
        int k = Math.min(pos2i.y, pos2i1.y);
        int l = Math.max(pos2i.y, pos2i1.y);
        return new Rectangle2d(i, k, j - i, l - k);
    }

    private /* synthetic */ void lambda$rebuildDisplayCache$0(MutableInt mutableint, String s, MutableBoolean mutableboolean, IntList intlist, List list, Style lineInfo, int p_98133_, int p_98134_) {
        int k3 = mutableint.getAndIncrement();
        String s2 = s.substring(p_98133_, p_98134_);
        mutableboolean.setValue(s2.endsWith("\n"));
        String s3 = StringUtils.stripEnd((String)s2, (String)" \n");
        int l3 = k3 * 9;
        Pos2i pos2i = this.convertLocalToScreen(new Pos2i(0, l3));
        intlist.add(p_98133_);
        list.add(new LineInfo(lineInfo, s3, pos2i.x, pos2i.y));
    }

    static class Pos2i {
        public final int x;
        public final int y;

        Pos2i(int pX, int pY) {
            this.x = pX;
            this.y = pY;
        }
    }

    static class LineInfo {
        final Style style;
        final String contents;
        final ITextComponent asComponent;
        final int x;
        final int y;

        public LineInfo(Style style, String contents, int x, int y) {
            this.style = style;
            this.contents = contents;
            this.x = x;
            this.y = y;
            this.asComponent = new StringTextComponent(contents).func_230530_a_(style);
        }
    }

    static class DisplayCache {
        static final DisplayCache EMPTY = new DisplayCache("", new Pos2i(0, 0), true, new int[]{0}, new LineInfo[]{new LineInfo(Style.field_240709_b_, "", 0, 0)}, new Rectangle2d[0]);
        private final String fullText;
        final Pos2i cursor;
        final boolean cursorAtEnd;
        private final int[] lineStarts;
        final LineInfo[] lines;
        final Rectangle2d[] selection;

        public DisplayCache(String p_98201_, Pos2i p_98202_, boolean p_98203_, int[] p_98204_, LineInfo[] p_98205_, Rectangle2d[] p_98206_) {
            this.fullText = p_98201_;
            this.cursor = p_98202_;
            this.cursorAtEnd = p_98203_;
            this.lineStarts = p_98204_;
            this.lines = p_98205_;
            this.selection = p_98206_;
        }

        public int getIndexAtPosition(FontRenderer p_98214_, Pos2i p_98215_) {
            int i = p_98215_.y / 9;
            if (i < 0) {
                return 0;
            }
            if (i >= this.lines.length) {
                return this.fullText.length();
            }
            LineInfo lineInfo = this.lines[i];
            return this.lineStarts[i] + p_98214_.func_238420_b_().func_238352_a_(lineInfo.contents, p_98215_.x, lineInfo.style);
        }

        public int changeLine(int p_98211_, int p_98212_) {
            int k;
            int i = MultiLineEditBoxWidget.findLineFromPos(this.lineStarts, p_98211_);
            int j = i + p_98212_;
            if (0 <= j && j < this.lineStarts.length) {
                int l = p_98211_ - this.lineStarts[i];
                int i1 = this.lines[j].contents.length();
                k = this.lineStarts[j] + Math.min(l, i1);
            } else {
                k = p_98211_;
            }
            return k;
        }

        public int findLineStart(int p_98209_) {
            int i = MultiLineEditBoxWidget.findLineFromPos(this.lineStarts, p_98209_);
            return this.lineStarts[i];
        }

        public int findLineEnd(int p_98219_) {
            int i = MultiLineEditBoxWidget.findLineFromPos(this.lineStarts, p_98219_);
            return this.lineStarts[i] + this.lines[i].contents.length();
        }
    }
}

