/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.UUID;
import net.mehvahdjukaar.supplementaries.block.tiles.PresentBlockTile;
import net.mehvahdjukaar.supplementaries.client.gui.MultiLineEditBoxWidget;
import net.mehvahdjukaar.supplementaries.client.gui.PlayerSuggestionBoxWidget;
import net.mehvahdjukaar.supplementaries.common.Textures;
import net.mehvahdjukaar.supplementaries.inventories.PresentContainer;
import net.mehvahdjukaar.supplementaries.network.NetworkHandler;
import net.mehvahdjukaar.supplementaries.network.ServerBoundSetPresentPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.AbstractButton;
import net.minecraft.client.network.play.NetworkPlayerInfo;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class PresentBlockGui
extends ContainerScreen<PresentContainer>
implements IContainerListener {
    private static final int DESCRIPTION_BOX_X = 53;
    private static final int DESCRIPTION_BOX_Y = 33;
    private static final int DESCRIPTION_BOX_H = 36;
    private static final int DESCRIPTION_BOX_W = 105;
    private static final int SUGGESTION_BOX_Y = 19;
    private static final int SUGGESTION_BOX_W = 99;
    private static final int SUGGESTION_BOX_H = 12;
    private final PresentBlockTile tile;
    private PackButton packButton;
    private PlayerSuggestionBoxWidget recipient;
    private MultiLineEditBoxWidget descriptionBox;
    private boolean packed;
    private boolean needsInitialization = true;
    public static ScreenManager.IScreenFactory<PresentContainer, PresentBlockGui> GUI_FACTORY = (container, inventory, title) -> {
        TileEntity te = Minecraft.func_71410_x().field_71441_e.func_175625_s(container.getPos());
        if (te instanceof PresentBlockTile) {
            return new PresentBlockGui((PresentContainer)container, inventory, title, (PresentBlockTile)te);
        }
        return null;
    };

    public PresentBlockGui(PresentContainer container, PlayerInventory inventory, ITextComponent text, PresentBlockTile tile) {
        super((Container)container, inventory, text);
        this.field_146999_f = 176;
        this.field_147000_g = 166;
        this.tile = tile;
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.field_230706_i_.field_195559_v.func_197967_a(true);
        this.field_238742_p_ = (this.field_146999_f - this.field_230712_o_.func_238414_a_((ITextProperties)this.field_230704_d_)) / 2;
        int i = (this.field_230708_k_ - this.field_146999_f) / 2;
        int j = (this.field_230709_l_ - this.field_147000_g) / 2;
        this.packButton = (PackButton)this.func_230480_a_((Widget)new PackButton(i + 14, j + 45));
        this.recipient = (PlayerSuggestionBoxWidget)this.func_230480_a_(new PlayerSuggestionBoxWidget(this.field_230706_i_, i + 53, j + 19, 99, 12));
        this.recipient.setOutOfBoundResponder(up -> {
            if (!up.booleanValue()) {
                this.func_231035_a_((IGuiEventListener)this.descriptionBox);
                this.recipient.func_230996_d_(false);
                this.descriptionBox.func_230996_d_(true);
            }
        });
        this.descriptionBox = (MultiLineEditBoxWidget)this.func_230480_a_(new MultiLineEditBoxWidget(this.field_230706_i_, i + 53, j + 33, 105, 36));
        this.descriptionBox.setOutOfBoundResponder(up -> {
            if (up.booleanValue()) {
                this.func_231035_a_((IGuiEventListener)this.recipient);
                this.recipient.func_230996_d_(true);
                this.descriptionBox.func_230996_d_(false);
            }
        });
        this.func_231035_a_((IGuiEventListener)this.recipient);
        this.recipient.setText(this.tile.getRecipient());
        this.descriptionBox.setText(this.tile.getDescription());
        this.packed = this.tile.isPacked();
        this.updateState();
        ((PresentContainer)this.field_147002_h).func_75132_a(this);
    }

    public void onAddPlayer(NetworkPlayerInfo info) {
        this.recipient.addPlayer(info);
    }

    public void onRemovePlayer(UUID uuid) {
        this.recipient.removePlayer(uuid);
    }

    private void pack() {
        this.updateStateAndTryToPack(true);
    }

    private void updateState() {
        this.updateStateAndTryToPack(false);
    }

    private void updateStateAndTryToPack(boolean tryToPack) {
        boolean hasItem = this.needsInitialization ? this.packed : ((PresentContainer)this.field_147002_h).func_75139_a(0).func_75216_d();
        boolean hasChanged = false;
        if (this.packed && !hasItem) {
            this.packed = false;
            hasChanged = true;
        } else if (tryToPack && !this.packed && hasItem) {
            this.packed = true;
            hasChanged = true;
        }
        if (hasChanged) {
            String sender = Minecraft.func_71410_x().field_71439_g.func_200200_C_().getString();
            String recipient = this.recipient.getText();
            String description = this.descriptionBox.getText();
            NetworkHandler.INSTANCE.sendToServer((Object)new ServerBoundSetPresentPacket(this.tile.func_174877_v(), this.packed, recipient, sender, description));
            this.tile.updateState(this.packed, recipient, sender, description);
            if (this.packed) {
                this.field_230706_i_.field_71439_g.func_175159_q();
            }
        }
        this.recipient.setState(hasItem, this.packed);
        this.packButton.setState(hasItem, this.packed);
        this.descriptionBox.setState(hasItem, this.packed);
    }

    public void func_71110_a(Container container, NonNullList<ItemStack> itemStacks) {
        this.func_71111_a(container, 0, container.func_75139_a(0).func_75211_c());
    }

    public void func_71112_a(Container p_71112_1_, int p_71112_2_, int p_71112_3_) {
    }

    public void func_71111_a(Container container, int slot, ItemStack stack) {
        if (slot == 0) {
            this.updateState();
        }
    }

    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int x, int y) {
        this.func_230446_a_(matrixStack);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(Textures.PRESENT_BLOCK_GUI_TEXTURE);
        int k = (this.field_230708_k_ - this.field_146999_f) / 2;
        int l = (this.field_230709_l_ - this.field_147000_g) / 2;
        this.func_238474_b_(matrixStack, k, l, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    public void func_230430_a_(MatrixStack poseStack, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(poseStack, mouseX, mouseY, partialTicks);
        if (this.packed) {
            int k = (this.field_230708_k_ - this.field_146999_f) / 2;
            int l = (this.field_230709_l_ - this.field_147000_g) / 2;
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(Textures.PRESENT_BLOCK_GUI_TEXTURE);
            Slot slot = ((PresentContainer)this.field_147002_h).func_75139_a(0);
            PresentBlockGui.func_238464_a_((MatrixStack)poseStack, (int)(k + slot.field_75223_e), (int)(l + slot.field_75221_f), (int)400, (float)12.0f, (float)232.0f, (int)16, (int)16, (int)256, (int)256);
        }
        this.func_230459_a_(poseStack, mouseX, mouseY);
    }

    protected void func_230451_b_(MatrixStack poseStack, int x, int y) {
        super.func_230451_b_(poseStack, x, y);
        this.packButton.func_230443_a_(poseStack, x - this.field_147003_i, y - this.field_147009_r);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int key) {
        this.recipient.func_230996_d_(false);
        this.descriptionBox.func_230996_d_(false);
        return super.func_231044_a_(mouseX, mouseY, key);
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double amount) {
        return this.recipient.func_231043_a_(mouseX, mouseY, amount) || this.descriptionBox.func_231043_a_(mouseX, mouseY, amount);
    }

    public boolean func_231046_a_(int key, int a, int b) {
        if (key == 256) {
            this.field_230706_i_.field_71439_g.func_71053_j();
        }
        return this.recipient.func_231046_a_(key, a, b) || this.recipient.canConsumeInput() || this.descriptionBox.func_231046_a_(key, a, b) || this.descriptionBox.canConsumeInput() || super.func_231046_a_(key, a, b);
    }

    public boolean func_231045_a_(double dx, double dy, int key, double mouseX, double mouseY) {
        if (key == 0 && this.descriptionBox.func_231045_a_(dx, dy, key, mouseX, mouseY)) {
            return true;
        }
        return super.func_231045_a_(dx, dy, key, mouseX, mouseY);
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        this.needsInitialization = false;
        this.recipient.tick();
        this.descriptionBox.tick();
    }

    public void func_231164_f_() {
        super.func_231164_f_();
        ((PresentContainer)this.field_147002_h).func_82847_b(this);
        Minecraft.func_71410_x().field_195559_v.func_197967_a(false);
    }

    public class PackButton
    extends AbstractButton {
        private boolean packed;

        protected PackButton(int x, int y) {
            super(x, y, 22, 22, StringTextComponent.field_240750_d_);
        }

        public void func_230431_b_(MatrixStack poseStack, int p_230431_2_, int p_230431_3_, float p_230431_4_) {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(Textures.PRESENT_BLOCK_GUI_TEXTURE);
            int i = 198;
            int j = 0;
            if (!this.field_230693_o_) {
                j += this.field_230688_j_ * 2;
            } else if (this.packed) {
                j += this.field_230688_j_ * 1;
            } else if (this.field_230692_n_) {
                j += this.field_230688_j_ * 3;
            }
            this.func_238474_b_(poseStack, this.field_230690_l_, this.field_230691_m_, j, i, this.field_230688_j_, this.field_230689_k_);
        }

        public void setState(boolean hasItem, boolean packed) {
            this.packed = packed;
            this.field_230693_o_ = hasItem;
        }

        public void func_230443_a_(MatrixStack matrixStack, int x, int y) {
            if (this.field_230693_o_ && this.field_230692_n_ && !this.packed) {
                PresentBlockGui.this.func_238652_a_(matrixStack, (ITextComponent)new TranslationTextComponent("gui.supplementaries.present.pack"), x, y);
            }
        }

        public void func_230930_b_() {
            PresentBlockGui.this.pack();
        }
    }
}

