/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.compat.inspirations;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import knightminer.inspirations.library.recipe.RecipeSerializers;
import knightminer.inspirations.library.recipe.cauldron.CauldronContentTypes;
import knightminer.inspirations.library.recipe.cauldron.contents.ICauldronContents;
import knightminer.inspirations.library.recipe.cauldron.inventory.ICauldronInventory;
import knightminer.inspirations.library.recipe.cauldron.special.DyeableCauldronRecipe;
import knightminer.inspirations.library.recipe.cauldron.util.DisplayCauldronRecipe;
import net.mehvahdjukaar.supplementaries.items.FlagItem;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class CauldronFlagDyeRecipe
extends DyeableCauldronRecipe {
    private List<DisplayCauldronRecipe> displayRecipes;

    public CauldronFlagDyeRecipe(ResourceLocation id, Ingredient ingredient) {
        super(id, ingredient);
    }

    public boolean matches(ICauldronInventory inv, World worldIn) {
        ItemStack stack = inv.getStack();
        return inv.getLevel() >= 4 && this.matches(inv.getContents(), stack);
    }

    public List<DisplayCauldronRecipe> getRecipes() {
        if (this.displayRecipes == null) {
            this.displayRecipes = this.getDisplayRecipes(null).collect(Collectors.toList());
        }
        return this.displayRecipes;
    }

    protected boolean matches(ICauldronContents contents, ItemStack stack) {
        Item i = stack.func_77973_b();
        return i instanceof FlagItem && contents.get(CauldronContentTypes.DYE).filter(color -> ((FlagItem)i).getColor() != color).isPresent();
    }

    protected ItemStack updateColor(ICauldronContents contents, ItemStack stack) {
        CompoundNBT tag = stack.func_77978_p();
        ItemStack newStack = new ItemStack((IItemProvider)ModRegistry.FLAGS.get(contents.get(CauldronContentTypes.DYE).get()).get());
        newStack.func_77982_d(tag);
        return newStack;
    }

    protected Stream<DisplayCauldronRecipe> getDisplayRecipes(ItemStack stack) {
        return Arrays.stream(DyeColor.values()).map(color -> DisplayCauldronRecipe.builder((int)4, (int)0).setItemInputs(Arrays.stream(DyeColor.values()).filter(c -> c != color).map(c -> new ItemStack((IItemProvider)ModRegistry.FLAGS.get(c).get())).collect(Collectors.toList())).setContentInputs(CauldronContentTypes.DYE.of(color)).setItemOutput(new ItemStack((IItemProvider)ModRegistry.FLAGS.get(color).get())).build());
    }

    public IRecipeSerializer<?> func_199559_b() {
        return RecipeSerializers.CAULDRON_REMOVE_BANNER_PATTERN;
    }
}

