/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.world.structures;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import net.mehvahdjukaar.supplementaries.configs.ServerConfigs;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.SectionPos;
import net.minecraft.world.IStructureReader;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class StructureLocator {
    private static final TreeMap<Float, Pair<Integer, Integer>> CHUNK_POSITIONS = new TreeMap();
    private static final List<Structure<?>> TARGETS = new ArrayList();

    public static void init() {
        for (String name : (List)ServerConfigs.spawn.SIGNS_VILLAGES.get()) {
            ResourceLocation res = new ResourceLocation(name);
            if (!ForgeRegistries.STRUCTURE_FEATURES.containsKey(res)) continue;
            TARGETS.add((Structure<?>)ForgeRegistries.STRUCTURE_FEATURES.getValue(res));
        }
        float range = 25.0f;
        int r = 0;
        while ((float)r <= range) {
            for (int x = -r; x <= r; ++x) {
                boolean edgeX = x == -r || x == r;
                for (int y = -r; y <= r; ++y) {
                    boolean edgeY;
                    boolean bl = edgeY = y == -r || y == r;
                    if (!edgeX && !edgeY) continue;
                    CHUNK_POSITIONS.put(Float.valueOf(MathHelper.func_76129_c((float)(x * x + y * y))), (Pair<Integer, Integer>)new ImmutablePair((Object)x, (Object)y));
                }
            }
            ++r;
        }
    }

    private static int dist(BlockPos pos1, BlockPos pos2) {
        int i = pos2.func_177958_n() - pos1.func_177958_n();
        int j = pos2.func_177952_p() - pos1.func_177952_p();
        return (int)MathHelper.func_76129_c((float)(i * i + j * j));
    }

    private static float distance(BlockPos pos1, BlockPos pos2) {
        int i = pos2.func_177958_n() - pos1.func_177958_n();
        int j = pos2.func_177952_p() - pos1.func_177952_p();
        return MathHelper.func_76129_c((float)(i * i + j * j));
    }

    public static Pair<TreeMap<Float, BlockPos>, Boolean> findFast(ServerWorld world, BlockPos pos, int count) {
        TreeMap<Float, BlockPos> found = new TreeMap<Float, BlockPos>();
        boolean inVillage = false;
        if (world.func_73046_m().func_240793_aU_().func_230418_z_().func_236222_c_()) {
            ChunkGenerator gen = world.func_72863_F().func_201711_g();
            BiomeProvider biomeSource = gen.func_202090_b();
            ArrayList possibleTargets = new ArrayList();
            ArrayList<StructureSeparationSettings> sepSettings = new ArrayList<StructureSeparationSettings>();
            for (Structure<?> str : TARGETS) {
                StructureSeparationSettings sep;
                if (!biomeSource.func_205004_a(str) || (sep = gen.func_235957_b_().func_236197_a_(str)) == null) continue;
                possibleTargets.add(str);
                sepSettings.add(sep);
            }
            if (sepSettings != null) {
                long seed = world.func_72905_C();
                StructureManager manager = world.func_241112_a_();
                int chunkX = pos.func_177958_n() >> 4;
                int chunkY = pos.func_177952_p() >> 4;
                SharedSeedRandom sharedseedrandom = new SharedSeedRandom();
                float lastDist = 0.0f;
                for (float key : CHUNK_POSITIONS.keySet()) {
                    Pair<Integer, Integer> pair = CHUNK_POSITIONS.get(Float.valueOf(key));
                    int x = (Integer)pair.getLeft();
                    int y = (Integer)pair.getRight();
                    for (int ind = 0; ind < possibleTargets.size(); ++ind) {
                        StructureSeparationSettings settings = (StructureSeparationSettings)sepSettings.get(ind);
                        Structure s = (Structure)possibleTargets.get(ind);
                        int spacing = settings.func_236668_a_();
                        int k1 = chunkX + spacing * x;
                        int l1 = chunkY + spacing * y;
                        ChunkPos chunkpos = s.func_236392_a_(settings, seed, sharedseedrandom, k1, l1);
                        IChunk ichunk = world.func_217348_a(chunkpos.field_77276_a, chunkpos.field_77275_b, ChunkStatus.field_222606_b);
                        StructureStart structureStart = manager.func_235013_a_(SectionPos.func_218156_a((ChunkPos)ichunk.func_76632_l(), (int)0), s, (IStructureReader)ichunk);
                        if (structureStart == null || !structureStart.func_75069_d()) continue;
                        BlockPos p = structureStart.func_204294_a();
                        float distance = StructureLocator.distance(pos, p);
                        if (distance > 90.0f) {
                            found.put(Float.valueOf(distance), p);
                        } else {
                            inVillage = true;
                        }
                        if (found.size() != count) continue;
                        lastDist = key;
                    }
                    if (found.size() < count || !((double)key > (double)lastDist + 0.5)) continue;
                    break;
                }
            }
        }
        return new ImmutablePair(found, (Object)inVillage);
    }

    public static Pair<List<Pair<Integer, BlockPos>>, Boolean> find(ServerWorld world, int posX, int posZ, int count) {
        ArrayList<ImmutablePair> found = new ArrayList<ImmutablePair>();
        boolean inVillage = false;
        if (world.func_73046_m().func_240793_aU_().func_230418_z_().func_236222_c_()) {
            ChunkGenerator gen = world.func_72863_F().func_201711_g();
            BiomeProvider biomeSource = gen.func_202090_b();
            ArrayList possibleTargets = new ArrayList();
            ArrayList<StructureSeparationSettings> sepSettings = new ArrayList<StructureSeparationSettings>();
            for (Structure<?> str : TARGETS) {
                StructureSeparationSettings sep;
                if (!biomeSource.func_205004_a(str) || (sep = gen.func_235957_b_().func_236197_a_(str)) == null) continue;
                possibleTargets.add(str);
                sepSettings.add(sep);
            }
            if (sepSettings != null) {
                long seed = world.func_72905_C();
                StructureManager manager = world.func_241112_a_();
                int chunkX = posX >> 4;
                int chunkY = posZ >> 4;
                int range = 25;
                SharedSeedRandom sharedseedrandom = new SharedSeedRandom();
                for (int r = 0; r <= range; ++r) {
                    block2: for (int ind = 0; ind < possibleTargets.size(); ++ind) {
                        for (int x = -r; x <= r; ++x) {
                            boolean edgeX = x == -r || x == r;
                            for (int y = -r; y <= r; ++y) {
                                boolean edgeY;
                                boolean bl = edgeY = y == -r || y == r;
                                if (!edgeX && !edgeY) continue;
                                StructureSeparationSettings settings = (StructureSeparationSettings)sepSettings.get(ind);
                                Structure s = (Structure)possibleTargets.get(ind);
                                int spacing = settings.func_236668_a_();
                                int k1 = chunkX + spacing * x;
                                int l1 = chunkY + spacing * y;
                                ChunkPos chunkpos = s.func_236392_a_(settings, seed, sharedseedrandom, k1, l1);
                                IChunk ichunk = world.func_217348_a(chunkpos.field_77276_a, chunkpos.field_77275_b, ChunkStatus.field_222606_b);
                                StructureStart structureStart = manager.func_235013_a_(SectionPos.func_218156_a((ChunkPos)ichunk.func_76632_l(), (int)0), s, (IStructureReader)ichunk);
                                if (structureStart != null && structureStart.func_75069_d()) {
                                    BlockPos p = structureStart.func_204294_a();
                                    int distance = StructureLocator.dist(new BlockPos(posX, 0, posZ), p);
                                    if (distance > 90) {
                                        found.add(new ImmutablePair((Object)distance, (Object)p));
                                    } else {
                                        inVillage = true;
                                    }
                                }
                                if (r == 0 || r > 5 && found.size() >= count) break;
                            }
                            if (r == 0 || r > 8 && found.size() >= count) continue block2;
                        }
                    }
                    if (found.size() >= count) break;
                }
            }
        }
        Collections.sort(found);
        return new ImmutablePair(found, (Object)inVillage);
    }
}

