/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.misc.tile;

import com.buuz135.industrial.block.tile.IndustrialAreaWorkingTile;
import com.buuz135.industrial.block.tile.IndustrialWorkingTile;
import com.buuz135.industrial.block.tile.RangeManager;
import com.buuz135.industrial.config.machine.misc.StasisChamberConfig;
import com.buuz135.industrial.module.ModuleMisc;
import com.hrznstudio.titanium.component.energy.EnergyStorageComponent;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.server.ServerWorld;

public class StasisChamberTile
extends IndustrialAreaWorkingTile<StasisChamberTile> {
    private int getMaxProgress = StasisChamberConfig.maxProgress;
    private int getPowerPerOperation = StasisChamberConfig.powerPerOperation;

    public StasisChamberTile() {
        super(ModuleMisc.STASIS_CHAMBER, RangeManager.RangeType.TOP, false, StasisChamberConfig.powerPerOperation);
    }

    @Override
    public IndustrialWorkingTile.WorkAction work() {
        if (this.hasEnergy(this.getPowerPerOperation)) {
            List entities = this.field_145850_b.func_217357_a(MobEntity.class, this.getWorkingArea().func_197752_a());
            for (MobEntity entity : entities) {
                entity.func_94061_f(true);
                entity.getPersistentData().func_74772_a("StasisChamberTime", this.field_145850_b.func_82737_E());
                if (!entity.func_184222_aU() && this.field_145850_b instanceof ServerWorld) {
                    if (StasisChamberConfig.disableBossBars) {
                        this.field_145850_b.func_217369_A().forEach(entity1 -> entity.func_184203_c((ServerPlayerEntity)entity1));
                    } else {
                        this.field_145850_b.func_217369_A().forEach(entity1 -> entity.func_184178_b((ServerPlayerEntity)entity1));
                    }
                }
                if (!this.field_145850_b.field_73012_v.nextBoolean() || !this.field_145850_b.field_73012_v.nextBoolean()) continue;
                entity.func_70691_i(1.0f);
            }
            List players = this.field_145850_b.func_217357_a(PlayerEntity.class, this.getWorkingArea().func_197752_a());
            players.forEach(playerEntity -> {
                playerEntity.func_195064_c(new EffectInstance(Effects.field_76421_d, 25, 135));
                if (this.field_145850_b.field_73012_v.nextBoolean()) {
                    playerEntity.func_70691_i(1.0f);
                }
            });
            return new IndustrialWorkingTile.WorkAction(this, 0.5f, this.getPowerPerOperation);
        }
        return new IndustrialWorkingTile.WorkAction(this, 1.0f, 0);
    }

    @Override
    public VoxelShape getWorkingArea() {
        return VoxelShapes.func_197873_a((double)-1.0, (double)0.0, (double)-1.0, (double)2.0, (double)3.0, (double)2.0).func_197751_a((double)this.field_174879_c.func_177958_n(), (double)(this.field_174879_c.func_177956_o() + 1), (double)this.field_174879_c.func_177952_p());
    }

    @Nonnull
    public StasisChamberTile getSelf() {
        return this;
    }

    protected EnergyStorageComponent<StasisChamberTile> createEnergyStorage() {
        return new EnergyStorageComponent(StasisChamberConfig.maxStoredPower, 10, 20);
    }

    @Override
    public int getMaxProgress() {
        return this.getMaxProgress;
    }
}

