/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.resourceproduction.tile;

import com.buuz135.industrial.block.resourceproduction.tile.ILaserBase;
import com.buuz135.industrial.block.tile.IndustrialMachineTile;
import com.buuz135.industrial.config.machine.resourceproduction.FluidLaserBaseConfig;
import com.buuz135.industrial.module.ModuleResourceProduction;
import com.buuz135.industrial.recipe.LaserDrillFluidRecipe;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.augment.AugmentTypes;
import com.hrznstudio.titanium.api.augment.IAugmentType;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.client.screen.addon.ProgressBarScreenAddon;
import com.hrznstudio.titanium.client.screen.addon.TextScreenAddon;
import com.hrznstudio.titanium.component.button.ArrowButtonComponent;
import com.hrznstudio.titanium.component.energy.EnergyStorageComponent;
import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import com.hrznstudio.titanium.component.fluid.SidedFluidTankComponent;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.component.inventory.SidedInventoryComponent;
import com.hrznstudio.titanium.component.progress.ProgressBarComponent;
import com.hrznstudio.titanium.component.sideness.IFacingComponent;
import com.hrznstudio.titanium.item.AugmentWrapper;
import com.hrznstudio.titanium.util.FacingUtil;
import com.hrznstudio.titanium.util.RecipeUtil;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class FluidLaserBaseTile
extends IndustrialMachineTile<FluidLaserBaseTile>
implements ILaserBase<FluidLaserBaseTile> {
    @Save
    private ProgressBarComponent<FluidLaserBaseTile> work;
    @Save
    private SidedInventoryComponent<FluidLaserBaseTile> catalyst;
    @Save
    private SidedFluidTankComponent<FluidLaserBaseTile> output;
    @Save
    private int miningDepth;

    public FluidLaserBaseTile() {
        super(ModuleResourceProduction.FLUID_LASER_BASE);
        this.setShowEnergy(false);
        this.miningDepth = this.func_174877_v().func_177956_o();
        this.work = new ProgressBarComponent<FluidLaserBaseTile>(74, 42, 0, FluidLaserBaseConfig.maxProgress){

            public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
                return Collections.singletonList(() -> new ProgressBarScreenAddon<FluidLaserBaseTile>(FluidLaserBaseTile.this.work.getPosX(), FluidLaserBaseTile.this.work.getPosY(), (ProgressBarComponent)this){

                    public List<ITextComponent> getTooltipLines() {
                        ArrayList<ITextComponent> tooltip = new ArrayList<ITextComponent>();
                        tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.GOLD + new TranslationTextComponent("tooltip.titanium.progressbar.progress").getString() + TextFormatting.WHITE + new DecimalFormat().format(FluidLaserBaseTile.this.work.getProgress()) + TextFormatting.GOLD + "/" + TextFormatting.WHITE + new DecimalFormat().format(FluidLaserBaseTile.this.work.getMaxProgress())));
                        return tooltip;
                    }
                });
            }
        }.setBarDirection(ProgressBarComponent.BarDirection.ARROW_RIGHT).setCanIncrease(oreLaserBaseTile -> true).setProgressIncrease(0).setCanReset(oreLaserBaseTile -> true).setOnStart(() -> {
            int maxProgress = (int)Math.floor((float)FluidLaserBaseConfig.maxProgress * (this.hasAugmentInstalled(AugmentTypes.EFFICIENCY) ? AugmentWrapper.getType((ItemStack)((ItemStack)this.getInstalledAugments(AugmentTypes.EFFICIENCY).get(0)), (IAugmentType)AugmentTypes.EFFICIENCY) : 1.0f));
            this.work.setMaxProgress(maxProgress);
        }).setOnFinishWork(this::onWork);
        this.addProgressBar(this.work);
        this.catalyst = (SidedInventoryComponent)new SidedInventoryComponent("lens", 50, 42, 1, 0).setColor(DyeColor.BLUE).setRange(2, 3).setSlotLimit(1);
        this.addInventory((InventoryComponent)this.catalyst);
        this.catalyst.getFacingModes().keySet().forEach(sideness -> this.catalyst.getFacingModes().put(sideness, IFacingComponent.FaceMode.NONE));
        this.output = (SidedFluidTankComponent)new SidedFluidTankComponent("output", 32000, 102, 20, 1).setColor(DyeColor.ORANGE).setTankAction(FluidTankComponent.Action.DRAIN);
        this.addTank(this.output);
        int y = 84;
        this.addButton(new ArrowButtonComponent(53, y, 14, 14, FacingUtil.Sideness.LEFT).setPredicate((playerEntity, compoundNBT) -> {
            this.miningDepth = Math.max(0, this.miningDepth - 1);
            this.markForUpdate();
        }));
        this.addButton(new ArrowButtonComponent(126, y, 14, 14, FacingUtil.Sideness.RIGHT).setPredicate((playerEntity, compoundNBT) -> {
            this.miningDepth = Math.min(255, this.miningDepth + 1);
            this.markForUpdate();
        }));
        this.addGuiAddonFactory(() -> new TextScreenAddon("", 70, y + 3, false){

            public String getText() {
                return TextFormatting.DARK_GRAY + new TranslationTextComponent("text.industrialforegoing.depth").getString() + FluidLaserBaseTile.this.miningDepth;
            }
        });
    }

    public void func_226984_a_(World world, BlockPos pos) {
        super.func_226984_a_(world, pos);
        if (this.miningDepth == 0) {
            this.miningDepth = this.field_174879_c.func_177956_o();
        }
    }

    private void onWork() {
        if (!this.catalyst.getStackInSlot(0).func_190926_b()) {
            VoxelShape box = VoxelShapes.func_197873_a((double)-1.0, (double)0.0, (double)-1.0, (double)2.0, (double)3.0, (double)2.0).func_197751_a((double)this.field_174879_c.func_177958_n(), (double)(this.field_174879_c.func_177956_o() - 1), (double)this.field_174879_c.func_177952_p());
            RecipeUtil.getRecipes((World)this.field_145850_b, (IRecipeType)LaserDrillFluidRecipe.SERIALIZER.getRecipeType()).stream().filter(laserDrillFluidRecipe -> laserDrillFluidRecipe.catalyst.test(this.catalyst.getStackInSlot(0))).filter(laserDrillFluidRecipe -> laserDrillFluidRecipe.getValidRarity(this.field_145850_b.func_226691_t_(this.field_174879_c).getRegistryName(), this.miningDepth) != null).findFirst().ifPresent(laserDrillFluidRecipe -> {
                if (!LaserDrillFluidRecipe.EMPTY.equals((Object)laserDrillFluidRecipe.entity)) {
                    LivingEntity first;
                    List entities = this.field_145850_b.func_175647_a(LivingEntity.class, box.func_197752_a(), entity -> entity.func_200600_R().getRegistryName().equals((Object)laserDrillFluidRecipe.entity));
                    if (entities.size() > 0 && (first = (LivingEntity)entities.get(0)).func_110143_aJ() > 5.0f) {
                        first.func_70097_a(DamageSource.field_76377_j, 5.0f);
                        this.output.fillForced(FluidStack.loadFluidStackFromNBT((CompoundNBT)laserDrillFluidRecipe.output), IFluidHandler.FluidAction.EXECUTE);
                    }
                } else {
                    this.output.fillForced(FluidStack.loadFluidStackFromNBT((CompoundNBT)laserDrillFluidRecipe.output), IFluidHandler.FluidAction.EXECUTE);
                }
            });
        }
    }

    public FluidLaserBaseTile getSelf() {
        return this;
    }

    protected EnergyStorageComponent<FluidLaserBaseTile> createEnergyStorage() {
        return new EnergyStorageComponent(0, 4, 10);
    }

    @Override
    public ProgressBarComponent<FluidLaserBaseTile> getBar() {
        return this.work;
    }

    @Override
    public boolean canAcceptAugment(ItemStack augment) {
        if (AugmentWrapper.hasType((ItemStack)augment, (IAugmentType)AugmentTypes.SPEED)) {
            return false;
        }
        return super.canAcceptAugment(augment);
    }
}

