/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.resourceproduction.tile;

import com.buuz135.industrial.block.resourceproduction.tile.ILaserBase;
import com.buuz135.industrial.block.tile.IndustrialAreaWorkingTile;
import com.buuz135.industrial.block.tile.IndustrialWorkingTile;
import com.buuz135.industrial.block.tile.RangeManager;
import com.buuz135.industrial.config.machine.resourceproduction.LaserDrillConfig;
import com.buuz135.industrial.module.ModuleResourceProduction;
import com.buuz135.industrial.utils.BlockUtils;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.client.screen.addon.TextScreenAddon;
import com.hrznstudio.titanium.component.energy.EnergyStorageComponent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class LaserDrillTile
extends IndustrialAreaWorkingTile<LaserDrillTile> {
    @Save
    private BlockPos target = BlockPos.field_177992_a;

    public LaserDrillTile() {
        super(ModuleResourceProduction.LASER_DRILL, RangeManager.RangeType.BEHIND, false, LaserDrillConfig.powerPerOperation);
        this.addGuiAddonFactory(() -> new TextScreenAddon(TextFormatting.DARK_GRAY + new TranslationTextComponent("text.industrialforegoing.target").getString(), 44, 26, false));
        this.addGuiAddonFactory(() -> new TextScreenAddon("Target: ", 44, 36, false){

            public String getText() {
                if (LaserDrillTile.this.target.equals((Object)BlockPos.field_177992_a) || LaserDrillTile.this.target == null) {
                    return TextFormatting.DARK_GRAY + new TranslationTextComponent("text.industrialforegoing.target_not_found").getString();
                }
                return TextFormatting.DARK_GRAY + "X: " + LaserDrillTile.this.target.func_177958_n() + " Y: " + LaserDrillTile.this.target.func_177956_o() + " Z: " + LaserDrillTile.this.target.func_177952_p();
            }
        });
    }

    @Override
    public IndustrialWorkingTile.WorkAction work() {
        if (!this.target.equals((Object)BlockPos.field_177992_a) && !this.isValidTarget(this.target)) {
            this.target = BlockPos.field_177992_a;
            this.markForUpdate();
        }
        if (this.target.equals((Object)BlockPos.field_177992_a)) {
            this.findTarget();
        }
        if (!this.target.equals((Object)BlockPos.field_177992_a) && this.hasEnergy(LaserDrillConfig.powerPerOperation) && this.field_145850_b.func_175625_s(this.target) instanceof ILaserBase) {
            ILaserBase laserBase = (ILaserBase)this.field_145850_b.func_175625_s(this.target);
            laserBase.getBar().setProgress(laserBase.getBar().getProgress() + 1);
            return new IndustrialWorkingTile.WorkAction(this, 1.0f, LaserDrillConfig.powerPerOperation);
        }
        return new IndustrialWorkingTile.WorkAction(this, 1.0f, 0);
    }

    @Override
    public VoxelShape getWorkingArea() {
        Vector3i vector = this.getFacingDirection().func_176734_d().func_176730_m();
        return VoxelShapes.func_197873_a((double)-1.0, (double)0.0, (double)-1.0, (double)2.0, (double)3.0, (double)2.0).func_197751_a((double)(this.field_174879_c.func_177958_n() + vector.func_177958_n() * 2), (double)(this.field_174879_c.func_177956_o() + vector.func_177956_o() * 2 - 1), (double)(this.field_174879_c.func_177952_p() + vector.func_177952_p() * 2));
    }

    public void findTarget() {
        for (BlockPos blockPos : BlockUtils.getBlockPosInAABB(this.getWorkingArea().func_197752_a())) {
            if (!this.isValidTarget(blockPos)) continue;
            this.target = blockPos;
            this.markForUpdate();
            return;
        }
    }

    public boolean isValidTarget(BlockPos pos) {
        if (pos.equals((Object)BlockPos.field_177992_a)) {
            return false;
        }
        return this.field_145850_b.func_175625_s(pos) instanceof ILaserBase;
    }

    public LaserDrillTile getSelf() {
        return this;
    }

    protected EnergyStorageComponent<LaserDrillTile> createEnergyStorage() {
        return new EnergyStorageComponent(LaserDrillConfig.maxStoredPower, 10, 20);
    }

    public BlockPos getTarget() {
        return this.target;
    }

    @Override
    public int getMaxProgress() {
        return LaserDrillConfig.maxProgress;
    }
}

