/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.tile;

import com.buuz135.industrial.block.tile.IndustrialMachineTile;
import com.buuz135.industrial.item.addon.ProcessingAddonItem;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.augment.AugmentTypes;
import com.hrznstudio.titanium.api.augment.IAugmentType;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.block.redstone.RedstoneAction;
import com.hrznstudio.titanium.client.screen.addon.ProgressBarScreenAddon;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.progress.ProgressBarComponent;
import com.hrznstudio.titanium.item.AugmentWrapper;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public abstract class IndustrialProcessingTile<T extends IndustrialProcessingTile<T>>
extends IndustrialMachineTile<T> {
    @Save
    private ProgressBarComponent<T> progressBar;

    public IndustrialProcessingTile(BasicTileBlock<T> basicTileBlock, final int x, final int y) {
        super(basicTileBlock);
        this.progressBar = new ProgressBarComponent<T>(x, y, this.getMaxProgress()){

            public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
                return Collections.singletonList(() -> new ProgressBarScreenAddon(x, y, IndustrialProcessingTile.this.progressBar){

                    public List<ITextComponent> getTooltipLines() {
                        ArrayList<ITextComponent> tooltip = new ArrayList<ITextComponent>();
                        tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.GOLD + new TranslationTextComponent("tooltip.titanium.progressbar.progress").getString() + TextFormatting.WHITE + new DecimalFormat().format(IndustrialProcessingTile.this.progressBar.getProgress()) + TextFormatting.GOLD + "/" + TextFormatting.WHITE + new DecimalFormat().format(IndustrialProcessingTile.this.progressBar.getMaxProgress())));
                        int progress = IndustrialProcessingTile.this.progressBar.getMaxProgress() - IndustrialProcessingTile.this.progressBar.getProgress();
                        if (!IndustrialProcessingTile.this.progressBar.getIncreaseType()) {
                            progress = IndustrialProcessingTile.this.progressBar.getMaxProgress() - progress;
                        }
                        tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.GOLD + "ETA: " + TextFormatting.WHITE + new DecimalFormat().format(Math.ceil((double)(progress * IndustrialProcessingTile.this.progressBar.getTickingTime()) / 20.0 / (double)IndustrialProcessingTile.this.progressBar.getProgressIncrease())) + TextFormatting.DARK_AQUA + "s"));
                        tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.GOLD + new TranslationTextComponent("tooltip.industrialforegoing.usage").getString() + TextFormatting.WHITE + IndustrialProcessingTile.this.getTickPower() + TextFormatting.DARK_AQUA + " FE" + TextFormatting.GOLD + "/" + TextFormatting.WHITE + TextFormatting.DARK_AQUA + "t"));
                        return tooltip;
                    }
                });
            }
        }.setComponentHarness((IComponentHarness)this.getSelf()).setBarDirection(this.getBarDirection()).setCanReset(tileEntity -> true).setOnStart(() -> {
            int maxProgress = (int)Math.floor((float)this.getMaxProgress() * (this.hasAugmentInstalled(AugmentTypes.EFFICIENCY) ? AugmentWrapper.getType((ItemStack)((ItemStack)this.getInstalledAugments(AugmentTypes.EFFICIENCY).get(0)), (IAugmentType)AugmentTypes.EFFICIENCY) : 1.0f));
            this.progressBar.setMaxProgress(maxProgress);
        }).setCanIncrease(tileEntity -> this.getEnergyStorage().getEnergyStored() >= this.getTickPower() && this.canIncrease() && ((RedstoneAction)this.getRedstoneManager().getAction()).canRun(tileEntity.getEnvironmentValue(false, null)) && this.getRedstoneManager().shouldWork()).setOnTickWork(() -> {
            this.getEnergyStorage().extractEnergy(this.getTickPower(), false);
            this.progressBar.setProgressIncrease(this.hasAugmentInstalled(AugmentTypes.SPEED) ? (int)AugmentWrapper.getType((ItemStack)((ItemStack)this.getInstalledAugments(AugmentTypes.SPEED).get(0)), (IAugmentType)AugmentTypes.SPEED) : 1);
        }).setOnFinishWork(() -> {
            int operations = (int)(this.hasAugmentInstalled(ProcessingAddonItem.PROCESSING) ? AugmentWrapper.getType((ItemStack)((ItemStack)this.getInstalledAugments(ProcessingAddonItem.PROCESSING).get(0)), (IAugmentType)ProcessingAddonItem.PROCESSING) : 1.0f);
            for (int i = 0; i < operations; ++i) {
                if (!this.canIncrease()) continue;
                this.onFinish().run();
            }
            this.getRedstoneManager().finish();
        });
        this.addProgressBar(this.progressBar);
    }

    public ProgressBarComponent<T> getProgressBar() {
        return this.progressBar;
    }

    public ActionResultType onActivated(PlayerEntity playerIn, Hand hand, Direction facing, double hitX, double hitY, double hitZ) {
        if (super.onActivated(playerIn, hand, facing, hitX, hitY, hitZ) == ActionResultType.SUCCESS) {
            return ActionResultType.SUCCESS;
        }
        this.openGui(playerIn);
        return ActionResultType.PASS;
    }

    public int getMaxProgress() {
        return 100;
    }

    public abstract boolean canIncrease();

    public abstract Runnable onFinish();

    protected abstract int getTickPower();

    public ProgressBarComponent.BarDirection getBarDirection() {
        return ProgressBarComponent.BarDirection.ARROW_RIGHT;
    }
}

