/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.transportstorage;

import com.buuz135.industrial.block.IndustrialBlock;
import com.buuz135.industrial.block.transportstorage.tile.BlackHoleTankTile;
import com.buuz135.industrial.capability.BlockFluidHandlerItemStack;
import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.module.ModuleTransportStorage;
import com.buuz135.industrial.utils.BlockUtils;
import com.buuz135.industrial.utils.IndustrialTags;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.block.RotatableBlock;
import com.hrznstudio.titanium.datagenerator.loot.block.BasicBlockLootTables;
import com.hrznstudio.titanium.module.api.RegistryManager;
import com.hrznstudio.titanium.nbthandler.NBTManager;
import com.hrznstudio.titanium.recipe.generator.TitaniumShapedRecipeBuilder;
import com.hrznstudio.titanium.util.LangUtil;
import com.mojang.datafixers.types.Type;
import java.text.DecimalFormat;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.Rarity;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.functions.CopyNbt;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BlackHoleTankBlock
extends IndustrialBlock<BlackHoleTankTile> {
    private Rarity rarity;
    private TileEntityType tileEntityType;

    public BlackHoleTankBlock(Rarity rarity) {
        super(rarity.name().toLowerCase() + "_black_hole_tank", AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150339_S), BlackHoleTankTile.class, (ItemGroup)ModuleTransportStorage.TAB_TRANSPORT);
        this.rarity = rarity;
    }

    public IFactory<BlackHoleTankTile> getTileEntityFactory() {
        return () -> new BlackHoleTankTile((BasicTileBlock<BlackHoleTankTile>)this, this.rarity);
    }

    public void addAlternatives(RegistryManager<?> registry) {
        BlockItem item = (BlockItem)this.getItemBlockFactory().create();
        this.setItem(item);
        registry.content(Item.class, (IForgeRegistryEntry)item);
        NBTManager.getInstance().scanTileClassForAnnotations(BlackHoleTankTile.class);
        this.tileEntityType = TileEntityType.Builder.func_223042_a(() -> this.getTileEntityFactory().create(), (Block[])new Block[]{this}).func_206865_a((Type)null);
        this.tileEntityType.setRegistryName(new ResourceLocation("industrialforegoing", this.rarity.name().toLowerCase() + "_black_hole_tank"));
        registry.content(TileEntityType.class, (IForgeRegistryEntry)this.tileEntityType);
    }

    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
        stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).ifPresent(iFluidHandlerItem -> {
            if (!iFluidHandlerItem.getFluidInTank(0).isEmpty()) {
                tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.GOLD + LangUtil.getString((String)"text.industrialforegoing.tooltip.contains", (Object[])new Object[0]) + ": " + TextFormatting.WHITE + new DecimalFormat().format(iFluidHandlerItem.getFluidInTank(0).getAmount()) + TextFormatting.YELLOW + LangUtil.getString((String)"tooltip.industrialforegoing.mb_of", (Object[])new Object[]{TextFormatting.DARK_AQUA + iFluidHandlerItem.getFluidInTank(0).getDisplayName().getString()})));
            }
        });
        tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.GOLD + LangUtil.getString((String)"text.industrialforegoing.tooltip.can_hold", (Object[])new Object[0]) + ": " + TextFormatting.WHITE + new DecimalFormat().format(BlockUtils.getFluidAmountByRarity(this.rarity)) + TextFormatting.DARK_AQUA + LangUtil.getString((String)"text.industrialforegoing.tooltip.mb", (Object[])new Object[0])));
    }

    @Override
    public IFactory<BlockItem> getItemBlockFactory() {
        return () -> (BlockItem)new BlackHoleTankItem((Block)this, new Item.Properties().func_200916_a(this.getItemGroup()), this.rarity).setRegistryName(this.getRegistryName());
    }

    public RotatableBlock.RotationType getRotationType() {
        return RotatableBlock.RotationType.FOUR_WAY;
    }

    public TileEntityType getTileEntityType() {
        return this.tileEntityType;
    }

    public void func_196270_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player) {
    }

    public LootTable.Builder getLootTable(@Nonnull BasicBlockLootTables blockLootTables) {
        CopyNbt.Builder nbtBuilder = CopyNbt.func_215881_a((CopyNbt.Source)CopyNbt.Source.BLOCK_ENTITY);
        nbtBuilder.func_216056_a("tank", "BlockEntityTag.tank");
        nbtBuilder.func_216056_a("filter", "BlockEntityTag.filter");
        return blockLootTables.droppingSelfWithNbt((IItemProvider)this, nbtBuilder);
    }

    public NonNullList<ItemStack> getDynamicDrops(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        return NonNullList.func_191196_a();
    }

    public void registerRecipe(Consumer<IFinishedRecipe> consumer) {
        if (this.rarity == Rarity.COMMON) {
            TitaniumShapedRecipeBuilder.shapedRecipe((IItemProvider)this).func_200472_a("PPP").func_200472_a("CEC").func_200472_a("CMC").func_200469_a(Character.valueOf('P'), (ITag)Tags.Items.INGOTS_IRON).func_200469_a(Character.valueOf('E'), IndustrialTags.Items.GEAR_IRON).func_200462_a(Character.valueOf('C'), (IItemProvider)Items.field_151133_ar).func_200469_a(Character.valueOf('M'), IndustrialTags.Items.MACHINE_FRAME_PITY).func_200464_a(consumer);
        } else {
            ITag<Item> tag = IndustrialTags.Items.MACHINE_FRAME_PITY;
            if (this.rarity == ModuleCore.SIMPLE_RARITY) {
                tag = IndustrialTags.Items.MACHINE_FRAME_SIMPLE;
            }
            if (this.rarity == ModuleCore.ADVANCED_RARITY) {
                tag = IndustrialTags.Items.MACHINE_FRAME_ADVANCED;
            }
            if (this.rarity == ModuleCore.SUPREME_RARITY) {
                tag = IndustrialTags.Items.MACHINE_FRAME_SUPREME;
            }
            TitaniumShapedRecipeBuilder.shapedRecipe((IItemProvider)this).func_200472_a("PPP").func_200472_a("NEN").func_200472_a("CMC").func_200469_a(Character.valueOf('P'), IndustrialTags.Items.PLASTIC).func_200462_a(Character.valueOf('N'), (IItemProvider)Items.field_151061_bv).func_200462_a(Character.valueOf('E'), (IItemProvider)Items.field_151079_bi).func_200462_a(Character.valueOf('C'), (IItemProvider)Items.field_151133_ar).func_200469_a(Character.valueOf('M'), tag).func_200464_a(consumer);
        }
    }

    public class BlackHoleTankCapabilityProvider
    implements ICapabilityProvider {
        private final ItemStack stack;
        private LazyOptional<FluidHandlerItemStack> iFluidHandlerItemLazyOptional;

        public BlackHoleTankCapabilityProvider(ItemStack stack, Rarity rarity) {
            this.stack = stack;
            this.iFluidHandlerItemLazyOptional = LazyOptional.of(() -> new BlockFluidHandlerItemStack(stack, new ItemStack((IItemProvider)stack.func_77973_b()), BlockUtils.getFluidAmountByRarity(rarity), "tank"));
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            if (cap != null && cap.equals((Object)CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY)) {
                return this.iFluidHandlerItemLazyOptional.cast();
            }
            return LazyOptional.empty();
        }
    }

    public class BlackHoleTankItem
    extends BlockItem {
        private Rarity rarity;

        public BlackHoleTankItem(Block blockIn, Item.Properties builder, Rarity rarity) {
            super(blockIn, builder);
            this.rarity = rarity;
        }

        @Nullable
        public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
            return new BlackHoleTankCapabilityProvider(stack, this.rarity);
        }

        @Nullable
        public String getCreatorModId(ItemStack itemStack) {
            return new TranslationTextComponent("itemGroup." + this.field_77701_a.func_200300_c()).getString();
        }
    }
}

