/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.gui.component.custom;

import com.buuz135.industrial.api.conveyor.gui.PositionedGuiComponent;
import com.buuz135.industrial.gui.component.StateButtonInfo;
import com.buuz135.industrial.gui.component.custom.ICanSendNetworkMessage;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;

public abstract class TexturedStateButtonGuiComponent
extends PositionedGuiComponent {
    private final int id;
    private StateButtonInfo[] buttonInfos;

    public TexturedStateButtonGuiComponent(int id, int x, int y, int xSize, int ySize, StateButtonInfo ... buttonInfos) {
        super(x, y, xSize, ySize);
        this.id = id;
        this.buttonInfos = new StateButtonInfo[0];
        if (buttonInfos != null) {
            this.buttonInfos = buttonInfos;
        }
    }

    @Override
    public boolean handleClick(ContainerScreen conveyor, int guiX, int guiY, double mouseX, double mouseY) {
        if (conveyor instanceof ICanSendNetworkMessage) {
            ((ICanSendNetworkMessage)conveyor).sendMessage(this.id, new CompoundNBT());
        }
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new SimpleSound(SoundEvents.field_187909_gi, SoundCategory.PLAYERS, 1.0f, 1.0f, Minecraft.func_71410_x().field_71439_g.func_233580_cy_()));
        return true;
    }

    @Override
    public void drawGuiBackgroundLayer(MatrixStack stack, int guiX, int guiY, double mouseX, double mouseY) {
        StateButtonInfo buttonInfo = this.getStateInfo();
        if (buttonInfo != null) {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(buttonInfo.getTexture());
            Minecraft.func_71410_x().field_71462_r.func_238474_b_(stack, guiX + this.getXPos(), guiY + this.getYPos(), buttonInfo.getTextureX(), buttonInfo.getTextureY(), this.getXSize(), this.getYSize());
        }
    }

    @Override
    public void drawGuiForegroundLayer(MatrixStack stack, int guiX, int guiY, double mouseX, double mouseY) {
        StateButtonInfo buttonInfo = this.getStateInfo();
        if (buttonInfo != null && this.isInside(mouseX, mouseY)) {
            RenderSystem.disableLighting();
            RenderSystem.enableDepthTest();
            AbstractGui.func_238467_a_((MatrixStack)stack, (int)(this.getXPos() - guiX), (int)(this.getYPos() - guiY), (int)(this.getXPos() + this.getXSize() - guiX), (int)(this.getYPos() + this.getYSize() - guiY), (int)-2130706433);
            RenderSystem.enableLighting();
            RenderSystem.disableAlphaTest();
        }
    }

    @Override
    @Nullable
    public List<ITextComponent> getTooltip(int guiX, int guiY, double mouseX, double mouseY) {
        StateButtonInfo buttonInfo = this.getStateInfo();
        if (buttonInfo != null) {
            return Arrays.asList(buttonInfo.getTooltip());
        }
        return null;
    }

    public abstract int getState();

    private StateButtonInfo getStateInfo() {
        for (StateButtonInfo buttonInfo : this.buttonInfos) {
            if (buttonInfo.getState() != this.getState()) continue;
            return buttonInfo;
        }
        return null;
    }
}

