/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.item.infinity.item;

import com.buuz135.industrial.item.infinity.InfinityTier;
import com.buuz135.industrial.item.infinity.ItemInfinity;
import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.recipe.DissolutionChamberRecipe;
import com.buuz135.industrial.utils.BlockUtils;
import com.buuz135.industrial.utils.IndustrialTags;
import com.hrznstudio.titanium.util.RayTraceUtils;
import java.util.ArrayList;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.tuple.Pair;

public class ItemInfinityDrill
extends ItemInfinity {
    public static Material[] mineableMaterials = new Material[]{Material.field_151577_b, Material.field_151578_c, Material.field_151574_g, Material.field_151571_B, Material.field_151592_s, Material.field_151588_w, Material.field_151573_f, Material.field_151598_x, Material.field_76233_E, Material.field_151576_e, Material.field_151595_p, Material.field_151597_y};
    public static int POWER_CONSUMPTION = 10000;
    public static int FUEL_CONSUMPTION = 30;

    public ItemInfinityDrill(ItemGroup group) {
        super("infinity_drill", group, new Item.Properties().func_200917_a(1).addToolType(ToolType.PICKAXE, 6).addToolType(ToolType.SHOVEL, 6), POWER_CONSUMPTION, FUEL_CONSUMPTION, false);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return Items.field_151046_w.canApplyAtEnchantingTable(new ItemStack((IItemProvider)Items.field_151046_w), enchantment) || Items.field_151047_v.canApplyAtEnchantingTable(new ItemStack((IItemProvider)Items.field_151047_v), enchantment);
    }

    public boolean func_150897_b(BlockState blockIn) {
        return Items.field_151046_w.func_150897_b(blockIn) || Items.field_151047_v.func_150897_b(blockIn);
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        RayTraceResult rayTraceResult;
        if (entityLiving instanceof PlayerEntity && (rayTraceResult = RayTraceUtils.rayTraceSimple((World)worldIn, (LivingEntity)entityLiving, (double)16.0, (float)0.0f)).func_216346_c() == RayTraceResult.Type.BLOCK) {
            BlockRayTraceResult blockResult = (BlockRayTraceResult)rayTraceResult;
            Direction facing = blockResult.func_216354_b();
            InfinityTier currentTier = ItemInfinityDrill.getSelectedTier(stack);
            Pair<BlockPos, BlockPos> area = this.getArea(pos, facing, currentTier, true);
            ArrayList totalDrops = new ArrayList();
            BlockPos.func_218278_a((BlockPos)((BlockPos)area.getLeft()), (BlockPos)((BlockPos)area.getRight())).forEach(blockPos -> {
                if (this.enoughFuel(stack) && worldIn.func_175625_s(blockPos) == null && worldIn instanceof ServerWorld && entityLiving instanceof ServerPlayerEntity && !worldIn.func_175623_d(blockPos)) {
                    BlockState tempState = worldIn.func_180495_p(blockPos);
                    Block block = tempState.func_177230_c();
                    if (!BlockUtils.isBlockstateInMaterial(tempState, mineableMaterials)) {
                        return;
                    }
                    if (tempState.func_185887_b((IBlockReader)worldIn, blockPos) < 0.0f) {
                        return;
                    }
                    int xp = ForgeHooks.onBlockBreakEvent((World)worldIn, (GameType)((ServerPlayerEntity)entityLiving).field_71134_c.func_73081_b(), (ServerPlayerEntity)((ServerPlayerEntity)entityLiving), (BlockPos)blockPos);
                    if (xp >= 0 && block.removedByPlayer(tempState, worldIn, blockPos, (PlayerEntity)entityLiving, true, tempState.func_204520_s())) {
                        block.func_176206_d((IWorld)worldIn, blockPos, tempState);
                        Block.func_220077_a((BlockState)tempState, (ServerWorld)((ServerWorld)worldIn), (BlockPos)blockPos, null, (Entity)((PlayerEntity)entityLiving), (ItemStack)stack).forEach(itemStack -> {
                            boolean combined = false;
                            for (ItemStack drop : totalDrops) {
                                if (!ItemHandlerHelper.canItemStacksStack((ItemStack)drop, (ItemStack)itemStack)) continue;
                                drop.func_190920_e(drop.func_190916_E() + itemStack.func_190916_E());
                                combined = true;
                                break;
                            }
                            if (!combined) {
                                totalDrops.add(itemStack);
                            }
                        });
                        block.func_180637_b((ServerWorld)worldIn, blockPos, xp);
                        this.consumeFuel(stack);
                    }
                }
            });
            totalDrops.forEach(itemStack -> Block.func_180635_a((World)worldIn, (BlockPos)entityLiving.func_233580_cy_(), (ItemStack)itemStack));
            worldIn.func_217357_a(ExperienceOrbEntity.class, new AxisAlignedBB((BlockPos)area.getLeft(), (BlockPos)area.getRight()).func_186662_g(1.0)).forEach(entityXPOrb -> entityXPOrb.func_70634_a((double)entityLiving.func_233580_cy_().func_177958_n(), (double)entityLiving.func_233580_cy_().func_177956_o(), (double)entityLiving.func_233580_cy_().func_177952_p()));
        }
        return super.func_179218_a(stack, worldIn, state, pos, entityLiving);
    }

    @Override
    public void registerRecipe(Consumer<IFinishedRecipe> consumer) {
        new DissolutionChamberRecipe(this.getRegistryName(), new Ingredient.IItemList[]{new Ingredient.SingleItemList(new ItemStack((IItemProvider)Items.field_221732_cb)), new Ingredient.SingleItemList(new ItemStack((IItemProvider)Items.field_151047_v)), new Ingredient.SingleItemList(new ItemStack((IItemProvider)Items.field_221732_cb)), new Ingredient.SingleItemList(new ItemStack((IItemProvider)Items.field_221732_cb)), new Ingredient.SingleItemList(new ItemStack((IItemProvider)ModuleCore.RANGE_ADDONS[11])), new Ingredient.TagList(IndustrialTags.Items.GEAR_GOLD), new Ingredient.TagList(IndustrialTags.Items.GEAR_GOLD), new Ingredient.TagList(IndustrialTags.Items.GEAR_GOLD)}, new FluidStack((Fluid)ModuleCore.PINK_SLIME.getSourceFluid(), 2000), 400, new ItemStack((IItemProvider)this), FluidStack.EMPTY);
    }
}

