/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.plugin.jei.category;

import com.buuz135.industrial.block.core.tile.DissolutionChamberTile;
import com.buuz135.industrial.config.machine.core.DissolutionChamberConfig;
import com.buuz135.industrial.recipe.DissolutionChamberRecipe;
import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.api.client.IAsset;
import com.hrznstudio.titanium.api.client.IAssetType;
import com.hrznstudio.titanium.client.screen.addon.EnergyBarScreenAddon;
import com.hrznstudio.titanium.client.screen.addon.SlotsScreenAddon;
import com.hrznstudio.titanium.client.screen.asset.DefaultAssetProvider;
import com.hrznstudio.titanium.client.screen.asset.IAssetProvider;
import com.hrznstudio.titanium.util.AssetUtil;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;

public class DissolutionChamberCategory
implements IRecipeCategory<DissolutionChamberRecipe> {
    public static final ResourceLocation ID = new ResourceLocation(DissolutionChamberRecipe.SERIALIZER.getRecipeType().toString());
    private final IGuiHelper guiHelper;
    private final IDrawable smallTank;
    private final IDrawable bigTank;

    public DissolutionChamberCategory(IGuiHelper guiHelper) {
        this.guiHelper = guiHelper;
        this.smallTank = guiHelper.createDrawable(DefaultAssetProvider.DEFAULT_LOCATION, 238, 4, 12, 13);
        this.bigTank = guiHelper.createDrawable(DefaultAssetProvider.DEFAULT_LOCATION, 180, 4, 12, 50);
    }

    public ResourceLocation getUid() {
        return ID;
    }

    public Class<? extends DissolutionChamberRecipe> getRecipeClass() {
        return DissolutionChamberRecipe.class;
    }

    public String getTitle() {
        return "Dissolution Chamber";
    }

    public IDrawable getBackground() {
        return this.guiHelper.createBlankDrawable(160, 82);
    }

    public IDrawable getIcon() {
        return null;
    }

    public void setIngredients(DissolutionChamberRecipe dissolutionChamberRecipe, IIngredients iIngredients) {
        ArrayList input = new ArrayList();
        for (Ingredient.IItemList iItemList : dissolutionChamberRecipe.input) {
            input.add(new ArrayList(iItemList.func_199799_a().stream().peek(stack -> stack.func_77973_b().func_77622_d(stack, (World)Minecraft.func_71410_x().field_71441_e, (PlayerEntity)Minecraft.func_71410_x().field_71439_g)).collect(Collectors.toList())));
        }
        iIngredients.setInputLists(VanillaTypes.ITEM, input);
        iIngredients.setInput(VanillaTypes.FLUID, (Object)dissolutionChamberRecipe.inputFluid);
        if (!dissolutionChamberRecipe.output.func_190926_b()) {
            iIngredients.setOutput(VanillaTypes.ITEM, (Object)dissolutionChamberRecipe.output);
        }
        if (dissolutionChamberRecipe.outputFluid != null && !dissolutionChamberRecipe.outputFluid.isEmpty()) {
            iIngredients.setOutput(VanillaTypes.FLUID, (Object)(dissolutionChamberRecipe.outputFluid == null ? FluidStack.EMPTY : dissolutionChamberRecipe.outputFluid));
        }
    }

    public void setRecipe(IRecipeLayout iRecipeLayout, DissolutionChamberRecipe dissolutionChamberRecipe, IIngredients iIngredients) {
        for (int i = 0; i < 8; ++i) {
            if (i >= iIngredients.getInputs(VanillaTypes.ITEM).size()) continue;
            iRecipeLayout.getItemStacks().init(i, true, 23 + (Integer)DissolutionChamberTile.getSlotPos(i).getLeft(), 10 + (Integer)DissolutionChamberTile.getSlotPos(i).getRight());
            iRecipeLayout.getItemStacks().set(i, (List)iIngredients.getInputs(VanillaTypes.ITEM).get(i));
        }
        if (!dissolutionChamberRecipe.output.func_190926_b()) {
            iRecipeLayout.getItemStacks().init(9, false, 118, 15);
            iRecipeLayout.getItemStacks().set(9, (List)iIngredients.getOutputs(VanillaTypes.ITEM).get(0));
        }
        iRecipeLayout.getFluidStacks().init(0, true, 48, 35, 12, 13, 8000, false, this.smallTank);
        iRecipeLayout.getFluidStacks().set(0, (List)iIngredients.getInputs(VanillaTypes.FLUID).get(0));
        if (dissolutionChamberRecipe.outputFluid != null && !dissolutionChamberRecipe.outputFluid.isEmpty()) {
            iRecipeLayout.getFluidStacks().init(1, false, 142, 17, 12, 50, 8000, false, this.bigTank);
            iRecipeLayout.getFluidStacks().set(1, (List)iIngredients.getOutputs(VanillaTypes.FLUID).get(0));
        }
    }

    public void draw(DissolutionChamberRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        EnergyBarScreenAddon.drawBackground((MatrixStack)matrixStack, (Screen)Minecraft.func_71410_x().field_71462_r, (IAssetProvider)DefaultAssetProvider.DEFAULT_PROVIDER, (int)0, (int)12, (int)0, (int)0);
        SlotsScreenAddon.drawAsset((MatrixStack)matrixStack, (Screen)Minecraft.func_71410_x().field_71462_r, (IAssetProvider)DefaultAssetProvider.DEFAULT_PROVIDER, (int)24, (int)11, (int)0, (int)0, (int)8, DissolutionChamberTile::getSlotPos, integer -> ItemStack.field_190927_a, (boolean)true, integer -> new Color(DyeColor.LIGHT_BLUE.func_196060_f()), integer -> true);
        SlotsScreenAddon.drawAsset((MatrixStack)matrixStack, (Screen)Minecraft.func_71410_x().field_71462_r, (IAssetProvider)DefaultAssetProvider.DEFAULT_PROVIDER, (int)119, (int)16, (int)0, (int)0, (int)3, integer -> Pair.of((Object)(18 * (integer % 1)), (Object)(18 * (integer / 1))), integer -> ItemStack.field_190927_a, (boolean)true, integer -> new Color(DyeColor.ORANGE.func_196060_f()), integer -> true);
        AssetUtil.drawAsset((MatrixStack)matrixStack, (Screen)Minecraft.func_71410_x().field_71462_r, (IAsset)DefaultAssetProvider.DEFAULT_PROVIDER.getAsset(AssetTypes.TANK_SMALL), (int)45, (int)32);
        AssetUtil.drawAsset((MatrixStack)matrixStack, (Screen)Minecraft.func_71410_x().field_71462_r, (IAsset)DefaultAssetProvider.DEFAULT_PROVIDER.getAsset(AssetTypes.TANK_NORMAL), (int)139, (int)14);
        AssetUtil.drawAsset((MatrixStack)matrixStack, (Screen)Minecraft.func_71410_x().field_71462_r, (IAsset)IAssetProvider.getAsset((IAssetProvider)DefaultAssetProvider.DEFAULT_PROVIDER, (IAssetType)AssetTypes.PROGRESS_BAR_BACKGROUND_ARROW_HORIZONTAL), (int)92, (int)33);
        int consumed = recipe.processingTime * DissolutionChamberConfig.powerPerTick;
        EnergyBarScreenAddon.drawForeground((MatrixStack)matrixStack, (Screen)Minecraft.func_71410_x().field_71462_r, (IAssetProvider)DefaultAssetProvider.DEFAULT_PROVIDER, (int)0, (int)12, (int)0, (int)0, (double)consumed, (double)((int)Math.max(50000.0, Math.ceil(consumed))));
    }

    public List<ITextComponent> getTooltipStrings(DissolutionChamberRecipe recipe, double mouseX, double mouseY) {
        Rectangle rec = DefaultAssetProvider.DEFAULT_PROVIDER.getAsset(AssetTypes.ENERGY_BACKGROUND).getArea();
        if (new Rectangle(0, 12, rec.width, rec.height).contains(mouseX, mouseY)) {
            int consumed = recipe.processingTime * 60;
            return EnergyBarScreenAddon.getTooltip((int)consumed, (int)((int)Math.max(50000.0, Math.ceil(consumed))));
        }
        return new ArrayList<ITextComponent>();
    }
}

