/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.proxy.block.filter;

import com.buuz135.industrial.gui.component.custom.ICanSendNetworkMessage;
import com.buuz135.industrial.gui.conveyor.GuiConveyor;
import com.buuz135.industrial.gui.transporter.GuiTransporter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.fluids.FluidStack;

public interface IFilter<T extends Entity> {
    public boolean acceptsInput(ItemStack var1);

    public boolean matches(T var1);

    public boolean matches(ItemStack var1);

    public boolean matches(FluidStack var1);

    public void setFilter(int var1, ItemStack var2);

    public GhostSlot[] getFilter();

    public CompoundNBT serializeNBT();

    public void deserializeNBT(CompoundNBT var1);

    public static class GhostSlot {
        public static final int MAX = 1024;
        public static final int MIN = 1;
        private final int x;
        private final int y;
        private int id;
        private ItemStack stack;
        private int amount;
        private int maxAmount;

        public GhostSlot(int id, int x, int y) {
            this.id = id;
            this.x = x;
            this.y = y;
            this.stack = ItemStack.field_190927_a;
            this.amount = 1;
            this.maxAmount = 1024;
        }

        public ItemStack getStack() {
            return this.stack;
        }

        public void setStack(ItemStack stack) {
            this.stack = stack;
        }

        public void increaseAmount(int amount) {
            this.amount = Math.max(0, Math.min(this.maxAmount, this.amount + amount));
        }

        public void decreaseAmount(int amount) {
            this.amount = Math.max(1, this.amount - amount);
        }

        public int getAmount() {
            return this.amount;
        }

        public void setAmount(int amount) {
            this.amount = amount;
        }

        public void setMaxAmount(int maxAmount) {
            this.maxAmount = maxAmount;
        }

        public Rectangle2d getArea() {
            Screen screen = Minecraft.func_71410_x().field_71462_r;
            if (screen instanceof GuiConveyor) {
                GuiConveyor gui = (GuiConveyor)screen;
                return new Rectangle2d(this.x + gui.getX(), this.y + gui.getY(), 18, 18);
            }
            if (screen instanceof GuiTransporter) {
                GuiTransporter gui = (GuiTransporter)screen;
                return new Rectangle2d(this.x + gui.getX(), this.y + gui.getY(), 18, 18);
            }
            return new Rectangle2d(0, 0, 0, 0);
        }

        public void accept(ItemStack ingredient) {
            if (Minecraft.func_71410_x().field_71462_r instanceof ICanSendNetworkMessage) {
                ((ICanSendNetworkMessage)Minecraft.func_71410_x().field_71462_r).sendMessage(this.id, ingredient.serializeNBT());
            }
        }
    }
}

