/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.utils;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ColorHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ColorUtils {
    public static int getColorFrom(ResourceLocation location) {
        Texture texture = Minecraft.func_71410_x().func_110434_K().func_229267_b_(AtlasTexture.field_110575_b);
        if (texture instanceof AtlasTexture) {
            return ColorUtils.getColorFrom(((AtlasTexture)texture).func_195424_a(location));
        }
        return 0;
    }

    public static int getColorFrom(TextureAtlasSprite sprite) {
        if (sprite == null) {
            return -1;
        }
        if (sprite.func_110970_k() == 0) {
            return -1;
        }
        float total = 0.0f;
        float red = 0.0f;
        float blue = 0.0f;
        float green = 0.0f;
        for (int x = 0; x < sprite.func_94211_a(); ++x) {
            for (int y = 0; y < sprite.func_94216_b(); ++y) {
                int color = sprite.getPixelRGBA(0, x, y);
                int alpha = color >> 24 & 0xFF;
                total += (float)alpha;
                red += (float)((color & 0xFF) * alpha);
                green += (float)((color >> 8 & 0xFF) * alpha);
                blue += (float)((color >> 16 & 0xFF) * alpha);
            }
        }
        if (total > 0.0f) {
            return ColorHelper.PackedColor.func_233006_a_((int)255, (int)((int)(red / total)), (int)((int)(green / total)), (int)((int)(blue / total)));
        }
        return -1;
    }
}

