/*
 * Decompiled with CFR 0.152.
 */
package lehjr.powersuits.client.control;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lehjr.numina.common.base.NuminaLogger;
import lehjr.numina.common.config.ConfigHelper;
import lehjr.powersuits.client.control.MPSKeyBinding;
import lehjr.powersuits.client.event.RenderEventHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.InputMappings;
import net.minecraft.util.ResourceLocation;

public enum KeybindManager {
    INSTANCE;


    File getLegacyKeyBindConfig() {
        return new File(ConfigHelper.setupConfigFile((String)"powersuits-keybinds.cfg", (String)"powersuits").getAbsolutePath());
    }

    File getKeyBindConfig() {
        return new File(ConfigHelper.setupConfigFile((String)"powersuits-keybinds.json", (String)"powersuits").getAbsolutePath());
    }

    public void writeOutKeybindSetings() {
        try {
            File file = this.getKeyBindConfig();
            if (!file.exists()) {
                Files.createDirectories(file.toPath().getParent(), new FileAttribute[0]);
                file.createNewFile();
            }
            JsonObject kbSettings = new JsonObject();
            Arrays.stream(Minecraft.func_71410_x().field_71474_y.field_74324_K).filter(MPSKeyBinding.class::isInstance).map(MPSKeyBinding.class::cast).forEach(keyBinding -> kbSettings.addProperty(keyBinding.func_151464_g(), Boolean.valueOf(keyBinding.showOnHud)));
            Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
            JsonParser jp = new JsonParser();
            JsonElement je = jp.parse(kbSettings.toString());
            String prettyJsonString = gson.toJson(je);
            this.fileWriter(file, prettyJsonString, true);
        }
        catch (Exception e) {
            NuminaLogger.logger.error("Problem writing out keyconfig :(");
            e.printStackTrace();
        }
    }

    public void fileWriter(File file, String string, boolean overwrite) {
        try {
            Files.createDirectories(file.toPath().getParent(), new FileAttribute[0]);
            if (overwrite || !file.exists()) {
                FileWriter fileWriter = new FileWriter(file);
                fileWriter.write(string);
                fileWriter.flush();
                fileWriter.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public List<MPSKeyBinding> getMPSKeyBinds() {
        return Arrays.stream(Minecraft.func_71410_x().field_71474_y.field_74324_K).filter(MPSKeyBinding.class::isInstance).map(MPSKeyBinding.class::cast).collect(Collectors.toList());
    }

    public void readInKeybinds() {
        File file = this.getKeyBindConfig();
        if (!file.exists()) {
            this.readLegacyKeybinds();
            return;
        }
        JsonParser jsonParser = new JsonParser();
        try (FileReader reader = new FileReader(this.getKeyBindConfig());){
            JsonElement object = jsonParser.parse((Reader)reader);
            if (object instanceof JsonObject) {
                JsonObject jsonObject = (JsonObject)object;
                Set elements = jsonObject.entrySet();
                for (Map.Entry entry : elements) {
                    String name = (String)entry.getKey();
                    boolean value = jsonObject.get(name).getAsBoolean();
                    this.getMPSKeyBinds().stream().filter(kb -> kb.func_151464_g().equals(name)).findFirst().ifPresent(kb -> {
                        kb.showOnHud = value;
                    });
                }
            }
        }
        catch (Exception e) {
            NuminaLogger.logger.error("Problem reading in keyconfig :(");
            e.printStackTrace();
        }
        RenderEventHandler.INSTANCE.makeKBDisplayList();
    }

    public void readLegacyKeybinds() {
        try {
            File file = this.getLegacyKeyBindConfig();
            if (!file.exists()) {
                NuminaLogger.logger.error("No modular power armor keybind file found.");
                this.writeOutKeybindSetings();
                return;
            }
            this.writeOutKeybindSetings();
            BufferedReader reader = new BufferedReader(new FileReader(file));
            boolean displayOnHUD = false;
            boolean toggleval = false;
            InputMappings.Input id = null;
            while (reader.ready()) {
                String[] exploded;
                String line = reader.readLine();
                if (line.contains(":")) {
                    exploded = line.split(":");
                    if (id == null) {
                        id = this.getInputByCode(Integer.parseInt(exploded[0]));
                        displayOnHUD = false;
                        if (exploded.length > 3) {
                            displayOnHUD = Boolean.parseBoolean(exploded[3]);
                        }
                        toggleval = false;
                        if (exploded.length <= 4) continue;
                        toggleval = Boolean.parseBoolean(exploded[4]);
                        continue;
                    }
                    id = null;
                    continue;
                }
                if (!line.contains("~") || id == null) continue;
                exploded = line.split("~");
                ResourceLocation regName = new ResourceLocation("powersuits", exploded[0]);
                boolean finalDisplayOnHUD = displayOnHUD;
                InputMappings.Input finalId = id;
                boolean finalToggleval = toggleval;
                this.getMPSKeyBinds().stream().filter(kb -> kb.registryName.equals((Object)regName)).findFirst().ifPresent(kb -> {
                    kb.showOnHud = finalDisplayOnHUD;
                    if (finalId != null) {
                        kb.setKeyInternal(finalId);
                    }
                    kb.toggleval = finalToggleval;
                });
            }
            reader.close();
        }
        catch (Exception e) {
            NuminaLogger.logger.error("Problem reading in keyconfig :(");
            e.printStackTrace();
        }
    }

    public InputMappings.Input getInputByCode(int keyCode) {
        return InputMappings.Type.KEYSYM.func_197944_a(keyCode);
    }
}

