/*
 * Decompiled with CFR 0.152.
 */
package lehjr.powersuits.client.gui.clickable;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import lehjr.numina.client.gui.clickable.ClickableButton2;
import lehjr.numina.client.gui.clickable.ClickableModule;
import lehjr.numina.client.gui.clickable.IClickable;
import lehjr.numina.client.gui.gemoetry.MusePoint2D;
import lehjr.numina.client.render.NuminaRenderer;
import lehjr.numina.common.capabilities.inventory.modularitem.IModularItem;
import lehjr.numina.common.math.Colour;
import lehjr.numina.common.network.NuminaPackets;
import lehjr.numina.common.network.packets.ToggleRequestPacket;
import lehjr.numina.common.string.StringUtils;
import lehjr.powersuits.client.control.KeybindManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.items.CapabilityItemHandler;

public class ClickableKeybinding
extends ClickableButton2 {
    public boolean toggleval = false;
    public boolean displayOnHUD;
    protected List<ClickableModule> boundModules = new ArrayList<ClickableModule>();
    boolean toggled = false;
    KeyBinding keybind;

    public ClickableKeybinding(KeyBinding keybind, MusePoint2D position, boolean free, Boolean displayOnHUD) {
        super(ClickableKeybinding.parseName(keybind), position, true);
        this.displayOnHUD = displayOnHUD != null ? displayOnHUD : false;
        this.keybind = keybind;
    }

    static ITextComponent parseName(KeyBinding keybind) {
        if (keybind.getKey().func_197937_c() < 0) {
            return new TranslationTextComponent("Mouse" + (keybind.getKey().func_197937_c() + 100));
        }
        return new TranslationTextComponent(keybind.getKey().func_197935_d());
    }

    public void doToggleTick() {
        this.doToggleIf(this.keybind.func_151468_f());
    }

    public void doToggleIf(boolean value) {
        if (value && !this.toggled) {
            this.toggleModules();
            KeybindManager.INSTANCE.writeOutKeybindSetings();
        }
        this.toggled = value;
    }

    public void toggleModules() {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        for (ClickableModule module : this.boundModules) {
            ResourceLocation registryName = module.getModule().func_77973_b().getRegistryName();
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                player.field_71071_by.func_70301_a(i).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).filter(IModularItem.class::isInstance).map(IModularItem.class::cast).ifPresent(handler -> handler.toggleModule(registryName, this.toggleval));
            }
            NuminaPackets.CHANNEL_INSTANCE.sendToServer((Object)new ToggleRequestPacket(registryName, this.toggleval));
        }
        this.toggleval = !this.toggleval;
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        for (ClickableModule module : this.boundModules) {
            NuminaRenderer.drawLineBetween((IClickable)this, (IClickable)module, (Colour)Colour.LIGHT_BLUE, (float)0.0f);
            matrixStack.func_227860_a_();
            matrixStack.func_227862_a_(0.5f, 0.5f, 0.5f);
            matrixStack.func_227861_a_(0.0, 0.0, 100.0);
            if (this.displayOnHUD) {
                StringUtils.drawShadowedString((MatrixStack)matrixStack, (String)StringUtils.wrapFormatTags((String)"HUD", (StringUtils.FormatCodes)StringUtils.FormatCodes.BrightGreen), (double)(this.getPosition().getX() * 2.0 + 6.0), (double)(this.getPosition().getY() * 2.0 + 6.0));
            } else {
                StringUtils.drawShadowedString((MatrixStack)matrixStack, (String)StringUtils.wrapFormatTags((String)"x", (StringUtils.FormatCodes)StringUtils.FormatCodes.Red), (double)(this.getPosition().getX() * 2.0 + 6.0), (double)(this.getPosition().getY() * 2.0 + 6.0));
            }
            matrixStack.func_227865_b_();
        }
    }

    public KeyBinding getKeyBinding() {
        return this.keybind;
    }

    public List<ClickableModule> getBoundModules() {
        return this.boundModules;
    }

    public void bindModule(ClickableModule module) {
        if (!this.boundModules.contains(module)) {
            this.boundModules.add(module);
        }
    }

    public void unbindModule(ClickableModule module) {
        this.boundModules.remove(module);
    }

    public void unbindFarModules() {
        Iterator<ClickableModule> iterator = this.boundModules.iterator();
        while (iterator.hasNext()) {
            ClickableModule module = iterator.next();
            int maxDistance = this.getTargetDistance() * 2;
            double distanceSq = module.getPosition().distanceSq(this.getPosition());
            if (!(distanceSq > (double)(maxDistance * maxDistance))) continue;
            iterator.remove();
        }
    }

    public int getTargetDistance() {
        return this.boundModules.size() > 6 ? 16 + (this.boundModules.size() - 6) * 3 : 16;
    }

    public void attractBoundModules(IClickable exception) {
        for (ClickableModule module : this.boundModules) {
            if (module.equals(exception)) continue;
            MusePoint2D euclideanDistance = module.getPosition().minus(this.getPosition());
            MusePoint2D directionVector = euclideanDistance.normalize();
            MusePoint2D tangentTarget = directionVector.times((double)this.getTargetDistance()).plus(this.getPosition());
            MusePoint2D midpointTangent = module.getPosition().midpoint(tangentTarget);
            module.setPosition(midpointTangent.copy());
        }
    }

    public boolean equals(ClickableKeybinding other) {
        return other.keybind.getKey().func_197937_c() == this.keybind.getKey().func_197937_c();
    }

    public void toggleHUDState() {
        this.displayOnHUD = !this.displayOnHUD;
    }
}

