/*
 * Decompiled with CFR 0.152.
 */
package lehjr.powersuits.client.gui.keybind;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import lehjr.numina.client.gui.clickable.CheckBox;
import lehjr.numina.client.gui.clickable.ClickableButton2;
import lehjr.numina.client.gui.frame.ScrollableFrame;
import lehjr.numina.client.gui.gemoetry.MusePoint2D;
import lehjr.numina.client.gui.gemoetry.RelativeRect;
import lehjr.numina.client.render.NuminaRenderer;
import lehjr.numina.common.math.Colour;
import lehjr.powersuits.client.control.KeybindManager;
import lehjr.powersuits.client.control.MPSKeyBinding;
import lehjr.powersuits.client.event.RenderEventHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.registries.ForgeRegistries;
import org.lwjgl.glfw.GLFW;

public class KeyBindFrame
extends ScrollableFrame {
    @Nullable
    MPSKeyBinding keybindingToRemap = null;
    Map<MPSKeyBinding, Pair<CheckBox, ClickableButton2>> checkBoxList = new HashMap<MPSKeyBinding, Pair<CheckBox, ClickableButton2>>();

    public KeyBindFrame(MusePoint2D topleft, MusePoint2D bottomright) {
        super(topleft, bottomright, Colour.DARK_GREY, new Colour(0.216f, 0.216f, 0.216f, 1.0f), Colour.WHITE.withAlpha(0.8f));
        this.enableAndShow();
        this.keybindingToRemap = null;
    }

    public RelativeRect init(double left, double top, double right, double bottom) {
        super.init(left, top, right, bottom);
        this.loadConditions();
        return this;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.loadConditions();
    }

    public void loadConditions() {
        Arrays.stream(Minecraft.func_71410_x().field_71474_y.field_74324_K).filter(MPSKeyBinding.class::isInstance).map(MPSKeyBinding.class::cast).forEach(keyBinding -> {
            CheckBox checkbox = new CheckBox(MusePoint2D.ZERO, (ITextComponent)new TranslationTextComponent(keyBinding.func_151464_g()), false);
            checkbox.setChecked(keyBinding.showOnHud);
            checkbox.setOnPressed(onPressed -> {
                keyBinding.showOnHud = checkbox.isChecked();
                KeybindManager.INSTANCE.writeOutKeybindSetings();
                RenderEventHandler.INSTANCE.makeKBDisplayList();
            });
            checkbox.enableAndShow();
            ClickableButton2 button = new ClickableButton2(keyBinding.getKey().func_237520_d_(), MusePoint2D.ZERO, true);
            button.setOnPressed(onPressed -> {
                this.keybindingToRemap = keyBinding;
            });
            button.setWidth(95.0);
            button.setHeight(16.0);
            this.checkBoxList.put((MPSKeyBinding)((Object)keyBinding), (Pair<CheckBox, ClickableButton2>)Pair.of((Object)checkbox, (Object)button));
        });
        this.setTotalSize(this.checkBoxList.size() * 20);
    }

    static boolean isKeyPressed(int key) {
        return GLFW.glfwGetKey((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)key) == 1;
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        if (this.isEnabled() && this.isVisible()) {
            super.preRender(matrixStack, mouseX, mouseY, partialTicks);
            RenderSystem.pushMatrix();
            RenderSystem.translated((double)0.0, (double)(-this.currentScrollPixels), (double)0.0);
            double y = this.top() + 8.0;
            for (Map.Entry<MPSKeyBinding, Pair<CheckBox, ClickableButton2>> entry : this.checkBoxList.entrySet()) {
                NuminaRenderer.drawModuleAt((MatrixStack)matrixStack, (double)(this.finalLeft() + 2.0), (double)(y - 8.0), (ItemStack)new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(entry.getKey().registryName)), (boolean)true);
                MPSKeyBinding kb = entry.getKey();
                CheckBox checkbox = (CheckBox)entry.getValue().getFirst();
                checkbox.setPosition(new MusePoint2D(this.finalLeft() + 24.0, y));
                checkbox.enableAndShow();
                checkbox.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
                ClickableButton2 button = (ClickableButton2)entry.getValue().getSecond();
                if (this.keybindingToRemap != null && this.keybindingToRemap == kb) {
                    button.setLable((ITextComponent)new StringTextComponent("> ").func_230529_a_((ITextComponent)kb.getKey().func_237520_d_().func_230532_e_().func_240699_a_(TextFormatting.YELLOW)).func_240702_b_(" <").func_240699_a_(TextFormatting.YELLOW));
                } else {
                    button.setLable((ITextComponent)kb.getKey().func_237520_d_().func_230532_e_().func_240699_a_(TextFormatting.WHITE));
                }
                button.setRight(this.finalRight() - 2.0);
                button.setTop(y - 8.0);
                button.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
                y += 20.0;
            }
            RenderSystem.popMatrix();
            super.postRender(mouseX, mouseY, partialTicks);
        } else {
            super.preRender(matrixStack, mouseX, mouseY, partialTicks);
            super.postRender(mouseX, mouseY, partialTicks);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isEnabled() && this.isVisible()) {
            super.mouseClicked(mouseX, mouseY, button);
            for (Pair<CheckBox, ClickableButton2> pair : this.checkBoxList.values()) {
                if (!((CheckBox)pair.getFirst()).mouseClicked(mouseX, mouseY + (double)this.getCurrentScrollPixels(), button) && !((ClickableButton2)pair.getSecond()).mouseClicked(mouseX, mouseY + (double)this.getCurrentScrollPixels(), button)) continue;
                return true;
            }
        }
        return false;
    }

    public List<ITextComponent> getToolTip(int x, int y) {
        if (this.isEnabled() && this.isVisible()) {
            for (Pair<CheckBox, ClickableButton2> pair : this.checkBoxList.values()) {
                if (!((CheckBox)pair.getFirst()).hitBox((double)x, (double)y)) continue;
                return Arrays.asList(new TranslationTextComponent("gui.powersuits.showOnHUD"));
            }
        }
        return super.getToolTip(x, y);
    }
}

