/*
 * Decompiled with CFR 0.152.
 */
package lehjr.powersuits.client.gui.modding.cosmetic;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import lehjr.numina.client.gui.frame.ScrollableFrame;
import lehjr.numina.client.gui.gemoetry.IRect;
import lehjr.numina.client.gui.gemoetry.RelativeRect;
import lehjr.numina.common.capabilities.render.modelspec.EnumSpecType;
import lehjr.numina.common.capabilities.render.modelspec.ModelRegistry;
import lehjr.numina.common.capabilities.render.modelspec.SpecBase;
import lehjr.numina.common.math.Colour;
import lehjr.powersuits.client.gui.common.ModularItemSelectionFrame;
import lehjr.powersuits.client.gui.common.ModularItemTabToggleWidget;
import lehjr.powersuits.client.gui.modding.cosmetic.ColourPickerFrame;
import lehjr.powersuits.client.gui.modding.cosmetic.PartSpecManipSubFrame;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class PartManipContainer
extends ScrollableFrame {
    public ModularItemSelectionFrame itemSelect;
    public ColourPickerFrame colourSelect;
    public ModularItemTabToggleWidget lastItemSlot;
    public int lastColour;
    public int lastColourIndex;
    public List<PartSpecManipSubFrame> modelframes;

    public PartManipContainer(ModularItemSelectionFrame itemSelect, ColourPickerFrame colourSelect) {
        this.itemSelect = itemSelect;
        this.colourSelect = colourSelect;
        this.lastItemSlot = null;
        this.lastColour = this.getColour();
        this.lastColourIndex = this.getColourIndex();
        this.enableAndShow();
    }

    public RelativeRect init(double left, double top, double right, double bottom) {
        super.init(left, top, right, bottom);
        if (!this.itemSelect.playerHasModularItems()) {
            this.disable();
            this.hide();
        } else {
            this.enable();
            this.show();
            this.refreshModelframes();
        }
        return this;
    }

    @Nonnull
    public ItemStack getItem() {
        return this.itemSelect.getModularItemOrEmpty();
    }

    public int getColour() {
        if (this.getItem().func_190926_b()) {
            return Colour.WHITE.getInt();
        }
        if (this.colourSelect.selectedColour < this.colourSelect.colours().length && this.colourSelect.selectedColour >= 0) {
            return this.colourSelect.colours()[this.colourSelect.selectedColour];
        }
        return Colour.WHITE.getInt();
    }

    public int getColourIndex() {
        return this.colourSelect.selectedColour;
    }

    public void refreshModelframes() {
        this.modelframes = new ArrayList<PartSpecManipSubFrame>();
        if (!this.getItem().func_190926_b()) {
            Iterable specCollection = ModelRegistry.getInstance().getSpecs();
            PartSpecManipSubFrame prev = null;
            for (SpecBase modelspec : specCollection) {
                PartSpecManipSubFrame newframe;
                if (!this.isSpecValid(modelspec) || (newframe = this.createNewFrame(modelspec, prev)).getPartSpecs().isEmpty()) continue;
                prev = newframe;
                this.modelframes.add(newframe);
            }
        }
    }

    boolean isSpecValid(SpecBase specBase) {
        if (!this.getItem().func_190926_b()) {
            Item item = this.getItem().func_77973_b();
            if (item instanceof ArmorItem) {
                EquipmentSlotType slotType = ((ArmorItem)item).func_185083_B_();
                return specBase.getSpecType().equals((Object)EnumSpecType.ARMOR_MODEL) || specBase.getSpecType().equals((Object)EnumSpecType.ARMOR_SKIN) && this.doesSpecHaveSlotType(specBase, slotType);
            }
            return specBase.getSpecType().equals((Object)EnumSpecType.HANDHELD) && (this.doesSpecHaveSlotType(specBase, EquipmentSlotType.OFFHAND) || this.doesSpecHaveSlotType(specBase, EquipmentSlotType.MAINHAND));
        }
        return false;
    }

    boolean doesSpecHaveSlotType(SpecBase specBase, EquipmentSlotType slot) {
        AtomicBoolean hasType = new AtomicBoolean(false);
        specBase.getPartSpecs().forEach(spec -> {
            if (spec.getBinding().getSlot().equals((Object)slot)) {
                hasType.set(true);
            }
        });
        return hasType.get();
    }

    public PartSpecManipSubFrame createNewFrame(SpecBase modelspec, PartSpecManipSubFrame prev) {
        PartSpecManipSubFrame newFrame = new PartSpecManipSubFrame(modelspec, this.finalLeft() + 4.0, this.finalTop() + 4.0, this.finalRight(), this.finalTop() + 10.0, this.colourSelect, this.itemSelect, this.zLevel);
        newFrame.setMeBelow((IRect)(prev != null ? prev : null));
        return newFrame;
    }

    public boolean mouseClicked(double x, double y, int button) {
        if (this.isEnabled() && this.isVisible() && this.containsPoint(x, y) && button == 0) {
            for (PartSpecManipSubFrame frame : this.modelframes) {
                if (!frame.tryMouseClick(x, y + (double)this.currentScrollPixels)) continue;
                return true;
            }
        }
        return false;
    }

    public void update(double mousex, double mousey) {
        super.update(mousex, mousey);
        if (!this.itemSelect.playerHasModularItems()) {
            this.disableAndHide();
        } else if (!Objects.equals((Object)this.lastItemSlot, (Object)this.itemSelect.getSelectedTab().get())) {
            this.setCurrentScrollPixels(0);
            this.lastItemSlot = this.itemSelect.getSelectedTab().get();
            this.refreshModelframes();
            if (!this.itemSelect.getModularItemOrEmpty().func_190926_b()) {
                double y = 0.0;
                for (PartSpecManipSubFrame subframe : this.modelframes) {
                    subframe.refreshPartSpecs();
                    y += subframe.finalHeight() + 1.0;
                }
                if (this.colourSelect.decrAbove > -1) {
                    this.decrAbove(this.colourSelect.decrAbove);
                    this.colourSelect.decrAbove = -1;
                }
                this.totalSize = (int)y + 10;
            }
        }
    }

    public void decrAbove(int index) {
        for (PartSpecManipSubFrame frame : this.modelframes) {
            frame.decrAbove(index);
        }
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        if (this.isVisible() && !this.modelframes.isEmpty()) {
            super.preRender(matrixStack, mouseX, mouseY, partialTicks);
            RenderSystem.pushMatrix();
            RenderSystem.translated((double)0.0, (double)(-this.currentScrollPixels), (double)0.0);
            for (PartSpecManipSubFrame f : this.modelframes) {
                f.drawPartial(matrixStack, (double)(this.currentScrollPixels + 4) + this.finalTop(), (double)this.currentScrollPixels + this.finalBottom() - 4.0);
            }
            RenderSystem.popMatrix();
            super.postRender(mouseX, mouseY, partialTicks);
        } else {
            super.preRender(matrixStack, mouseX, mouseY, partialTicks);
            super.postRender(mouseX, mouseY, partialTicks);
        }
    }
}

