/*
 * Decompiled with CFR 0.152.
 */
package lehjr.powersuits.common.blockentity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lehjr.numina.common.base.NuminaLogger;
import lehjr.numina.common.blockentity.NuminaBlockEntity;
import lehjr.numina.common.capabilities.render.colour.ColourCapability;
import lehjr.numina.common.capabilities.render.colour.ColourNBT;
import lehjr.numina.common.math.Colour;
import lehjr.powersuits.client.model.helper.LuxCapHelper;
import lehjr.powersuits.common.base.MPSObjects;
import lehjr.powersuits.common.block.LuxCapacitorBlock;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class LuxCapacitorBlockEntity
extends NuminaBlockEntity {
    LazyOptional<ColourNBT> colourNBT = LazyOptional.of(() -> new ColourNBT());

    public LuxCapacitorBlockEntity() {
        super((TileEntityType)MPSObjects.LUX_CAP_TILE_TYPE.get());
    }

    public LuxCapacitorBlockEntity(Colour colour) {
        super((TileEntityType)MPSObjects.LUX_CAP_TILE_TYPE.get());
        this.colourNBT.ifPresent(colourNBT1 -> colourNBT1.setColour(colour));
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, -1, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void setColor(Colour colour) {
        this.colourNBT.ifPresent(colourNBT1 -> colourNBT1.setColour(colour));
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        this.colourNBT.ifPresent(colourNBT1 -> nbt.func_218657_a("colour", (INBT)colourNBT1.serializeNBT()));
        return super.func_189515_b(nbt);
    }

    @Nonnull
    public IModelData getModelData() {
        return LuxCapHelper.getModelData(this.getColor().getInt());
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ColourCapability.COLOUR) {
            return this.colourNBT.cast();
        }
        return super.getCapability(cap, side);
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        if (nbt.func_150297_b("colour", 3)) {
            this.colourNBT.ifPresent(colourNBT1 -> colourNBT1.deserializeNBT((IntNBT)nbt.func_74781_a("colour")));
        } else {
            NuminaLogger.logger.debug("No NBT found! D:");
        }
        super.func_230337_a_(state, nbt);
    }

    public Colour getColor() {
        return this.colourNBT.map(colourNBT1 -> colourNBT1.getColour()).orElse(LuxCapacitorBlock.defaultColor);
    }
}

