/*
 * Decompiled with CFR 0.152.
 */
package lehjr.powersuits.common.capability;

import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lehjr.numina.common.capabilities.heat.HeatCapability;
import lehjr.numina.common.capabilities.heat.HeatItemWrapper;
import lehjr.numina.common.capabilities.heat.IHeatStorage;
import lehjr.numina.common.capabilities.inventory.modularitem.ModularItem;
import lehjr.numina.common.capabilities.inventory.modularitem.NuminaRangedWrapper;
import lehjr.numina.common.capabilities.module.powermodule.ModuleCategory;
import lehjr.numina.common.capabilities.module.powermodule.PowerModuleCapability;
import lehjr.numina.common.capabilities.render.IModelSpecNBT;
import lehjr.numina.common.capabilities.render.ModelSpecNBTCapability;
import lehjr.powersuits.client.render.ArmorModelSpecNBT;
import lehjr.powersuits.common.config.MPSSettings;
import lehjr.powersuits.common.constants.MPSRegistryNames;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class PowerArmorCap
implements ICapabilityProvider {
    final ItemStack itemStack;
    final EquipmentSlotType targetSlot;
    final ModularItem modularItem;
    final LazyOptional<IItemHandler> modularItemHolder;
    final ArmorModelSpecNBT modelSpec;
    final LazyOptional<IModelSpecNBT> modelSpecHolder;
    final LazyOptional<IHeatStorage> heatHolder;
    final LazyOptional<IFluidHandlerItem> fluidHolder;
    double maxHeat;

    public PowerArmorCap(@Nonnull ItemStack itemStackIn, EquipmentSlotType slot) {
        this.itemStack = itemStackIn;
        this.targetSlot = slot;
        final HashMap rangedWrapperMap = new HashMap();
        switch (this.targetSlot) {
            case HEAD: {
                this.modularItem = new ModularItem(this.itemStack, 18){
                    {
                        super(arg0, arg1);
                        rangedWrapperMap.put(ModuleCategory.ARMOR, new NuminaRangedWrapper((IItemHandlerModifiable)this, 0, 1));
                        rangedWrapperMap.put(ModuleCategory.ENERGY_STORAGE, new NuminaRangedWrapper((IItemHandlerModifiable)this, 1, 2));
                        rangedWrapperMap.put(ModuleCategory.ENERGY_GENERATION, new NuminaRangedWrapper((IItemHandlerModifiable)this, 2, 3));
                        rangedWrapperMap.put(ModuleCategory.NONE, new NuminaRangedWrapper((IItemHandlerModifiable)this, 3, this.getSlots()));
                        this.setRangedWrapperMap(rangedWrapperMap);
                    }
                };
                this.maxHeat = MPSSettings.getMaxHeatHelmet();
                break;
            }
            case CHEST: {
                this.modularItem = new ModularItem(this.itemStack, 18){
                    {
                        super(arg0, arg1);
                        rangedWrapperMap.put(ModuleCategory.ARMOR, new NuminaRangedWrapper((IItemHandlerModifiable)this, 0, 1));
                        rangedWrapperMap.put(ModuleCategory.ENERGY_STORAGE, new NuminaRangedWrapper((IItemHandlerModifiable)this, 1, 2));
                        rangedWrapperMap.put(ModuleCategory.ENERGY_GENERATION, new NuminaRangedWrapper((IItemHandlerModifiable)this, 2, 3));
                        rangedWrapperMap.put(ModuleCategory.NONE, new NuminaRangedWrapper((IItemHandlerModifiable)this, 3, this.getSlots()));
                        this.setRangedWrapperMap(rangedWrapperMap);
                    }
                };
                this.maxHeat = MPSSettings.getMaxHeatChestplate();
                break;
            }
            case LEGS: {
                this.modularItem = new ModularItem(itemStackIn, 10){
                    {
                        super(arg0, arg1);
                        rangedWrapperMap.put(ModuleCategory.ARMOR, new NuminaRangedWrapper((IItemHandlerModifiable)this, 0, 1));
                        rangedWrapperMap.put(ModuleCategory.ENERGY_STORAGE, new NuminaRangedWrapper((IItemHandlerModifiable)this, 1, 2));
                        rangedWrapperMap.put(ModuleCategory.ENERGY_GENERATION, new NuminaRangedWrapper((IItemHandlerModifiable)this, 2, 3));
                        rangedWrapperMap.put(ModuleCategory.NONE, new NuminaRangedWrapper((IItemHandlerModifiable)this, 3, this.getSlots()));
                        this.setRangedWrapperMap(rangedWrapperMap);
                    }
                };
                this.maxHeat = MPSSettings.getMaxHeatLegs();
                break;
            }
            case FEET: {
                this.modularItem = new ModularItem(this.itemStack, 8){
                    {
                        super(arg0, arg1);
                        rangedWrapperMap.put(ModuleCategory.ARMOR, new NuminaRangedWrapper((IItemHandlerModifiable)this, 0, 1));
                        rangedWrapperMap.put(ModuleCategory.ENERGY_STORAGE, new NuminaRangedWrapper((IItemHandlerModifiable)this, 1, 2));
                        rangedWrapperMap.put(ModuleCategory.NONE, new NuminaRangedWrapper((IItemHandlerModifiable)this, 2, this.getSlots()));
                        this.setRangedWrapperMap(rangedWrapperMap);
                    }
                };
                this.maxHeat = MPSSettings.getMaxHeatBoots();
                break;
            }
            default: {
                this.modularItem = new ModularItem(this.itemStack, 8);
            }
        }
        this.modularItemHolder = LazyOptional.of(() -> {
            this.modularItem.updateFromNBT();
            return this.modularItem;
        });
        this.modelSpec = new ArmorModelSpecNBT(itemStackIn);
        this.modelSpecHolder = LazyOptional.of(() -> this.modelSpec);
        this.heatHolder = LazyOptional.of(() -> {
            this.modularItem.updateFromNBT();
            HeatItemWrapper heatStorage = new HeatItemWrapper(this.itemStack, this.maxHeat, this.modularItem.getStackInSlot(0).getCapability(PowerModuleCapability.POWER_MODULE));
            heatStorage.updateFromNBT();
            return heatStorage;
        });
        this.fluidHolder = LazyOptional.of(() -> {
            if (this.targetSlot == EquipmentSlotType.CHEST) {
                this.modularItem.updateFromNBT();
                return (IFluidHandlerItem)this.modularItem.getOnlineModuleOrEmpty(MPSRegistryNames.FLUID_TANK_MODULE).getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).orElse((Object)new EmptyFluidHandler());
            }
            return new EmptyFluidHandler();
        });
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == null) {
            return LazyOptional.empty();
        }
        LazyOptional modularItemCapability = CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.orEmpty(cap, this.modularItemHolder);
        if (modularItemCapability.isPresent()) {
            return modularItemCapability;
        }
        LazyOptional modelSpecCapability = ModelSpecNBTCapability.RENDER.orEmpty(cap, this.modelSpecHolder);
        if (modelSpecCapability.isPresent()) {
            return modelSpecCapability;
        }
        LazyOptional heatCapability = HeatCapability.HEAT.orEmpty(cap, this.heatHolder);
        if (heatCapability.isPresent()) {
            return heatCapability;
        }
        if (cap == CapabilityEnergy.ENERGY) {
            this.modularItem.updateFromNBT();
            return this.modularItem.getStackInSlot(1).getCapability(cap, side);
        }
        LazyOptional fluidCapability = CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY.orEmpty(cap, this.fluidHolder);
        if (fluidCapability.isPresent()) {
            return fluidCapability;
        }
        return LazyOptional.empty();
    }

    class EmptyFluidHandler
    extends FluidHandlerItemStack {
        public EmptyFluidHandler() {
            super(ItemStack.field_190927_a, 0);
        }
    }
}

