/*
 * Decompiled with CFR 0.152.
 */
package lehjr.powersuits.common.item.module.armor;

import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lehjr.numina.common.capabilities.module.powermodule.IConfig;
import lehjr.numina.common.capabilities.module.powermodule.IPowerModule;
import lehjr.numina.common.capabilities.module.powermodule.ModuleCategory;
import lehjr.numina.common.capabilities.module.powermodule.ModuleTarget;
import lehjr.numina.common.capabilities.module.powermodule.PowerModuleCapability;
import lehjr.numina.common.capabilities.module.tickable.PlayerTickModule;
import lehjr.numina.common.energy.ElectricItemUtils;
import lehjr.powersuits.common.config.MPSSettings;
import lehjr.powersuits.common.item.module.AbstractPowerModule;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

public class EnergyShieldModule
extends AbstractPowerModule {
    @Override
    @Nullable
    public ICapabilityProvider initCapabilities(@Nonnull ItemStack stack, @Nullable CompoundNBT nbt) {
        return new CapProvider(stack);
    }

    public class CapProvider
    implements ICapabilityProvider {
        ItemStack module;
        private final Ticker ticker;
        private final LazyOptional<IPowerModule> powerModuleHolder;

        public CapProvider(ItemStack module) {
            this.module = module;
            this.ticker = new Ticker(module, ModuleCategory.ARMOR, ModuleTarget.ARMORONLY, MPSSettings::getModuleConfig, true){
                {
                    super(module, category, target, config, defBool);
                    this.addTradeoffProperty("fieldStrength", "armorEnergy", 6.0, "module.tradeoff.armorPoints");
                    this.addTradeoffProperty("fieldStrength", "armorEnergyPerDamage", 5000.0, "FE");
                    this.addTradeoffProperty("fieldStrength", "maxHeat", 500.0);
                    this.addBaseProperty("knockbackResistance", 0.25);
                }

                public int getTier() {
                    return 3;
                }

                public String getModuleGroup() {
                    return "Armor";
                }
            };
            this.powerModuleHolder = LazyOptional.of(() -> {
                this.ticker.updateFromNBT();
                return this.ticker;
            });
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
            LazyOptional powerModuleCapability = PowerModuleCapability.POWER_MODULE.orEmpty(capability, this.powerModuleHolder);
            if (powerModuleCapability.isPresent()) {
                return powerModuleCapability;
            }
            return LazyOptional.empty();
        }

        class Ticker
        extends PlayerTickModule {
            public Ticker(ItemStack module, ModuleCategory category, ModuleTarget target, Callable<IConfig> config, boolean defBool) {
                super(module, category, target, config, defBool);
            }

            public void onPlayerTickActive(PlayerEntity player, @Nonnull ItemStack item) {
                int energyUsage;
                int energy = ElectricItemUtils.getPlayerEnergy((LivingEntity)player);
                if (energy < (energyUsage = (int)this.applyPropertyModifiers("armorEnergyPerDamage"))) {
                    this.toggleModule(false);
                }
            }
        }
    }
}

