/*
 * Decompiled with CFR 0.152.
 */
package lehjr.powersuits.common.item.module.miningenhancement;

import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lehjr.numina.common.capabilities.module.enchantment.IEnchantmentModule;
import lehjr.numina.common.capabilities.module.miningenhancement.MiningEnhancement;
import lehjr.numina.common.capabilities.module.powermodule.IConfig;
import lehjr.numina.common.capabilities.module.powermodule.IPowerModule;
import lehjr.numina.common.capabilities.module.powermodule.ModuleCategory;
import lehjr.numina.common.capabilities.module.powermodule.ModuleTarget;
import lehjr.numina.common.capabilities.module.powermodule.PowerModuleCapability;
import lehjr.numina.common.energy.ElectricItemUtils;
import lehjr.powersuits.common.config.MPSSettings;
import lehjr.powersuits.common.item.module.AbstractPowerModule;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

public class FortuneModule
extends AbstractPowerModule {
    @Override
    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new CapProvider(stack);
    }

    public class CapProvider
    implements ICapabilityProvider {
        ItemStack module;
        private final Enhancement miningEnhancement;
        private final LazyOptional<IPowerModule> powerModuleHolder;

        public CapProvider(ItemStack module) {
            this.module = module;
            this.miningEnhancement = new Enhancement(module, ModuleCategory.MINING_ENHANCEMENT, ModuleTarget.TOOLONLY, MPSSettings::getModuleConfig){
                {
                    super(module, category, target, config);
                    this.addBaseProperty("fortuneEnCon", 500.0, "FE");
                    this.addTradeoffProperty("enchLevel", "fortuneEnCon", 9500.0);
                    this.addIntTradeoffProperty("enchLevel", "fortuneLevel", 3, "", 1, 1);
                }
            };
            this.powerModuleHolder = LazyOptional.of(() -> {
                this.miningEnhancement.updateFromNBT();
                return this.miningEnhancement;
            });
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
            LazyOptional powerModuleCapability = PowerModuleCapability.POWER_MODULE.orEmpty(capability, this.powerModuleHolder);
            if (powerModuleCapability.isPresent()) {
                return powerModuleCapability;
            }
            return LazyOptional.empty();
        }

        class Enhancement
        extends MiningEnhancement
        implements IEnchantmentModule {
            public Enhancement(ItemStack module, ModuleCategory category, ModuleTarget target, Callable<IConfig> config) {
                super(module, category, target, config);
            }

            public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, PlayerEntity player) {
                if (!player.field_70170_p.field_72995_K) {
                    if (this.getEnergyUsage() > ElectricItemUtils.getPlayerEnergy((LivingEntity)player)) {
                        this.removeEnchantment(itemstack);
                    } else {
                        ElectricItemUtils.drainPlayerEnergy((LivingEntity)player, (int)this.getEnergyUsage());
                    }
                }
                return false;
            }

            public int getEnergyUsage() {
                return (int)this.applyPropertyModifiers("fortuneEnCon");
            }

            public Enchantment getEnchantment() {
                return Enchantments.field_185308_t;
            }

            public int getLevel(@Nonnull ItemStack itemStack) {
                return (int)this.applyPropertyModifiers("fortuneLevel");
            }
        }
    }
}

