/*
 * Decompiled with CFR 0.152.
 */
package lehjr.powersuits.common.item.module.movement;

import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lehjr.numina.common.capabilities.module.powermodule.IConfig;
import lehjr.numina.common.capabilities.module.powermodule.IPowerModule;
import lehjr.numina.common.capabilities.module.powermodule.ModuleCategory;
import lehjr.numina.common.capabilities.module.powermodule.ModuleTarget;
import lehjr.numina.common.capabilities.module.powermodule.PowerModuleCapability;
import lehjr.numina.common.capabilities.module.rightclick.RightClickModule;
import lehjr.numina.common.energy.ElectricItemUtils;
import lehjr.numina.common.heat.HeatUtils;
import lehjr.powersuits.common.config.MPSSettings;
import lehjr.powersuits.common.item.module.AbstractPowerModule;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.common.util.LazyOptional;

public class DimensionalRiftModule
extends AbstractPowerModule {
    @Override
    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new CapProvider(stack);
    }

    static boolean isOutsideWorldBounds(World world, BlockPos pos) {
        if (world == null || pos == null) {
            return true;
        }
        return pos.func_177956_o() <= 0 || pos.func_177956_o() >= world.func_234938_ad_();
    }

    public Optional<BlockPos> findSafeLocation(BlockPos targetPos, Direction.Axis axis, World world, PlayerEntity entity) {
        Direction direction = Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis);
        double d0 = -1.0;
        BlockPos destination = null;
        double d1 = -1.0;
        BlockPos blockpos1 = null;
        WorldBorder worldborder = world.func_175723_af();
        int ceilingLimit = world.func_234938_ad_() - 1;
        for (BlockPos.Mutable mutablePos : BlockPos.func_243514_a((BlockPos)targetPos, (int)16, (Direction)Direction.EAST, (Direction)Direction.SOUTH)) {
            int j = Math.min(ceilingLimit, world.func_201676_a(Heightmap.Type.MOTION_BLOCKING, mutablePos.func_177958_n(), mutablePos.func_177952_p()));
            int k = 1;
            if (!worldborder.func_177746_a((BlockPos)mutablePos) || !worldborder.func_177746_a((BlockPos)mutablePos.func_189534_c(direction, k))) continue;
            mutablePos.func_189534_c(direction.func_176734_d(), k);
            for (int l = j; l >= 0; --l) {
                int j1;
                mutablePos.func_185336_p(l);
                if (!world.func_175623_d((BlockPos)mutablePos)) continue;
                int i1 = l;
                while (l > 0 && world.func_175623_d((BlockPos)mutablePos.func_189536_c(Direction.DOWN))) {
                    --l;
                }
                if (l + 4 > ceilingLimit || (j1 = i1 - l) > 0 && j1 < 3) continue;
                mutablePos.func_185336_p(l);
                if (!DimensionalRiftModule.canTeleportTo(world, (BlockPos)mutablePos, entity)) continue;
                return Optional.of(mutablePos);
            }
        }
        if (d0 == -1.0 && d1 != -1.0) {
            destination = blockpos1;
            d0 = d1;
        }
        if (d0 == -1.0 && !worldborder.func_177746_a(destination = new BlockPos(targetPos.func_177958_n(), MathHelper.func_76125_a((int)targetPos.func_177956_o(), (int)70, (int)(world.func_234938_ad_() - 10)), targetPos.func_177952_p()).func_185334_h())) {
            return Optional.empty();
        }
        return Optional.of(destination);
    }

    private static boolean canTeleportTo(World world, BlockPos pos, PlayerEntity playerEntity) {
        if (!DimensionalRiftModule.isOutsideWorldBounds(world, pos)) {
            BlockState state = world.func_180495_p(pos.func_177977_b());
            BlockPos blockpos = pos.func_177973_b((Vector3i)playerEntity.func_233580_cy_());
            return state.func_185904_a().func_76230_c() && state.func_200015_d((IBlockReader)world, pos.func_177977_b()) && world.func_226665_a__((Entity)playerEntity, playerEntity.func_174813_aQ().func_186670_a(blockpos));
        }
        return false;
    }

    private class CommandTeleporter
    implements ITeleporter {
        private final BlockPos targetPos;

        private CommandTeleporter(BlockPos targetPos) {
            this.targetPos = targetPos;
        }

        public Entity placeEntity(Entity entity, ServerWorld currentWorld, ServerWorld destWorld, float yaw, Function<Boolean, Entity> repositionEntity) {
            entity = repositionEntity.apply(false);
            entity.func_70634_a((double)this.targetPos.func_177958_n(), (double)this.targetPos.func_177956_o(), (double)this.targetPos.func_177952_p());
            return entity;
        }
    }

    public class CapProvider
    implements ICapabilityProvider {
        ItemStack module;
        private final RightClickie rightClickie;
        private final LazyOptional<IPowerModule> powerModuleHolder;

        public CapProvider(ItemStack module) {
            this.module = module;
            this.rightClickie = new RightClickie(module, ModuleCategory.MOVEMENT, ModuleTarget.TOOLONLY, MPSSettings::getModuleConfig){
                {
                    super(module, category, target, config);
                    this.addBaseProperty("heatGen", 55.0);
                    this.addBaseProperty("dimRiftEnergy", 200000.0);
                }
            };
            this.powerModuleHolder = LazyOptional.of(() -> this.rightClickie);
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
            LazyOptional powerModuleCapability = PowerModuleCapability.POWER_MODULE.orEmpty(capability, this.powerModuleHolder);
            if (powerModuleCapability.isPresent()) {
                return powerModuleCapability;
            }
            return LazyOptional.empty();
        }

        class RightClickie
        extends RightClickModule {
            public RightClickie(ItemStack module, ModuleCategory category, ModuleTarget target, Callable<IConfig> config) {
                super(module, category, target, config);
            }

            public ActionResult use(ItemStack itemStackIn, World worldIn, PlayerEntity playerIn, Hand hand) {
                if (!playerIn.func_184218_aH() && !playerIn.func_184207_aI() && playerIn.func_184222_aU() && !playerIn.field_70170_p.func_201670_d()) {
                    Object level = playerIn.field_70170_p.func_234923_W_().func_240901_a_().equals((Object)World.field_234919_h_.func_240901_a_()) ? playerIn.func_184102_h().func_71218_a(World.field_234918_g_) : (playerIn.field_70170_p.func_234923_W_().func_240901_a_().equals((Object)World.field_234918_g_.func_240901_a_()) ? playerIn.func_184102_h().func_71218_a(World.field_234919_h_) : null);
                    if (level != null) {
                        Optional<BlockPos> targetPos;
                        BlockPos coords = playerIn.func_233580_cy_();
                        int energyConsumption = (int)this.applyPropertyModifiers("dimRiftEnergy");
                        int playerEnergy = ElectricItemUtils.getPlayerEnergy((LivingEntity)playerIn);
                        if (playerEnergy >= energyConsumption && (targetPos = DimensionalRiftModule.this.findSafeLocation(coords, Direction.Axis.X, (World)level, playerIn)).isPresent()) {
                            playerIn.changeDimension(level, (ITeleporter)new CommandTeleporter(targetPos.get()));
                            ElectricItemUtils.drainPlayerEnergy((LivingEntity)playerIn, (int)this.getEnergyUsage());
                            HeatUtils.heatPlayer((LivingEntity)playerIn, (double)this.applyPropertyModifiers("heatGen"));
                            return ActionResult.func_226248_a_((Object)itemStackIn);
                        }
                    }
                    return ActionResult.func_226251_d_((Object)itemStackIn);
                }
                return ActionResult.func_226250_c_((Object)itemStackIn);
            }

            public int getEnergyUsage() {
                return (int)this.applyPropertyModifiers("dimRiftEnergy");
            }
        }
    }
}

