/*
 * Decompiled with CFR 0.152.
 */
package lehjr.powersuits.common.item.module.movement;

import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lehjr.numina.client.control.PlayerMovementInputWrapper;
import lehjr.numina.client.sound.Musique;
import lehjr.numina.common.capabilities.inventory.modularitem.IModularItem;
import lehjr.numina.common.capabilities.module.powermodule.IConfig;
import lehjr.numina.common.capabilities.module.powermodule.IPowerModule;
import lehjr.numina.common.capabilities.module.powermodule.ModuleCategory;
import lehjr.numina.common.capabilities.module.powermodule.ModuleTarget;
import lehjr.numina.common.capabilities.module.powermodule.PowerModuleCapability;
import lehjr.numina.common.capabilities.module.tickable.PlayerTickModule;
import lehjr.numina.common.config.NuminaSettings;
import lehjr.numina.common.energy.ElectricItemUtils;
import lehjr.powersuits.client.sound.MPSSoundDictionary;
import lehjr.powersuits.common.config.MPSSettings;
import lehjr.powersuits.common.constants.MPSRegistryNames;
import lehjr.powersuits.common.event.MovementManager;
import lehjr.powersuits.common.item.module.AbstractPowerModule;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;

public class JetBootsModule
extends AbstractPowerModule {
    @Override
    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new CapProvider(stack);
    }

    public class CapProvider
    implements ICapabilityProvider {
        ItemStack module;
        private final Ticker ticker;
        private final LazyOptional<IPowerModule> powerModuleHolder;

        public CapProvider(ItemStack module) {
            this.module = module;
            this.ticker = new Ticker(module, ModuleCategory.MOVEMENT, ModuleTarget.FEETONLY, MPSSettings::getModuleConfig){
                {
                    super(module, category, target, config);
                    this.addBaseProperty("jetbootsEnergy", 0.0);
                    this.addBaseProperty("jetbootsThrust", 0.0);
                    this.addTradeoffProperty("thrust", "jetbootsEnergy", 750.0, "FE");
                    this.addTradeoffProperty("thrust", "jetbootsThrust", 0.08f);
                }
            };
            this.powerModuleHolder = LazyOptional.of(() -> {
                this.ticker.updateFromNBT();
                return this.ticker;
            });
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
            LazyOptional powerModuleCapability = PowerModuleCapability.POWER_MODULE.orEmpty(capability, this.powerModuleHolder);
            if (powerModuleCapability.isPresent()) {
                return powerModuleCapability;
            }
            return LazyOptional.empty();
        }

        class Ticker
        extends PlayerTickModule {
            public Ticker(ItemStack module, ModuleCategory category, ModuleTarget target, Callable<IConfig> config) {
                super(module, category, target, config, false);
            }

            public void onPlayerTickActive(PlayerEntity player, ItemStack item) {
                if (player.func_70090_H()) {
                    return;
                }
                boolean hasFlightControl = player.func_184582_a(EquipmentSlotType.HEAD).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).filter(IModularItem.class::isInstance).map(IModularItem.class::cast).map(m -> m.isModuleOnline(MPSRegistryNames.FLIGHT_CONTROL_MODULE)).orElse(false);
                double jetEnergy = this.applyPropertyModifiers("jetbootsEnergy");
                double thrust = this.applyPropertyModifiers("jetbootsThrust");
                PlayerMovementInputWrapper.PlayerMovementInput playerInput = PlayerMovementInputWrapper.get((PlayerEntity)player);
                if (jetEnergy < (double)ElectricItemUtils.getPlayerEnergy((LivingEntity)player)) {
                    if (hasFlightControl && thrust > 0.0) {
                        thrust = MovementManager.thrust(player, thrust, true);
                        if (player.field_70170_p.field_72995_K && NuminaSettings.useSounds()) {
                            Musique.playerSound((PlayerEntity)player, (SoundEvent)MPSSoundDictionary.JETBOOTS, (SoundCategory)SoundCategory.PLAYERS, (float)((float)(thrust * 12.5)), (Float)Float.valueOf(1.0f), (Boolean)true);
                        }
                        ElectricItemUtils.drainPlayerEnergy((LivingEntity)player, (int)((int)(thrust * jetEnergy)));
                    } else if (playerInput.jumpKey && player.func_213322_ci().field_72448_b < 0.5) {
                        thrust = MovementManager.thrust(player, thrust, false);
                        if (player.field_70170_p.field_72995_K && NuminaSettings.useSounds()) {
                            Musique.playerSound((PlayerEntity)player, (SoundEvent)MPSSoundDictionary.JETBOOTS, (SoundCategory)SoundCategory.PLAYERS, (float)((float)(thrust * 12.5)), (Float)Float.valueOf(1.0f), (Boolean)true);
                        }
                        ElectricItemUtils.drainPlayerEnergy((LivingEntity)player, (int)((int)(thrust * jetEnergy)));
                    } else if (player.field_70170_p.field_72995_K && NuminaSettings.useSounds()) {
                        Musique.stopPlayerSound((PlayerEntity)player, (SoundEvent)MPSSoundDictionary.JETBOOTS);
                    }
                } else if (player.field_70170_p.field_72995_K && NuminaSettings.useSounds()) {
                    Musique.stopPlayerSound((PlayerEntity)player, (SoundEvent)MPSSoundDictionary.JETBOOTS);
                }
            }

            public void onPlayerTickInactive(PlayerEntity player, ItemStack item) {
                if (player.field_70170_p.field_72995_K && NuminaSettings.useSounds()) {
                    Musique.stopPlayerSound((PlayerEntity)player, (SoundEvent)MPSSoundDictionary.JETBOOTS);
                }
            }
        }
    }
}

