/*
 * Decompiled with CFR 0.152.
 */
package lehjr.powersuits.common.item.module.movement;

import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lehjr.numina.client.control.PlayerMovementInputWrapper;
import lehjr.numina.client.sound.Musique;
import lehjr.numina.common.capabilities.inventory.modularitem.IModularItem;
import lehjr.numina.common.capabilities.module.powermodule.IConfig;
import lehjr.numina.common.capabilities.module.powermodule.IPowerModule;
import lehjr.numina.common.capabilities.module.powermodule.ModuleCategory;
import lehjr.numina.common.capabilities.module.powermodule.ModuleTarget;
import lehjr.numina.common.capabilities.module.powermodule.PowerModuleCapability;
import lehjr.numina.common.capabilities.module.tickable.PlayerTickModule;
import lehjr.numina.common.config.NuminaSettings;
import lehjr.numina.common.energy.ElectricItemUtils;
import lehjr.powersuits.client.sound.MPSSoundDictionary;
import lehjr.powersuits.common.config.MPSSettings;
import lehjr.powersuits.common.constants.MPSRegistryNames;
import lehjr.powersuits.common.event.MovementManager;
import lehjr.powersuits.common.item.module.AbstractPowerModule;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;

public class JetPackModule
extends AbstractPowerModule {
    @Override
    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new CapProvider(stack);
    }

    public class CapProvider
    implements ICapabilityProvider {
        ItemStack module;
        private final Ticker ticker;
        private final LazyOptional<IPowerModule> powerModuleHolder;

        public CapProvider(ItemStack module) {
            this.module = module;
            this.ticker = new Ticker(module, ModuleCategory.MOVEMENT, ModuleTarget.TORSOONLY, MPSSettings::getModuleConfig){
                {
                    super(module, category, target, config);
                    this.addBaseProperty("jetpackEnergy", 0.0, "RF/t");
                    this.addBaseProperty("jetpackThrust", 0.0, "N");
                    this.addTradeoffProperty("thrust", "jetpackEnergy", 15000.0);
                    this.addTradeoffProperty("thrust", "jetpackThrust", 0.16f);
                }
            };
            this.powerModuleHolder = LazyOptional.of(() -> {
                this.ticker.updateFromNBT();
                return this.ticker;
            });
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
            LazyOptional powerModuleCapability = PowerModuleCapability.POWER_MODULE.orEmpty(capability, this.powerModuleHolder);
            if (powerModuleCapability.isPresent()) {
                return powerModuleCapability;
            }
            return LazyOptional.empty();
        }

        class Ticker
        extends PlayerTickModule {
            public Ticker(ItemStack module, ModuleCategory category, ModuleTarget target, Callable<IConfig> config) {
                super(module, category, target, config, false);
            }

            public void onPlayerTickActive(PlayerEntity player, ItemStack torso) {
                if (player.func_70090_H()) {
                    return;
                }
                PlayerMovementInputWrapper.PlayerMovementInput playerInput = PlayerMovementInputWrapper.get((PlayerEntity)player);
                ItemStack helmet = player.func_184582_a(EquipmentSlotType.HEAD);
                boolean hasFlightControl = helmet.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).filter(IModularItem.class::isInstance).map(IModularItem.class::cast).map(m -> m.isModuleOnline(MPSRegistryNames.FLIGHT_CONTROL_MODULE)).orElse(false);
                double jetEnergy = 0.0;
                double thrust = 0.0;
                jetEnergy += this.applyPropertyModifiers("jetpackEnergy");
                thrust += this.applyPropertyModifiers("jetpackThrust");
                if (jetEnergy < (double)ElectricItemUtils.getPlayerEnergy((LivingEntity)player) && (hasFlightControl && thrust > 0.0 || playerInput.jumpKey)) {
                    thrust = MovementManager.thrust(player, thrust, hasFlightControl);
                    if (!player.field_70170_p.func_201670_d()) {
                        if (player.field_70170_p.func_82737_E() % 5L == 0L) {
                            ElectricItemUtils.drainPlayerEnergy((LivingEntity)player, (int)((int)(thrust * jetEnergy * 5.0)));
                        }
                    } else if (NuminaSettings.useSounds()) {
                        Musique.playerSound((PlayerEntity)player, (SoundEvent)MPSSoundDictionary.JETPACK, (SoundCategory)SoundCategory.PLAYERS, (float)((float)(thrust * 6.25)), (Float)Float.valueOf(1.0f), (Boolean)true);
                    }
                } else {
                    this.onPlayerTickInactive(player, torso);
                }
            }

            public void onPlayerTickInactive(PlayerEntity player, ItemStack item) {
                if (player.field_70170_p.field_72995_K && NuminaSettings.useSounds()) {
                    Musique.stopPlayerSound((PlayerEntity)player, (SoundEvent)MPSSoundDictionary.JETPACK);
                }
            }
        }
    }
}

