/*
 * Decompiled with CFR 0.152.
 */
package lehjr.powersuits.common.item.module.movement;

import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lehjr.numina.common.capabilities.module.powermodule.IConfig;
import lehjr.numina.common.capabilities.module.powermodule.IPowerModule;
import lehjr.numina.common.capabilities.module.powermodule.ModuleCategory;
import lehjr.numina.common.capabilities.module.powermodule.ModuleTarget;
import lehjr.numina.common.capabilities.module.powermodule.PowerModuleCapability;
import lehjr.numina.common.capabilities.module.tickable.PlayerTickModule;
import lehjr.numina.common.energy.ElectricItemUtils;
import lehjr.powersuits.common.config.MPSSettings;
import lehjr.powersuits.common.item.module.AbstractPowerModule;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

public class SprintAssistModule
extends AbstractPowerModule {
    @Override
    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new CapProvider(stack);
    }

    public static void setMovementModifier(ItemStack itemStack, double multiplier, Attribute attributeModifier, String key) {
        CompoundNBT itemNBT = itemStack.func_196082_o();
        boolean hasAttribute = false;
        if (itemNBT.func_150297_b("AttributeModifiers", 9)) {
            ListNBT listnbt = itemNBT.func_150295_c("AttributeModifiers", 10);
            ArrayList<Integer> remove = new ArrayList<Integer>();
            for (int i = 0; i < listnbt.size(); ++i) {
                CompoundNBT attributeTag = listnbt.func_150305_b(i);
                AttributeModifier attributemodifier = AttributeModifier.func_233800_a_((CompoundNBT)attributeTag);
                if (attributemodifier == null || !attributemodifier.func_111166_b().equals(key)) continue;
                if (multiplier != 0.0) {
                    attributeTag.func_74780_a("Amount", multiplier);
                    hasAttribute = true;
                    break;
                }
                remove.add(i);
            }
            if (hasAttribute && !remove.isEmpty()) {
                Collections.reverse(remove);
                remove.forEach(index -> listnbt.remove(index));
            }
        }
        if (!hasAttribute && multiplier != 0.0) {
            itemStack.func_185129_a(attributeModifier, new AttributeModifier(key, multiplier, AttributeModifier.Operation.ADDITION), EquipmentSlotType.LEGS);
        }
    }

    public class CapProvider
    implements ICapabilityProvider {
        ItemStack module;
        private final Ticker ticker;
        private final LazyOptional<IPowerModule> powerModuleHolder;

        public CapProvider(ItemStack module) {
            this.module = module;
            this.ticker = new Ticker(module, ModuleCategory.MOVEMENT, ModuleTarget.LEGSONLY, MPSSettings::getModuleConfig){
                {
                    super(module, category, target, config);
                    this.addSimpleTradeoff("sprintAssist", "sprintEnergyCon", "RF", 0.0, 5000.0, "sprintSpeedMult", "%", 0.1, 2.49);
                    this.addSimpleTradeoff("compensation", "sprintEnergyCon", "RF", 0.0, 2000.0, "sprintExComp", "%", 0.0, 1.0);
                    this.addSimpleTradeoff("walkingAssist", "walkingEnergyCon", "RF", 0.0, 5000.0, "walkingSpeedMult", "%", 0.01, 1.99);
                }
            };
            this.powerModuleHolder = LazyOptional.of(() -> {
                this.ticker.updateFromNBT();
                return this.ticker;
            });
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
            LazyOptional powerModuleCapability = PowerModuleCapability.POWER_MODULE.orEmpty(capability, this.powerModuleHolder);
            if (powerModuleCapability.isPresent()) {
                return powerModuleCapability;
            }
            return LazyOptional.empty();
        }

        class Ticker
        extends PlayerTickModule {
            public Ticker(ItemStack module, ModuleCategory category, ModuleTarget target, Callable<IConfig> config) {
                super(module, category, target, config, true);
            }

            public void onPlayerTickActive(PlayerEntity player, @Nonnull ItemStack itemStack) {
                if (player.field_71075_bZ.field_75100_b || player.func_184218_aH() || player.func_184613_cA()) {
                    this.onPlayerTickInactive(player, itemStack);
                    return;
                }
                double horzMovement = player.field_70140_Q - player.field_70141_P;
                double totalEnergy = ElectricItemUtils.getPlayerEnergy((LivingEntity)player);
                if (horzMovement > 0.0) {
                    if (player.func_70051_ag()) {
                        double exhaustion = (double)Math.round(horzMovement * 100.0) * 0.01;
                        double sprintCost = this.applyPropertyModifiers("sprintEnergyCon");
                        if (sprintCost < totalEnergy) {
                            double sprintMultiplier = this.applyPropertyModifiers("sprintSpeedMult");
                            double exhaustionComp = this.applyPropertyModifiers("sprintExComp");
                            if (!player.field_70170_p.field_72995_K && player.field_70170_p.func_82737_E() % 20L == 0L) {
                                ElectricItemUtils.drainPlayerEnergy((LivingEntity)player, (int)((int)(sprintCost * horzMovement) * 20));
                            }
                            SprintAssistModule.setMovementModifier(this.getModuleStack(), sprintMultiplier * 0.13 * 0.5, Attributes.field_233821_d_, Attributes.field_233821_d_.func_233754_c_());
                            player.func_71024_bL().func_75113_a((float)(-0.01 * exhaustion * exhaustionComp));
                            player.field_70747_aH = player.func_70689_ay() * 0.2f;
                        }
                    } else {
                        double walkCost = this.applyPropertyModifiers("walkingEnergyCon");
                        if (walkCost < totalEnergy) {
                            double walkMultiplier = this.applyPropertyModifiers("walkingSpeedMult");
                            if (!player.field_70170_p.field_72995_K && player.field_70170_p.func_82737_E() % 20L == 0L) {
                                ElectricItemUtils.drainPlayerEnergy((LivingEntity)player, (int)((int)(walkCost * horzMovement)));
                            }
                            SprintAssistModule.setMovementModifier(this.getModuleStack(), walkMultiplier * 0.1, Attributes.field_233821_d_, Attributes.field_233821_d_.func_233754_c_());
                            player.field_70747_aH = player.func_70689_ay() * 0.2f;
                        }
                    }
                }
                this.onPlayerTickInactive(player, itemStack);
            }

            public void onPlayerTickInactive(PlayerEntity player, @Nonnull ItemStack itemStack) {
                SprintAssistModule.setMovementModifier(this.getModuleStack(), 0.0, Attributes.field_233821_d_, Attributes.field_233821_d_.func_233754_c_());
            }
        }
    }
}

