/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.modules.entries;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.config.ConfigManager;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.config.entry.EntryStackProvider;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.impl.client.REIRuntimeImpl;
import me.shedaniel.rei.impl.client.gui.ScreenOverlayImpl;
import me.shedaniel.rei.impl.client.gui.modules.Menu;
import me.shedaniel.rei.impl.client.gui.modules.MenuEntry;
import me.shedaniel.rei.impl.client.gui.modules.entries.EntryStackSubsetsMenuEntry;
import me.shedaniel.rei.impl.client.gui.modules.entries.SubMenuEntry;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
@ApiStatus.Internal
public class SubSubsetsMenuEntry
extends SubMenuEntry {
    private Tuple<Integer, Integer> filteredRatio = null;
    private long lastListHash = -1L;
    private boolean clickedBefore = false;

    public SubSubsetsMenuEntry(ITextComponent text) {
        this(text, Collections.emptyList());
    }

    public SubSubsetsMenuEntry(ITextComponent text, Supplier<List<MenuEntry>> entries) {
        this(text, entries.get());
    }

    public SubSubsetsMenuEntry(ITextComponent text, List<MenuEntry> entries) {
        super(text, entries);
    }

    @Override
    public void func_230430_a_(MatrixStack matrices, int mouseX, int mouseY, float delta) {
        super.func_230430_a_(matrices, mouseX, mouseY, delta);
        if (this.isSelected()) {
            if (this.entries.isEmpty()) {
                this.clickedBefore = false;
            }
            if (this.clickedBefore) {
                if (this.isRendering() && mouseX >= this.getX() && mouseX <= this.getX() + this.getWidth() && mouseY >= this.getY() && mouseY <= this.getY() + 12 && !this.entries.isEmpty()) {
                    REIRuntime.getInstance().queueTooltip(Tooltip.create(new ITextComponent[]{new StringTextComponent("Click again to filter everything in this group.")}));
                } else {
                    this.clickedBefore = false;
                }
            }
        } else {
            this.clickedBefore = false;
        }
    }

    @Override
    protected void renderBackground(MatrixStack poses, int x, int y, int width, int height) {
        double filteredRatio = this.getFilteredRatio();
        if (filteredRatio > 0.0) {
            filteredRatio = filteredRatio * 0.85 + 0.15;
            SubSubsetsMenuEntry.func_238467_a_((MatrixStack)poses, (int)x, (int)y, (int)(x + width), (int)(y + 12), (int)((0xFF0000 | MathHelper.func_76143_f((double)(filteredRatio * 255.0)) << 24) + (this.isSelected() ? 39321 : 0)));
        } else if (this.isSelected()) {
            SubSubsetsMenuEntry.func_238467_a_((MatrixStack)poses, (int)x, (int)y, (int)(x + width), (int)(y + 12), (int)-12237499);
        }
    }

    @Override
    protected boolean onClick(double mouseX, double mouseY, int button) {
        if (this.clickedBefore) {
            this.clickedBefore = false;
            List<EntryStackProvider<?>> filteredStacks = ConfigObject.getInstance().getFilteredStackProviders();
            Menu overlay = ((ScreenOverlayImpl)REIRuntime.getInstance().getOverlay().get()).getOverlayMenu();
            this.setFiltered(filteredStacks, overlay, this, !(this.getFilteredRatio() > 0.0));
            ConfigManager.getInstance().saveConfig();
            EntryRegistry.getInstance().refilter();
            if (REIRuntimeImpl.getSearchField() != null) {
                ScreenOverlayImpl.getEntryListWidget().updateSearch(REIRuntimeImpl.getSearchField().getText(), true);
            }
        } else {
            this.clickedBefore = true;
        }
        this.minecraft.func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
        return true;
    }

    private void setFiltered(List<EntryStackProvider<?>> filteredStacks, Menu subsetsMenu, SubSubsetsMenuEntry subSubsetsMenuEntry, boolean filtered) {
        for (MenuEntry entry : subSubsetsMenuEntry.entries) {
            if (entry instanceof EntryStackSubsetsMenuEntry) {
                EntryStackSubsetsMenuEntry menuEntry = (EntryStackSubsetsMenuEntry)entry;
                if (menuEntry.isFiltered() != filtered) {
                    if (!filtered) {
                        filteredStacks.removeIf(next -> EntryStacks.equalsExact(next.provide(), menuEntry.stack));
                    } else {
                        filteredStacks.add(EntryStackProvider.ofStack(menuEntry.stack.normalize()));
                    }
                }
                if (subsetsMenu == null) continue;
                menuEntry.recalculateFilter(subsetsMenu);
                continue;
            }
            if (!(entry instanceof SubSubsetsMenuEntry)) continue;
            this.setFiltered(filteredStacks, subsetsMenu, (SubSubsetsMenuEntry)entry, filtered);
        }
    }

    public double getFilteredRatio() {
        Tuple<Integer, Integer> pair = this.getFilteredRatioPair();
        return (Integer)pair.func_76340_b() == 0 ? 0.0 : (double)((Integer)pair.func_76341_a()).intValue() / (double)((Integer)pair.func_76340_b()).intValue();
    }

    public Tuple<Integer, Integer> getFilteredRatioPair() {
        List<EntryStackProvider<?>> filteredStacks = ConfigObject.getInstance().getFilteredStackProviders();
        if (this.lastListHash != (long)filteredStacks.hashCode()) {
            int size = 0;
            int filtered = 0;
            for (MenuEntry entry : this.entries) {
                if (entry instanceof EntryStackSubsetsMenuEntry) {
                    ++size;
                    if (!((EntryStackSubsetsMenuEntry)entry).isFiltered()) continue;
                    ++filtered;
                    continue;
                }
                if (!(entry instanceof SubSubsetsMenuEntry)) continue;
                Tuple<Integer, Integer> pair = ((SubSubsetsMenuEntry)entry).getFilteredRatioPair();
                filtered += ((Integer)pair.func_76341_a()).intValue();
                size += ((Integer)pair.func_76340_b()).intValue();
            }
            this.filteredRatio = new Tuple((Object)filtered, (Object)size);
            this.lastListHash = filteredStacks.hashCode();
        }
        return this.filteredRatio;
    }
}

