/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.common.entry.type;

import java.lang.ref.WeakReference;
import me.shedaniel.rei.api.common.entry.type.EntryDefinition;
import me.shedaniel.rei.api.common.entry.type.EntryType;
import me.shedaniel.rei.api.common.entry.type.EntryTypeRegistry;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class EntryTypeDeferred<T>
implements EntryType<T> {
    private final ResourceLocation id;
    private final int hashCode;
    private WeakReference<EntryDefinition<T>> reference;

    public EntryTypeDeferred(ResourceLocation id) {
        this.id = id;
        this.hashCode = id.hashCode();
    }

    @Override
    public ResourceLocation getId() {
        return this.id;
    }

    @Override
    public EntryDefinition<T> getDefinition() {
        EntryDefinition definition;
        if (this.reference != null && (definition = (EntryDefinition)this.reference.get()) != null) {
            return definition;
        }
        EntryDefinition<?> d = EntryTypeRegistry.getInstance().get(this.id);
        if (d == null) {
            throw new NullPointerException("Entry type " + this.id + " doesn't exist!");
        }
        EntryDefinition definition2 = d.cast();
        this.reference = new WeakReference(definition2);
        return definition2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EntryTypeDeferred)) {
            return false;
        }
        EntryTypeDeferred that = (EntryTypeDeferred)o;
        return this.hashCode == that.hashCode && this.id.equals((Object)that.id);
    }

    public int hashCode() {
        return this.hashCode;
    }
}

