/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.jeicompat.ingredient;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import me.shedaniel.architectury.utils.Value;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.jeicompat.JEIPluginDetector;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiIngredient;
import mezz.jei.api.gui.ingredient.IGuiIngredientGroup;
import mezz.jei.api.gui.ingredient.ITooltipCallback;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IFocus;
import net.minecraft.client.gui.AbstractGui;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JEIGuiIngredientGroup<T>
implements IGuiIngredientGroup<T> {
    private static final Method func_238468_a_ = ObfuscationReflectionHelper.findMethod(AbstractGui.class, (String)"func_238468_a_", (Class[])new Class[]{MatrixStack.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE});
    private final IIngredientType<T> type;
    private final Int2ObjectMap<SlotWrapper> slots = new Int2ObjectOpenHashMap();
    public final List<ITooltipCallback<T>> tooltipCallbacks = new ArrayList<ITooltipCallback<T>>();
    public final Value<IDrawable> background;

    public JEIGuiIngredientGroup(IIngredientType<T> type, Value<IDrawable> background) {
        this.type = type;
        this.background = background;
    }

    protected SlotWrapper getSlot(int slotIndex) {
        return (SlotWrapper)this.slots.computeIfAbsent(slotIndex, i -> new SlotWrapper(Widgets.createSlot(new Point(0, 0)).disableBackground()));
    }

    @Override
    public void set(@NotNull IIngredients ingredients) {
        List<List<T>> inputs = ingredients.getInputs(this.type);
        List<List<T>> outputs = ingredients.getOutputs(this.type);
        int inputIndex = 0;
        int outputIndex = 0;
        int[] array = this.slots.keySet().toArray(new int[0]);
        Arrays.parallelSort(array);
        for (int slot : array) {
            SlotWrapper slotWrapper = (SlotWrapper)this.slots.get(slot);
            if (slotWrapper.slot.getNoticeMark() == 1) {
                if (inputIndex >= inputs.size()) continue;
                slotWrapper.slot.clearEntries();
                slotWrapper.slot.entries(JEIPluginDetector.unwrapList(this.type, inputs.get(inputIndex++)));
                continue;
            }
            if (slotWrapper.slot.getNoticeMark() != 2 || outputIndex >= outputs.size()) continue;
            slotWrapper.slot.clearEntries();
            slotWrapper.slot.entries(JEIPluginDetector.unwrapList(this.type, outputs.get(outputIndex++)));
        }
    }

    @Override
    public void set(int slotIndex, @Nullable List<T> ingredients) {
        Slot slot = this.getSlot((int)slotIndex).slot;
        slot.clearEntries();
        slot.entries(JEIPluginDetector.unwrapList(this.type, ingredients));
    }

    @Override
    public void set(int slotIndex, @Nullable T ingredient) {
        Slot slot = this.getSlot((int)slotIndex).slot;
        slot.clearEntries();
        slot.entry(JEIPluginDetector.unwrapStack(ingredient, this.type));
    }

    @Override
    public void setBackground(int slotIndex, @NotNull IDrawable background) {
        SlotWrapper slot = this.getSlot(slotIndex);
        slot.background = background;
    }

    @Override
    public void addTooltipCallback(@NotNull ITooltipCallback<T> tooltipCallback) {
        this.tooltipCallbacks.add(Objects.requireNonNull(tooltipCallback, "tooltipCallback"));
    }

    @NotNull
    public Int2ObjectMap<SlotWrapper> getGuiIngredients() {
        return this.slots;
    }

    @Override
    public void init(int slotIndex, boolean input, int xPosition, int yPosition) {
        SlotWrapper slot = this.getSlot(slotIndex);
        slot.slot.setNoticeMark(input ? (byte)1 : 2);
        slot.slot.getBounds().setLocation(xPosition - 1, yPosition - 1);
    }

    @Override
    public void init(int slotIndex, boolean input, @NotNull IIngredientRenderer<T> ingredientRenderer, int xPosition, int yPosition, int width, int height, int xPadding, int yPadding) {
        SlotWrapper slot = this.getSlot(slotIndex);
        slot.slot.setNoticeMark(input ? (byte)1 : 2);
        slot.slot.getBounds().setLocation(xPosition - 1, yPosition - 1);
        slot.slot.getBounds().setSize(width + 2, height + 2);
        slot.renderer = ingredientRenderer;
    }

    @Override
    public void setOverrideDisplayFocus(@Nullable IFocus<T> focus) {
        throw JEIPluginDetector.WILL_NOT_BE_IMPLEMENTED();
    }

    public class SlotWrapper
    extends AbstractList<T>
    implements IGuiIngredient<T> {
        public final Slot slot;
        public float fluidCapacity = Float.NaN;
        @Nullable
        public IIngredientRenderer<T> renderer;
        @Nullable
        public IDrawable background;
        @Nullable
        public IDrawable overlay;

        public SlotWrapper(Slot slot) {
            this.slot = slot;
        }

        @Override
        @Nullable
        public T getDisplayedIngredient() {
            return JEIPluginDetector.jeiValueOrNull(this.slot.getCurrentEntry().cast());
        }

        @Override
        @NotNull
        public List<T> getAllIngredients() {
            return this;
        }

        @Override
        public boolean isInput() {
            return this.slot.getNoticeMark() == 1;
        }

        @Override
        public void drawHighlight(@NotNull MatrixStack matrixStack, int color, int xOffset, int yOffset) {
            RenderSystem.disableDepthTest();
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            this.slot.setZ(300);
            Rectangle bounds = this.slot.getInnerBounds().clone();
            bounds.translate(xOffset, yOffset);
            try {
                func_238468_a_.invoke((Object)this.slot, matrixStack, bounds.x, bounds.y, bounds.getMaxX(), bounds.getMaxY(), color, color);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
            }
            this.slot.setZ(0);
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            RenderSystem.enableDepthTest();
        }

        @Override
        public T get(int index) {
            return JEIPluginDetector.jeiValueOrNull(this.slot.getEntries().get(index).cast());
        }

        @Override
        public int size() {
            return this.slot.getEntries().size();
        }

        @Override
        public void clear() {
            this.slot.clearEntries();
        }

        @Override
        public void add(int index, T element) {
            this.slot.entry(JEIPluginDetector.unwrapStack(element, JEIGuiIngredientGroup.this.type));
        }
    }
}

