/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.client.categories;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.DisplayRenderer;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.plugin.common.BuiltinPlugin;
import me.shedaniel.rei.plugin.common.displays.DefaultCompostingDisplay;
import net.minecraft.block.Blocks;
import net.minecraft.block.ComposterBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DefaultCompostingCategory
implements DisplayCategory<DefaultCompostingDisplay> {
    @Override
    public CategoryIdentifier<? extends DefaultCompostingDisplay> getCategoryIdentifier() {
        return BuiltinPlugin.COMPOSTING;
    }

    @Override
    public Renderer getIcon() {
        return EntryStacks.of((IItemProvider)Blocks.field_222436_lZ);
    }

    @Override
    public ITextComponent getTitle() {
        return new TranslationTextComponent("category.rei.composting");
    }

    @Override
    public DisplayRenderer getDisplayRenderer(final DefaultCompostingDisplay display) {
        return new DisplayRenderer(){
            private ITextComponent text;
            {
                this.text = new TranslationTextComponent("text.rei.composting.page", new Object[]{display.getPage() + 1});
            }

            @Override
            public int getHeight() {
                Objects.requireNonNull(Minecraft.func_71410_x().field_71466_p);
                return 10 + 9;
            }

            @Override
            public void render(MatrixStack matrices, Rectangle rectangle, int mouseX, int mouseY, float delta) {
                Minecraft.func_71410_x().field_71466_p.func_238422_b_(matrices, this.text.func_241878_f(), (float)(rectangle.x + 5), (float)(rectangle.y + 6), -1);
            }
        };
    }

    @Override
    public List<Widget> setupDisplay(DefaultCompostingDisplay display, Rectangle bounds) {
        ArrayList widgets = Lists.newArrayList();
        Point startingPoint = new Point(bounds.x + bounds.width - 55, bounds.y + 110);
        ArrayList<EntryIngredient> stacks = new ArrayList<EntryIngredient>(display.getInputEntries());
        int i = 0;
        for (int y = 0; y < 6; ++y) {
            for (int x = 0; x < 8; ++x) {
                EntryIngredient entryStack;
                EntryIngredient entryIngredient = entryStack = stacks.size() > i ? (EntryIngredient)stacks.get(i) : EntryIngredient.empty();
                if (!entryStack.isEmpty()) {
                    ComposterBlock.field_220299_b.object2FloatEntrySet().stream().filter(entry -> entry.getKey() != null && Objects.equals(((IItemProvider)entry.getKey()).func_199767_j(), ((EntryStack)entryStack.get(0)).getValue())).findAny().map(Map.Entry::getValue).ifPresent(chance -> {
                        for (EntryStack stack : entryStack) {
                            stack.tooltip(new ITextComponent[]{new TranslationTextComponent("text.rei.composting.chance", new Object[]{MathHelper.func_76140_b((double)(chance.floatValue() * 100.0f))}).func_240699_a_(TextFormatting.YELLOW)});
                        }
                    });
                }
                widgets.add(Widgets.createSlot(new Point(bounds.getCenterX() - 72 + x * 18, bounds.y + 3 + y * 18)).entries(entryStack).markInput());
                ++i;
            }
        }
        widgets.add(Widgets.createArrow(new Point(startingPoint.x - 1, startingPoint.y + 7)));
        widgets.add(Widgets.createResultSlotBackground(new Point(startingPoint.x + 33, startingPoint.y + 8)));
        widgets.add(Widgets.createSlot(new Point(startingPoint.x + 33, startingPoint.y + 8)).entries(display.getOutputEntries().get(0)).disableBackground().markOutput());
        return widgets;
    }

    @Override
    public int getDisplayHeight() {
        return 140;
    }

    @Override
    public int getFixedDisplaysPerPage() {
        return 1;
    }
}

