/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.client.entry;

import com.google.common.base.Suppliers;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.shedaniel.architectury.fluid.FluidStack;
import me.shedaniel.architectury.hooks.FluidStackHooks;
import me.shedaniel.architectury.platform.Platform;
import me.shedaniel.architectury.utils.Env;
import me.shedaniel.architectury.utils.EnvExecutor;
import me.shedaniel.architectury.utils.Fraction;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.entry.renderer.AbstractEntryRenderer;
import me.shedaniel.rei.api.client.entry.renderer.BatchedEntryRenderer;
import me.shedaniel.rei.api.client.entry.renderer.EntryRenderer;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.util.SpriteRenderer;
import me.shedaniel.rei.api.common.entry.EntrySerializer;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.comparison.ComparisonContext;
import me.shedaniel.rei.api.common.entry.comparison.FluidComparatorRegistry;
import me.shedaniel.rei.api.common.entry.type.EntryDefinition;
import me.shedaniel.rei.api.common.entry.type.EntryType;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.I18n;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.ITagCollection;
import net.minecraft.tags.ITagCollectionSupplier;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class FluidEntryDefinition
implements EntryDefinition<FluidStack>,
EntrySerializer<FluidStack> {
    private static final String FLUID_AMOUNT = Platform.isForge() ? "tooltip.rei.fluid_amount.forge" : "tooltip.rei.fluid_amount";
    @OnlyIn(value=Dist.CLIENT)
    private EntryRenderer<FluidStack> renderer;

    public FluidEntryDefinition() {
        EnvExecutor.runInEnv((Env)Env.CLIENT, () -> () -> Client.init(this));
    }

    @Override
    public Class<FluidStack> getValueType() {
        return FluidStack.class;
    }

    @Override
    public EntryType<FluidStack> getType() {
        return VanillaEntryTypes.FLUID;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public EntryRenderer<FluidStack> getRenderer() {
        return this.renderer;
    }

    @Override
    @Nullable
    public ResourceLocation getIdentifier(EntryStack<FluidStack> entry, FluidStack value) {
        return Registry.field_212619_h.func_177774_c((Object)value.getFluid());
    }

    @Override
    public boolean isEmpty(EntryStack<FluidStack> entry, FluidStack value) {
        return value.isEmpty();
    }

    @Override
    public FluidStack copy(EntryStack<FluidStack> entry, FluidStack value) {
        return value.copy();
    }

    @Override
    public FluidStack normalize(EntryStack<FluidStack> entry, FluidStack value) {
        Fluid fluid = value.getFluid();
        if (fluid instanceof FlowingFluid) {
            fluid = ((FlowingFluid)fluid).func_210198_f();
        }
        return FluidStack.create((Fluid)fluid, (Fraction)FluidStack.bucketAmount(), (CompoundNBT)value.getTag());
    }

    @Override
    public FluidStack wildcard(EntryStack<FluidStack> entry, FluidStack value) {
        Fluid fluid = value.getFluid();
        if (fluid instanceof FlowingFluid) {
            fluid = ((FlowingFluid)fluid).func_210198_f();
        }
        return FluidStack.create((Fluid)fluid, (Fraction)FluidStack.bucketAmount());
    }

    @Override
    @Nullable
    public ItemStack cheatsAs(EntryStack<FluidStack> entry, FluidStack value) {
        if (value.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        Item bucket = value.getFluid().func_204524_b();
        if (bucket == null) {
            return ItemStack.field_190927_a;
        }
        return new ItemStack((IItemProvider)bucket);
    }

    @Override
    public long hash(EntryStack<FluidStack> entry, FluidStack value, ComparisonContext context) {
        int code = 1;
        code = 31 * code + value.getFluid().hashCode();
        code = 31 * code + Long.hashCode(FluidComparatorRegistry.getInstance().hashOf(context, value));
        return code;
    }

    @Override
    public boolean equals(FluidStack o1, FluidStack o2, ComparisonContext context) {
        if (o1.getFluid() != o2.getFluid()) {
            return false;
        }
        return FluidComparatorRegistry.getInstance().hashOf(context, o1) == FluidComparatorRegistry.getInstance().hashOf(context, o2);
    }

    @Override
    @Nullable
    public EntrySerializer<FluidStack> getSerializer() {
        return this;
    }

    @Override
    public boolean supportSaving() {
        return true;
    }

    @Override
    public boolean supportReading() {
        return true;
    }

    @Override
    public CompoundNBT save(EntryStack<FluidStack> entry, FluidStack value) {
        return value.write(new CompoundNBT());
    }

    @Override
    public FluidStack read(CompoundNBT tag) {
        return FluidStack.read((CompoundNBT)tag);
    }

    @Override
    public ITextComponent asFormattedText(EntryStack<FluidStack> entry, FluidStack value) {
        return value.getName();
    }

    @Override
    public Collection<ResourceLocation> getTagsFor(ITagCollectionSupplier tagContainer, EntryStack<FluidStack> entry, FluidStack value) {
        ITagCollection collection = tagContainer.func_241837_c();
        return collection == null ? Collections.emptyList() : collection.func_199913_a((Object)value.getFluid());
    }

    @Override
    public void fillCrashReport(CrashReport report, CrashReportCategory category, EntryStack<FluidStack> entry) {
        EntryDefinition.super.fillCrashReport(report, category, entry);
        FluidStack stack = entry.getValue();
        category.func_189529_a("Fluid Type", () -> String.valueOf(Registry.field_212619_h.func_177774_c((Object)stack.getFluid())));
        category.func_189529_a("Fluid Amount", () -> String.valueOf(stack.getAmount()));
        category.func_189529_a("Fluid NBT", () -> String.valueOf(stack.getTag()));
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class Client {
        private Client() {
        }

        private static void init(FluidEntryDefinition definition) {
            definition.renderer = new FluidEntryRenderer();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class FluidEntryRenderer
    extends AbstractEntryRenderer<FluidStack>
    implements BatchedEntryRenderer<FluidStack, TextureAtlasSprite> {
        private static final Supplier<TextureAtlasSprite> MISSING_SPRITE = Suppliers.memoize(() -> {
            AtlasTexture atlas = Minecraft.func_71410_x().func_209506_al().func_229356_a_(AtlasTexture.field_110575_b);
            return atlas.func_195424_a(MissingTextureSprite.func_195675_b());
        });

        @Override
        public TextureAtlasSprite getExtraData(EntryStack<FluidStack> entry) {
            FluidStack stack = entry.getValue();
            if (stack.isEmpty()) {
                return null;
            }
            return FluidStackHooks.getStillTexture((FluidStack)stack);
        }

        private TextureAtlasSprite missingTexture() {
            return MISSING_SPRITE.get();
        }

        @Override
        public int getBatchIdentifier(EntryStack<FluidStack> entry, Rectangle bounds, TextureAtlasSprite extraData) {
            return 0;
        }

        @Override
        public void startBatch(EntryStack<FluidStack> entry, TextureAtlasSprite extraData, MatrixStack matrices, float delta) {
        }

        @Override
        public void renderBase(EntryStack<FluidStack> entry, TextureAtlasSprite sprite, MatrixStack matrices, IRenderTypeBuffer.Impl immediate, Rectangle bounds, int mouseX, int mouseY, float delta) {
            TextureAtlasSprite s = sprite == null ? this.missingTexture() : sprite;
            SpriteRenderer.beginPass().setup((IRenderTypeBuffer)immediate, RenderType.func_228639_c_()).sprite(s).color(sprite == null ? 0xFFFFFF : FluidStackHooks.getColor((FluidStack)entry.getValue())).light(0xF000F0).overlay(OverlayTexture.field_229196_a_).alpha(255).normal(matrices.func_227866_c_().func_227872_b_(), 0.0f, 0.0f, 0.0f).position(matrices.func_227866_c_().func_227870_a_(), bounds.x, (float)bounds.getMaxY() - (float)bounds.height * MathHelper.func_76131_a((float)entry.get(EntryStack.Settings.FLUID_RENDER_RATIO).floatValue(), (float)0.0f, (float)1.0f), bounds.getMaxX(), bounds.getMaxY(), entry.getZ()).next(s.func_229241_m_().func_229223_g_());
        }

        @Override
        public void afterBase(EntryStack<FluidStack> entry, TextureAtlasSprite extraData, MatrixStack matrices, float delta) {
        }

        @Override
        public void renderOverlay(EntryStack<FluidStack> entry, TextureAtlasSprite extraData, MatrixStack matrices, IRenderTypeBuffer.Impl immediate, Rectangle bounds, int mouseX, int mouseY, float delta) {
        }

        @Override
        public void endBatch(EntryStack<FluidStack> entry, TextureAtlasSprite extraData, MatrixStack matrices, float delta) {
        }

        @Override
        public void render(EntryStack<FluidStack> entry, MatrixStack matrices, Rectangle bounds, int mouseX, int mouseY, float delta) {
            FluidStack stack = entry.getValue();
            if (stack.isEmpty()) {
                return;
            }
            TextureAtlasSprite sprite = FluidStackHooks.getStillTexture((FluidStack)stack);
            if (sprite == null) {
                return;
            }
            int color = FluidStackHooks.getColor((FluidStack)stack);
            IRenderTypeBuffer.Impl immediate = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
            SpriteRenderer.beginPass().setup((IRenderTypeBuffer)immediate, RenderType.func_228639_c_()).sprite(sprite).color(color).light(0xF000F0).overlay(OverlayTexture.field_229196_a_).alpha(255).normal(matrices.func_227866_c_().func_227872_b_(), 0.0f, 0.0f, 0.0f).position(matrices.func_227866_c_().func_227870_a_(), bounds.x, (float)bounds.getMaxY() - (float)bounds.height * MathHelper.func_76131_a((float)entry.get(EntryStack.Settings.FLUID_RENDER_RATIO).floatValue(), (float)0.0f, (float)1.0f), bounds.getMaxX(), bounds.getMaxY(), entry.getZ()).next(PlayerContainer.field_226615_c_);
            immediate.func_228461_a_();
        }

        @Override
        @Nullable
        public Tooltip getTooltip(EntryStack<FluidStack> entry, Point mouse) {
            String amountTooltip;
            if (entry.isEmpty()) {
                return null;
            }
            ArrayList toolTip = Lists.newArrayList((Object[])new ITextComponent[]{entry.asFormattedText()});
            Fraction amount = entry.getValue().getAmount();
            if (!amount.isLessThan(Fraction.zero()) && (amountTooltip = I18n.func_135052_a((String)FLUID_AMOUNT, (Object[])new Object[]{entry.getValue().getAmount()})) != null) {
                toolTip.addAll(Stream.of(amountTooltip.split("\n")).map(StringTextComponent::new).collect(Collectors.toList()));
            }
            if (Minecraft.func_71410_x().field_71474_y.field_82882_x) {
                ResourceLocation fluidId = Registry.field_212619_h.func_177774_c((Object)entry.getValue().getFluid());
                toolTip.add(new StringTextComponent(fluidId.toString()).func_240699_a_(TextFormatting.DARK_GRAY));
            }
            return Tooltip.create(toolTip);
        }
    }
}

