/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.client.renderer.model;

import cofh.core.client.renderer.model.ModelUtils;
import cofh.lib.client.renderer.model.RetexturedBakedQuad;
import cofh.lib.util.ComparableItemStack;
import cofh.thermal.core.client.ThermalTextures;
import cofh.thermal.core.client.renderer.model.UnderlayBakedModel;
import cofh.thermal.lib.common.ThermalConfig;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;

public class ReconfigurableBakedModel
extends UnderlayBakedModel
implements IDynamicBakedModel {
    private static final Int2ObjectMap<BakedQuad[]> SIDE_QUAD_CACHE = new Int2ObjectOpenHashMap();
    private static final Int2ObjectMap<BakedQuad[]> ITEM_QUAD_CACHE = new Int2ObjectOpenHashMap();
    private static final Map<List<Integer>, IBakedModel> MODEL_CACHE = new Object2ObjectOpenHashMap();
    private final ItemOverrideList overrideList = new ItemOverrideList(){

        @Nullable
        public IBakedModel func_239290_a_(IBakedModel model, ItemStack stack, @Nullable ClientWorld worldIn, @Nullable LivingEntity entityIn) {
            CompoundNBT tag = stack.func_179543_a("BlockEntityTag");
            byte[] sideConfigRaw = ReconfigurableBakedModel.this.getSideConfigRaw(tag);
            int itemHash = new ComparableItemStack(stack).hashCode();
            int configHash = Arrays.hashCode(sideConfigRaw);
            IBakedModel ret = (IBakedModel)MODEL_CACHE.get(Arrays.asList(itemHash, configHash));
            if (ret == null) {
                ModelUtils.WrappedBakedModelBuilder builder = new ModelUtils.WrappedBakedModelBuilder(model);
                BakedQuad[] cachedQuads = (BakedQuad[])ITEM_QUAD_CACHE.get(configHash);
                if (cachedQuads == null || cachedQuads.length < 6) {
                    cachedQuads = new BakedQuad[]{new RetexturedBakedQuad((BakedQuad)builder.getQuads(Direction.DOWN).get(0), ReconfigurableBakedModel.this.getConfigTexture(sideConfigRaw[0])), new RetexturedBakedQuad((BakedQuad)builder.getQuads(Direction.UP).get(0), ReconfigurableBakedModel.this.getConfigTexture(sideConfigRaw[1])), new RetexturedBakedQuad((BakedQuad)builder.getQuads(Direction.NORTH).get(0), ReconfigurableBakedModel.this.getConfigTexture(sideConfigRaw[2])), new RetexturedBakedQuad((BakedQuad)builder.getQuads(Direction.SOUTH).get(0), ReconfigurableBakedModel.this.getConfigTexture(sideConfigRaw[3])), new RetexturedBakedQuad((BakedQuad)builder.getQuads(Direction.WEST).get(0), ReconfigurableBakedModel.this.getConfigTexture(sideConfigRaw[4])), new RetexturedBakedQuad((BakedQuad)builder.getQuads(Direction.EAST).get(0), ReconfigurableBakedModel.this.getConfigTexture(sideConfigRaw[5]))};
                    ITEM_QUAD_CACHE.put(configHash, (Object)cachedQuads);
                }
                builder.addFaceQuad(Direction.DOWN, cachedQuads[0]);
                builder.addFaceQuad(Direction.UP, cachedQuads[1]);
                builder.addFaceQuad(Direction.NORTH, cachedQuads[2]);
                builder.addFaceQuad(Direction.SOUTH, cachedQuads[3]);
                builder.addFaceQuad(Direction.WEST, cachedQuads[4]);
                builder.addFaceQuad(Direction.EAST, cachedQuads[5]);
                ret = builder.build();
                MODEL_CACHE.put(Arrays.asList(itemHash, configHash), ret);
            }
            return ret;
        }
    };

    public static void clearCache() {
        SIDE_QUAD_CACHE.clear();
        ITEM_QUAD_CACHE.clear();
        MODEL_CACHE.clear();
    }

    public ReconfigurableBakedModel(IBakedModel originalModel) {
        super(originalModel);
    }

    @Override
    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        LinkedList<BakedQuad> quads = new LinkedList<BakedQuad>(this.originalModel.getQuads(state, side, rand, extraData));
        if (side == null || quads.isEmpty()) {
            return quads;
        }
        BakedQuad baseQuad = quads.get(0);
        int sideIndex = side.func_176745_a();
        byte[] sideConfigRaw = (byte[])extraData.getData(ModelUtils.SIDES);
        if (sideConfigRaw == null) {
            return quads;
        }
        int configHash = Arrays.hashCode(sideConfigRaw);
        BakedQuad[] cachedSideQuads = (BakedQuad[])SIDE_QUAD_CACHE.get(configHash);
        if (cachedSideQuads == null || cachedSideQuads.length < 6) {
            cachedSideQuads = new BakedQuad[6];
        }
        if (cachedSideQuads[sideIndex] == null) {
            cachedSideQuads[sideIndex] = new RetexturedBakedQuad(baseQuad, this.getConfigTexture(sideConfigRaw[sideIndex]));
            SIDE_QUAD_CACHE.put(configHash, (Object)cachedSideQuads);
        }
        quads.add(cachedSideQuads[sideIndex]);
        return super.addUnderlayQuads(quads, state, side, rand, extraData);
    }

    public ItemOverrideList func_188617_f() {
        return this.overrideList;
    }

    private TextureAtlasSprite getConfigTexture(byte side) {
        switch (side) {
            case 1: {
                return ThermalTextures.MACHINE_CONFIG_INPUT;
            }
            case 2: {
                return ThermalTextures.MACHINE_CONFIG_OUTPUT;
            }
            case 3: {
                return ThermalTextures.MACHINE_CONFIG_BOTH;
            }
            case 4: {
                return ThermalTextures.MACHINE_CONFIG_ACCESSIBLE;
            }
        }
        return ThermalTextures.MACHINE_CONFIG_NONE;
    }

    private byte[] getSideConfigRaw(CompoundNBT tag) {
        if (tag == null) {
            return ThermalConfig.DEFAULT_MACHINE_SIDES_RAW;
        }
        byte[] ret = tag.func_74770_j("Sides");
        return ret.length == 0 ? ThermalConfig.DEFAULT_MACHINE_SIDES_RAW : ret;
    }
}

