/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.tileentity.device;

import cofh.core.client.renderer.model.ModelUtils;
import cofh.core.util.helpers.FluidHelper;
import cofh.lib.client.audio.ConditionalSound;
import cofh.lib.fluid.FluidStorageCoFH;
import cofh.lib.inventory.ItemStorageCoFH;
import cofh.lib.util.StorageGroup;
import cofh.lib.util.helpers.AugmentDataHelper;
import cofh.thermal.core.init.TCoreReferences;
import cofh.thermal.core.init.TCoreSounds;
import cofh.thermal.core.inventory.container.device.DeviceWaterGenContainer;
import cofh.thermal.lib.common.ThermalAugmentRules;
import cofh.thermal.lib.common.ThermalConfig;
import cofh.thermal.lib.tileentity.DeviceTileBase;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class DeviceWaterGenTile
extends DeviceTileBase
implements ITickableTileEntity {
    public static final BiPredicate<ItemStack, List<ItemStack>> AUG_VALIDATOR = ThermalAugmentRules.createAllowValidator("Upgrade", "Fluid", "Filter");
    protected static final int GENERATION_RATE = 250;
    protected static final Supplier<FluidStack> WATER = () -> new FluidStack((Fluid)Fluids.field_204546_a, 0);
    protected ItemStorageCoFH fillSlot = new ItemStorageCoFH(1, FluidHelper::hasFluidHandlerCap);
    protected FluidStorageCoFH tank = new FluidStorageCoFH(4000, e -> false).setEmptyFluid(WATER).setEnabled(() -> this.isActive);
    protected boolean cached;
    protected boolean valid;

    public DeviceWaterGenTile() {
        super(TCoreReferences.DEVICE_WATER_GEN_TILE);
        this.inventory.addSlot(this.fillSlot, StorageGroup.INTERNAL);
        this.tankInv.addTank(this.tank, StorageGroup.OUTPUT);
        this.addAugmentSlots(ThermalConfig.deviceAugments);
        this.initHandlers();
        this.renderFluid = new FluidStack((Fluid)Fluids.field_204546_a, 1000);
    }

    @Override
    protected void updateValidity() {
        BlockPos[] cardinals;
        if (this.field_145850_b == null || !this.field_145850_b.isAreaLoaded(this.field_174879_c, 1)) {
            return;
        }
        int adjWaterSource = 0;
        this.valid = false;
        for (BlockPos adj : cardinals = new BlockPos[]{this.field_174879_c.func_177978_c(), this.field_174879_c.func_177968_d(), this.field_174879_c.func_177976_e(), this.field_174879_c.func_177974_f()}) {
            FluidState state = this.field_145850_b.func_204610_c(adj);
            if (!state.func_206886_c().equals(Fluids.field_204546_a)) continue;
            ++adjWaterSource;
        }
        if (adjWaterSource > 1) {
            this.valid = true;
        } else {
            this.tank.clear();
        }
        this.cached = true;
    }

    @Override
    protected void updateActiveState() {
        if (!this.cached) {
            this.updateValidity();
        }
        super.updateActiveState();
    }

    @Override
    protected boolean isValid() {
        return this.valid;
    }

    protected void fillFluid() {
        if (!this.fillSlot.isEmpty()) {
            this.fillSlot.getItemStack().getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null).ifPresent(c -> {
                this.tank.drain(c.fill(new FluidStack(this.tank.getFluidStack(), (int)(1000.0f * this.baseMod)), IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
                this.fillSlot.setItemStack(c.getContainer());
            });
        }
    }

    public void func_73660_a() {
        this.updateActiveState();
        if (this.isActive) {
            this.tank.modify((int)(250.0f * this.baseMod));
            this.fillFluid();
        }
    }

    @Nonnull
    public IModelData getModelData() {
        return new ModelDataMap.Builder().withInitial(ModelUtils.FLUID, (Object)this.renderFluid).build();
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory inventory, PlayerEntity player) {
        return new DeviceWaterGenContainer(i, this.field_145850_b, this.field_174879_c, inventory, player);
    }

    protected Object getSound() {
        return new ConditionalSound(TCoreSounds.SOUND_DEVICE_WATER_GEN, SoundCategory.AMBIENT, (TileEntity)this, () -> !this.field_145846_f && this.isActive);
    }

    @Override
    protected Predicate<ItemStack> augValidator() {
        return item -> AugmentDataHelper.hasAugmentData((ItemStack)item) && AUG_VALIDATOR.test((ItemStack)item, this.getAugmentsAsList());
    }
}

