/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.lib.tileentity;

import cofh.core.network.packet.client.TileControlPacket;
import cofh.core.network.packet.client.TileRedstonePacket;
import cofh.core.network.packet.client.TileStatePacket;
import cofh.core.tileentity.TileCoFH;
import cofh.core.util.control.IReconfigurableTile;
import cofh.core.util.control.IRedstoneControllableTile;
import cofh.core.util.control.ISecurableTile;
import cofh.core.util.control.ITransferControllableTile;
import cofh.core.util.control.RedstoneControlModule;
import cofh.core.util.control.SecurityControlModule;
import cofh.core.util.filter.EmptyFilter;
import cofh.core.util.filter.FilterRegistry;
import cofh.lib.energy.EmptyEnergyStorage;
import cofh.lib.energy.EnergyStorageCoFH;
import cofh.lib.fluid.FluidStorageCoFH;
import cofh.lib.fluid.ManagedTankInv;
import cofh.lib.fluid.SimpleTankInv;
import cofh.lib.inventory.ItemStorageCoFH;
import cofh.lib.inventory.ManagedItemInv;
import cofh.lib.inventory.SimpleItemInv;
import cofh.lib.item.IAugmentableItem;
import cofh.lib.tileentity.ITileCallback;
import cofh.lib.tileentity.ITilePacketHandler;
import cofh.lib.util.IInventoryCallback;
import cofh.lib.util.StorageGroup;
import cofh.lib.util.Utils;
import cofh.lib.util.constants.Constants;
import cofh.lib.util.filter.IFilter;
import cofh.lib.util.filter.IFilterableTile;
import cofh.lib.util.helpers.AugmentDataHelper;
import cofh.lib.util.helpers.AugmentableHelper;
import cofh.lib.util.helpers.FilterHelper;
import cofh.lib.util.helpers.ItemHelper;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.util.helpers.SoundHelper;
import cofh.lib.util.references.CoreReferences;
import cofh.lib.xp.EmptyXpStorage;
import cofh.lib.xp.XpStorage;
import cofh.thermal.core.init.TCoreSounds;
import cofh.thermal.lib.common.ThermalConfig;
import cofh.thermal.lib.util.ThermalEnergyHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public abstract class ThermalTileAugmentable
extends TileCoFH
implements ISecurableTile,
IRedstoneControllableTile,
INamedContainerProvider,
IFilterableTile {
    protected static final int BASE_ENERGY = 50000;
    protected static final int BASE_PROCESS_TICK = 20;
    protected static final int BASE_XP_STORAGE = 2500;
    protected ManagedItemInv inventory = new ManagedItemInv((IInventoryCallback)this, "ItemInv");
    protected ManagedTankInv tankInv = new ManagedTankInv((ITileCallback)this, "TankInv");
    protected EnergyStorageCoFH energyStorage = EmptyEnergyStorage.INSTANCE;
    protected XpStorage xpStorage = EmptyXpStorage.INSTANCE;
    protected IFilter filter = EmptyFilter.INSTANCE;
    protected SecurityControlModule securityControl = new SecurityControlModule((ISecurableTile)this);
    protected RedstoneControlModule redstoneControl = new RedstoneControlModule((IRedstoneControllableTile)this);
    protected List<ItemStorageCoFH> augments = Collections.emptyList();
    protected ListNBT enchantments = new ListNBT();
    public boolean isActive;
    protected FluidStack renderFluid = FluidStack.EMPTY;
    protected boolean redstoneControlFeature = (Boolean)ThermalConfig.flagRSControl.get();
    protected boolean xpStorageFeature = (Boolean)ThermalConfig.flagXPStorage.get();
    protected boolean creativeEnergy = false;
    protected boolean creativeTanks = false;
    protected CompoundNBT augmentNBT;
    protected LazyOptional<?> energyCap = LazyOptional.empty();
    protected LazyOptional<?> itemCap = LazyOptional.empty();
    protected LazyOptional<?> fluidCap = LazyOptional.empty();

    public ThermalTileAugmentable(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
        this.redstoneControl.setEnabled(() -> this.redstoneControlFeature);
    }

    protected int getBaseEnergyStorage() {
        return 50000;
    }

    protected int getBaseEnergyXfer() {
        return this.getBaseProcessTick() * 10;
    }

    protected int getBaseProcessTick() {
        return 20;
    }

    protected int getBaseXpStorage() {
        return 2500;
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.energyCap.invalidate();
        this.itemCap.invalidate();
        this.fluidCap.invalidate();
    }

    public int invSize() {
        return this.inventory.getSlots();
    }

    public int augSize() {
        return this.augments.size();
    }

    public SimpleItemInv getItemInv() {
        return this.inventory;
    }

    public SimpleTankInv getTankInv() {
        return this.tankInv;
    }

    protected void initHandlers() {
        this.inventory.initHandlers();
        this.tankInv.initHandlers();
    }

    protected void updateActiveState(boolean prevActive) {
        if (prevActive != this.isActive) {
            if (this.func_195044_w().func_235901_b_((Property)Constants.ACTIVE)) {
                this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a((Property)Constants.ACTIVE, (Comparable)Boolean.valueOf(this.isActive)));
            }
            TileStatePacket.sendToClient((ITilePacketHandler)this);
        }
    }

    protected boolean cacheRenderFluid() {
        return false;
    }

    public void neighborChanged(Block blockIn, BlockPos fromPos) {
        if (this.field_145850_b != null && this.redstoneControl.isControllable()) {
            this.redstoneControl.setPower(this.field_145850_b.func_175687_A(this.field_174879_c));
            TileRedstonePacket.sendToClient((ITilePacketHandler)this);
        }
    }

    public void onPlacedBy(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.onPlacedBy(worldIn, pos, state, placer, stack);
        this.enchantments = stack.func_77986_q();
        this.updateAugmentState();
        if (this.redstoneControl.isControllable()) {
            this.redstoneControl.setPower(worldIn.func_175687_A(this.field_174879_c));
        }
        this.onControlUpdate();
    }

    public void onReplaced(BlockState state, World worldIn, BlockPos pos, BlockState newState) {
        int i;
        if (!this.keepItems()) {
            for (i = 0; i < this.invSize() - this.augSize(); ++i) {
                InventoryHelper.func_180173_a((World)worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)this.inventory.getStackInSlot(i));
            }
        }
        if (!((Boolean)ThermalConfig.keepAugments.get()).booleanValue()) {
            for (i = this.invSize() - this.augSize(); i < this.invSize(); ++i) {
                Utils.dropItemStackIntoWorldWithRandomness((ItemStack)this.inventory.getStackInSlot(i), (World)worldIn, (BlockPos)pos);
            }
        }
        if (this.xpStorage.getStored() > 0) {
            this.spawnXpOrbs(this.field_145850_b, this.xpStorage.getStored(), Vector3d.func_237492_c_((Vector3i)pos));
        }
    }

    public ItemStack createItemStackTag(ItemStack stack) {
        CompoundNBT nbt = stack.func_190925_c("BlockEntityTag");
        if (this.keepEnergy()) {
            this.getEnergyStorage().writeWithParams(nbt);
        }
        if (this.keepItems()) {
            this.getItemInv().writeSlotsToNBT(nbt, 0, this.invSize() - this.augSize());
        }
        if (((Boolean)ThermalConfig.keepAugments.get()).booleanValue() && this.augSize() > 0) {
            this.getItemInv().writeSlotsToNBTUnordered(nbt, "Augments", this.invSize() - this.augSize());
            if (stack.func_77973_b() instanceof IAugmentableItem) {
                List<ItemStack> items = this.getAugmentsAsList();
                ((IAugmentableItem)stack.func_77973_b()).updateAugmentState(stack, items);
            }
        }
        if (this.keepFluids()) {
            this.getTankInv().write(nbt);
        }
        if (((Boolean)ThermalConfig.keepRSControl.get()).booleanValue() && this.redstoneControlFeature) {
            this.redstoneControl().writeSettings(nbt);
        }
        if (((Boolean)ThermalConfig.keepSideConfig.get()).booleanValue() && this instanceof IReconfigurableTile) {
            ((IReconfigurableTile)this).reconfigControl().writeSettings(nbt);
        }
        if (((Boolean)ThermalConfig.keepTransferControl.get()).booleanValue() && this instanceof ITransferControllableTile) {
            ((ITransferControllableTile)this).transferControl().writeSettings(nbt);
        }
        if (this.hasSecurity()) {
            this.securityControl().write(nbt);
        }
        if (!nbt.isEmpty()) {
            stack.func_77983_a("BlockEntityTag", (INBT)nbt);
        }
        if (!this.enchantments.isEmpty()) {
            stack.func_196082_o().func_218657_a("Enchantments", (INBT)this.enchantments);
        }
        return super.createItemStackTag(stack);
    }

    public boolean onActivatedDelegate(World world, BlockPos pos, BlockState state, PlayerEntity player, Hand hand, BlockRayTraceResult result) {
        if (player.func_226563_dT_()) {
            return this.openFilterGui((ServerPlayerEntity)player);
        }
        ItemStack stack = player.func_184586_b(hand);
        if (this.augValidator().test(stack)) {
            if (this.attemptAugmentInstall(stack)) {
                if (!player.field_71075_bZ.field_75098_d) {
                    player.func_184611_a(hand, ItemHelper.consumeItem((ItemStack)stack, (int)1));
                }
                player.field_70170_p.func_184133_a(null, player.func_233580_cy_(), TCoreSounds.SOUND_TINKER, SoundCategory.PLAYERS, 0.1f, (MathHelper.RANDOM.nextFloat() - MathHelper.RANDOM.nextFloat()) * 0.35f + 0.9f);
            } else {
                player.field_70170_p.func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_187909_gi, SoundCategory.PLAYERS, 0.1f, 0.25f);
            }
            return true;
        }
        return super.onActivatedDelegate(world, pos, state, player, hand, result);
    }

    protected boolean keepEnergy() {
        return (Boolean)ThermalConfig.keepEnergy.get();
    }

    protected boolean keepFluids() {
        return (Boolean)ThermalConfig.keepFluids.get();
    }

    protected boolean keepItems() {
        return (Boolean)ThermalConfig.keepItems.get();
    }

    public ItemStorageCoFH getSlot(int slot) {
        return this.inventory.getSlot(slot);
    }

    public FluidStorageCoFH getTank(int tank) {
        return this.tankInv.getTank(tank);
    }

    public EnergyStorageCoFH getEnergyStorage() {
        return this.energyStorage;
    }

    public FluidStack getRenderFluid() {
        return this.renderFluid;
    }

    public int getScaledDuration() {
        return this.getScaledDuration(16);
    }

    public int getScaledDuration(int scale) {
        return this.isActive ? scale : 0;
    }

    public int getScaledProgress() {
        return this.getScaledProgress(24);
    }

    public int getScaledProgress(int scale) {
        return this.isActive ? scale : 0;
    }

    public int getScaledSpeed() {
        return this.getScaledSpeed(16);
    }

    public int getScaledSpeed(int scale) {
        return this.isActive ? scale : 0;
    }

    public int getCurSpeed() {
        return -1;
    }

    public int getMaxSpeed() {
        return -1;
    }

    public double getEfficiency() {
        return -1.0;
    }

    public boolean clearEnergy(int coil) {
        return this.energyStorage.clear();
    }

    public boolean clearSlot(int slot) {
        if (slot >= this.inventory.getSlots()) {
            return false;
        }
        if (this.inventory.getSlot(slot).clear()) {
            this.onInventoryChanged(slot);
            return true;
        }
        return false;
    }

    public boolean clearTank(int tank) {
        if (tank >= this.tankInv.getTanks()) {
            return false;
        }
        if (this.tankInv.getTank(tank).clear()) {
            this.onTankChanged(tank);
            return true;
        }
        return false;
    }

    public PacketBuffer getControlPacket(PacketBuffer buffer) {
        super.getControlPacket(buffer);
        this.securityControl.writeToBuffer(buffer);
        this.redstoneControl.writeToBuffer(buffer);
        buffer.writeFluidStack(this.renderFluid);
        return buffer;
    }

    public void handleControlPacket(PacketBuffer buffer) {
        super.handleControlPacket(buffer);
        this.securityControl.readFromBuffer(buffer);
        this.redstoneControl.readFromBuffer(buffer);
        this.renderFluid = buffer.readFluidStack();
    }

    public PacketBuffer getGuiPacket(PacketBuffer buffer) {
        super.getGuiPacket(buffer);
        buffer.writeBoolean(this.isActive);
        buffer.writeFluidStack(this.renderFluid);
        this.energyStorage.writeToBuffer(buffer);
        this.xpStorage.writeToBuffer(buffer);
        for (int i = 0; i < this.tankInv.getTanks(); ++i) {
            buffer.writeFluidStack(this.tankInv.get(i));
        }
        return buffer;
    }

    public void handleGuiPacket(PacketBuffer buffer) {
        super.handleGuiPacket(buffer);
        this.isActive = buffer.readBoolean();
        this.renderFluid = buffer.readFluidStack();
        this.energyStorage.readFromBuffer(buffer);
        this.xpStorage.readFromBuffer(buffer);
        for (int i = 0; i < this.tankInv.getTanks(); ++i) {
            this.tankInv.set(i, buffer.readFluidStack());
        }
    }

    public PacketBuffer getRedstonePacket(PacketBuffer buffer) {
        super.getRedstonePacket(buffer);
        buffer.writeInt(this.redstoneControl.getPower());
        return buffer;
    }

    public void handleRedstonePacket(PacketBuffer buffer) {
        super.handleRedstonePacket(buffer);
        this.redstoneControl.setPower(buffer.readInt());
    }

    public PacketBuffer getStatePacket(PacketBuffer buffer) {
        super.getStatePacket(buffer);
        buffer.writeBoolean(this.isActive);
        buffer.writeFluidStack(this.renderFluid);
        return buffer;
    }

    public void handleStatePacket(PacketBuffer buffer) {
        super.handleStatePacket(buffer);
        boolean prevActive = this.isActive;
        this.isActive = buffer.readBoolean();
        this.renderFluid = buffer.readFluidStack();
        if (ThermalConfig.blockAmbientSounds && this.isActive && !prevActive) {
            SoundHelper.playSound((Object)this.getSound());
        }
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.isActive = nbt.func_74767_n("Active");
        this.enchantments = nbt.func_150295_c("Enchantments", 10);
        this.inventory.read(nbt);
        if (nbt.func_74764_b("Augments")) {
            this.inventory.readSlotsUnordered(nbt.func_150295_c("Augments", 10), this.invSize() - this.augSize());
        }
        this.updateAugmentState();
        this.tankInv.read(nbt);
        this.energyStorage.read(nbt);
        this.xpStorage.read(nbt);
        this.filter.read(nbt);
        this.securityControl.read(nbt);
        this.redstoneControl.read(nbt);
        this.renderFluid = FluidStack.loadFluidStackFromNBT((CompoundNBT)nbt.func_74775_l("RenderFluid"));
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74757_a("Active", this.isActive);
        nbt.func_218657_a("Enchantments", (INBT)this.enchantments);
        this.inventory.write(nbt);
        this.tankInv.write(nbt);
        this.getEnergyStorage().write(nbt);
        this.getXpStorage().write(nbt);
        this.filter.write(nbt);
        this.securityControl.write(nbt);
        this.redstoneControl.write(nbt);
        if (!this.renderFluid.isEmpty()) {
            nbt.func_218657_a("RenderFluid", (INBT)this.renderFluid.writeToNBT(new CompoundNBT()));
        }
        return nbt;
    }

    protected final boolean attemptAugmentInstall(ItemStack stack) {
        for (ItemStorageCoFH augSlot : this.augments) {
            if (!augSlot.isEmpty() || !augSlot.isItemValid(stack)) continue;
            augSlot.setItemStack(ItemHelper.cloneStack((ItemStack)stack, (int)1));
            this.updateAugmentState();
            return true;
        }
        return false;
    }

    protected final void addAugmentSlots(int numAugments) {
        this.augments = new ArrayList<ItemStorageCoFH>(numAugments);
        for (int i = 0; i < numAugments; ++i) {
            ItemStorageCoFH slot = new ItemStorageCoFH(1, this.augValidator());
            this.augments.add(slot);
            this.inventory.addSlot(slot, StorageGroup.INTERNAL);
        }
        ((ArrayList)this.augments).trimToSize();
    }

    protected final void updateAugmentState() {
        this.resetAttributes();
        for (ItemStorageCoFH slot : this.augments) {
            ItemStack augment = slot.getItemStack();
            CompoundNBT augmentData = AugmentDataHelper.getAugmentData((ItemStack)augment);
            if (augmentData == null) continue;
            this.setAttributesFromAugment(augmentData);
        }
        this.finalizeAttributes(EnchantmentHelper.func_226652_a_((ListNBT)this.enchantments));
        this.augmentNBT = null;
    }

    protected final List<ItemStack> getAugmentsAsList() {
        return this.augments.stream().map(ItemStorageCoFH::getItemStack).collect(Collectors.toList());
    }

    protected Predicate<ItemStack> augValidator() {
        return AugmentDataHelper::hasAugmentData;
    }

    protected void resetAttributes() {
        this.augmentNBT = new CompoundNBT();
        this.redstoneControlFeature = this.defaultRedstoneControlState();
        this.xpStorageFeature = this.defaultXpStorageState();
        this.creativeEnergy = false;
        this.creativeTanks = false;
    }

    protected void setAttributesFromAugment(CompoundNBT augmentData) {
        this.redstoneControlFeature |= AugmentableHelper.getAttributeMod((CompoundNBT)augmentData, (String)"RSCtl") > 0.0f;
        this.xpStorageFeature |= AugmentableHelper.getAttributeMod((CompoundNBT)augmentData, (String)"XpStr") > 0.0f;
        AugmentableHelper.setAttributeFromAugmentMax((CompoundNBT)this.augmentNBT, (CompoundNBT)augmentData, (String)"BaseMod");
        AugmentableHelper.setAttributeFromAugmentMax((CompoundNBT)this.augmentNBT, (CompoundNBT)augmentData, (String)"RFXfer");
        AugmentableHelper.setAttributeFromAugmentMax((CompoundNBT)this.augmentNBT, (CompoundNBT)augmentData, (String)"RFMax");
        AugmentableHelper.setAttributeFromAugmentMax((CompoundNBT)this.augmentNBT, (CompoundNBT)augmentData, (String)"FluidMax");
        AugmentableHelper.setAttributeFromAugmentMax((CompoundNBT)this.augmentNBT, (CompoundNBT)augmentData, (String)"ItemMax");
        AugmentableHelper.setAttributeFromAugmentString((CompoundNBT)this.augmentNBT, (CompoundNBT)augmentData, (String)"FilterType");
        this.creativeEnergy |= AugmentableHelper.getAttributeMod((CompoundNBT)augmentData, (String)"RFCre") > 0.0f;
        this.creativeTanks |= AugmentableHelper.getAttributeMod((CompoundNBT)augmentData, (String)"FluidCre") > 0.0f;
    }

    protected void finalizeAttributes(Map<Enchantment, Integer> enchantmentMap) {
        float holdingMod = this.getHoldingMod(enchantmentMap);
        float baseMod = AugmentableHelper.getAttributeModWithDefault((CompoundNBT)this.augmentNBT, (String)"BaseMod", (float)1.0f);
        float energyStorageMod = holdingMod * baseMod * AugmentableHelper.getAttributeModWithDefault((CompoundNBT)this.augmentNBT, (String)"RFMax", (float)1.0f);
        float fluidStorageMod = holdingMod * baseMod * AugmentableHelper.getAttributeModWithDefault((CompoundNBT)this.augmentNBT, (String)"FluidMax", (float)1.0f);
        float itemStorageMod = holdingMod * baseMod * AugmentableHelper.getAttributeModWithDefault((CompoundNBT)this.augmentNBT, (String)"ItemMax", (float)1.0f);
        float xpStorageMod = holdingMod * baseMod;
        float energyXferMod = baseMod * AugmentableHelper.getAttributeModWithDefault((CompoundNBT)this.augmentNBT, (String)"RFXfer", (float)1.0f);
        this.energyStorage.applyModifiers(energyStorageMod, energyXferMod).setCreative(() -> this.creativeEnergy);
        for (int i = 0; i < this.tankInv.getTanks(); ++i) {
            this.tankInv.getTank(i).applyModifiers(fluidStorageMod).setCreative(() -> this.creativeTanks);
        }
        int storedXp = this.xpStorage.getStored();
        this.xpStorage.applyModifiers(xpStorageMod * (float)(this.xpStorageFeature ? 1 : 0));
        if (storedXp > 0 && this.xpStorage.getStored() < storedXp) {
            this.spawnXpOrbs(this.field_145850_b, storedXp - this.xpStorage.getStored(), Vector3d.func_237492_c_((Vector3i)this.field_174879_c));
        }
        CompoundNBT filterNBT = this.filter.write(new CompoundNBT());
        this.filter = FilterRegistry.getTileFilter((String)AugmentableHelper.getAttributeModString((CompoundNBT)this.augmentNBT, (String)"FilterType"), (IFilterableTile)this, (CompoundNBT)filterNBT);
    }

    protected boolean defaultReconfigState() {
        return (Boolean)ThermalConfig.flagReconfigSides.get();
    }

    protected boolean defaultRedstoneControlState() {
        return (Boolean)ThermalConfig.flagRSControl.get();
    }

    protected boolean defaultXpStorageState() {
        return (Boolean)ThermalConfig.flagXPStorage.get();
    }

    protected float getHoldingMod(Map<Enchantment, Integer> enchantmentMap) {
        int holding = enchantmentMap.getOrDefault(CoreReferences.HOLDING, 0);
        return 1.0f + (float)holding / 2.0f;
    }

    public SecurityControlModule securityControl() {
        return this.securityControl;
    }

    public RedstoneControlModule redstoneControl() {
        return this.redstoneControl;
    }

    protected void updateHandlers() {
        LazyOptional<?> prevEnergyCap = this.energyCap;
        this.energyCap = this.energyStorage.getCapacity() > 0 ? LazyOptional.of(() -> this.energyStorage) : LazyOptional.empty();
        prevEnergyCap.invalidate();
        LazyOptional<?> prevItemCap = this.itemCap;
        IItemHandler invHandler = this.inventory.getHandler(StorageGroup.ACCESSIBLE);
        this.itemCap = this.inventory.hasAccessibleSlots() ? LazyOptional.of(() -> invHandler) : LazyOptional.empty();
        prevItemCap.invalidate();
        LazyOptional<?> prevFluidCap = this.fluidCap;
        IFluidHandler fluidHandler = this.tankInv.getHandler(StorageGroup.ACCESSIBLE);
        this.fluidCap = this.tankInv.hasAccessibleTanks() ? LazyOptional.of(() -> fluidHandler) : LazyOptional.empty();
        prevFluidCap.invalidate();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ThermalEnergyHelper.getBaseEnergySystem() && this.energyStorage.getMaxEnergyStored() > 0) {
            return this.getEnergyCapability(side);
        }
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.inventory.hasAccessibleSlots()) {
            return this.getItemHandlerCapability(side);
        }
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && this.tankInv.hasAccessibleTanks()) {
            return this.getFluidHandlerCapability(side);
        }
        return super.getCapability(cap, side);
    }

    protected <T> LazyOptional<T> getEnergyCapability(@Nullable Direction side) {
        if (!this.energyCap.isPresent() && this.energyStorage.getCapacity() > 0) {
            this.energyCap = LazyOptional.of(() -> this.energyStorage);
        }
        return this.energyCap.cast();
    }

    protected <T> LazyOptional<T> getItemHandlerCapability(@Nullable Direction side) {
        if (!this.itemCap.isPresent() && this.inventory.hasAccessibleSlots()) {
            IItemHandler handler = this.inventory.getHandler(StorageGroup.ACCESSIBLE);
            this.itemCap = LazyOptional.of(() -> handler);
        }
        return this.itemCap.cast();
    }

    protected <T> LazyOptional<T> getFluidHandlerCapability(@Nullable Direction side) {
        if (!this.fluidCap.isPresent() && this.tankInv.hasAccessibleTanks()) {
            IFluidHandler handler = this.tankInv.getHandler(StorageGroup.ACCESSIBLE);
            this.fluidCap = LazyOptional.of(() -> handler);
        }
        return this.fluidCap.cast();
    }

    public IFilter getFilter() {
        return this.filter;
    }

    public void onFilterChanged() {
    }

    public boolean openGui(ServerPlayerEntity player) {
        if (this.canOpenGui()) {
            NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)this, (BlockPos)this.field_174879_c);
            return true;
        }
        return false;
    }

    public boolean openFilterGui(ServerPlayerEntity player) {
        if (FilterHelper.hasFilter((IFilterableTile)this)) {
            NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)this.getFilter(), (BlockPos)this.field_174879_c);
            return true;
        }
        return false;
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent(this.func_195044_w().func_177230_c().func_149739_a());
    }

    public void onInventoryChanged(int slot) {
        if (slot >= this.invSize() - this.augSize()) {
            this.updateAugmentState();
        }
    }

    public void onControlUpdate() {
        this.updateHandlers();
        this.callNeighborStateChange();
        TileControlPacket.sendToClient((ITilePacketHandler)this);
    }

    public XpStorage getXpStorage() {
        return this.xpStorage;
    }

    public void readConveyableData(PlayerEntity player, CompoundNBT tag) {
        this.redstoneControl.readSettings(tag);
        this.onControlUpdate();
    }

    public void writeConveyableData(PlayerEntity player, CompoundNBT tag) {
        this.redstoneControl.writeSettings(tag);
    }
}

