/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.environs.fog;

import javax.annotation.Nonnull;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.CubicSampler;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeManager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import org.orecruncher.environs.config.Config;
import org.orecruncher.environs.fog.FogResult;
import org.orecruncher.environs.fog.VanillaFogRangeCalculator;
import org.orecruncher.environs.library.BiomeInfo;
import org.orecruncher.environs.library.BiomeUtil;
import org.orecruncher.lib.GameUtils;

@OnlyIn(value=Dist.CLIENT)
public class BiomeFogRangeCalculator
extends VanillaFogRangeCalculator {
    protected final FogResult cached = new FogResult();

    public BiomeFogRangeCalculator() {
        super("BiomeFogRangeCalculator");
    }

    @Override
    public boolean enabled() {
        return (Boolean)Config.CLIENT.fog.enableBiomeFog.get();
    }

    @Override
    @Nonnull
    public FogResult calculate(@Nonnull EntityViewRenderEvent.RenderFogEvent event) {
        ClientWorld world = GameUtils.getWorld();
        assert (world != null);
        BiomeManager biomemanager = world.func_225523_d_();
        Vector3d origin = GameUtils.getMC().field_71460_t.func_215316_n().func_216785_c().func_178786_a(2.0, 2.0, 2.0).func_186678_a(0.25);
        Vector3d visibilitySurvey = CubicSampler.func_240807_a_((Vector3d)origin, (x, y, z) -> {
            Biome b = biomemanager.func_235199_a_(x, y, z);
            BiomeInfo info = BiomeUtil.getBiomeData(b);
            return new Vector3d((double)info.getVisibility(), 0.0, 0.0);
        });
        double visibility = visibilitySurvey.func_82615_a();
        double farPlaneDistance = visibility * (double)event.getFarPlaneDistance();
        double farPlaneDistanceScaleBiome = 0.1 * (1.0 - visibility) + 0.75 * visibility;
        this.cached.setScaled((float)farPlaneDistance, (float)farPlaneDistanceScaleBiome);
        return this.cached;
    }
}

