/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.environs.library;

import com.google.common.collect.ImmutableList;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.StringUtils;
import org.orecruncher.dsurround.DynamicSurroundings;
import org.orecruncher.environs.Environs;
import org.orecruncher.environs.effects.BlockEffect;
import org.orecruncher.environs.effects.BlockEffectType;
import org.orecruncher.environs.library.BlockStateData;
import org.orecruncher.environs.library.BlockStateUtil;
import org.orecruncher.environs.library.WeightedAcousticEntry;
import org.orecruncher.environs.library.config.AcousticConfig;
import org.orecruncher.environs.library.config.BlockConfig;
import org.orecruncher.environs.library.config.EffectConfig;
import org.orecruncher.lib.blockstate.BlockStateMatcher;
import org.orecruncher.lib.blockstate.BlockStateMatcherMap;
import org.orecruncher.lib.fml.ForgeUtils;
import org.orecruncher.lib.logging.IModLog;
import org.orecruncher.lib.resource.IResourceAccessor;
import org.orecruncher.lib.resource.ResourceUtils;
import org.orecruncher.lib.service.IModuleService;
import org.orecruncher.lib.service.ModuleServiceManager;
import org.orecruncher.lib.tags.TagUtils;
import org.orecruncher.lib.validation.ListValidator;
import org.orecruncher.lib.validation.Validators;
import org.orecruncher.sndctrl.api.acoustics.IAcoustic;
import org.orecruncher.sndctrl.api.acoustics.Library;

@OnlyIn(value=Dist.CLIENT)
public final class BlockStateLibrary {
    private static final String TAG_SPECIFIER = "#";
    private static final IModLog LOGGER = Environs.LOGGER.createChild(BlockStateLibrary.class);
    private static final BlockStateMatcherMap<BlockStateData> registry = new BlockStateMatcherMap();

    private BlockStateLibrary() {
    }

    static void initialize() {
        ModuleServiceManager.instance().add(new BlockStateLibraryService());
    }

    static void initFromConfig(@Nonnull List<BlockConfig> config) {
        config.forEach(BlockStateLibrary::register);
    }

    @Nonnull
    static BlockStateData get(@Nonnull BlockState state) {
        BlockStateData profile = registry.get(state);
        return profile == null ? BlockStateData.DEFAULT : profile;
    }

    @Nonnull
    private static BlockStateData getOrCreateProfile(@Nonnull BlockStateMatcher info) {
        BlockStateData profile = registry.get(info);
        if (profile == null) {
            profile = new BlockStateData();
            registry.put(info, profile);
        }
        return profile;
    }

    private static void register(@Nonnull BlockConfig entry) {
        if (entry.blocks.isEmpty()) {
            return;
        }
        for (String blockName : entry.blocks) {
            Collection<BlockStateMatcher> list = BlockStateLibrary.expand(blockName);
            for (BlockStateMatcher blockInfo : list) {
                BlockStateData blockData = BlockStateLibrary.getOrCreateProfile(blockInfo);
                if (entry.soundReset != null && entry.soundReset.booleanValue()) {
                    blockData.clearSounds();
                }
                if (entry.effectReset != null && entry.effectReset.booleanValue()) {
                    blockData.clearEffects();
                }
                if (entry.chance != null) {
                    blockData.setChance(entry.chance);
                }
                for (AcousticConfig sr : entry.acoustics) {
                    if (sr.acoustic == null) continue;
                    ResourceLocation res = Library.resolveResource("environs", sr.acoustic);
                    IAcoustic acoustic = Library.resolve(res, sr.acoustic);
                    int weight = sr.weight;
                    WeightedAcousticEntry acousticEntry = new WeightedAcousticEntry(acoustic, sr.conditions, weight);
                    blockData.addSound(acousticEntry);
                }
                for (EffectConfig e : entry.effects) {
                    if (StringUtils.isEmpty((CharSequence)e.effect)) continue;
                    BlockEffectType type = BlockEffectType.get(e.effect);
                    if (type == BlockEffectType.UNKNOWN) {
                        LOGGER.warn("Unknown block effect type in configuration: [%s]", e.effect);
                        continue;
                    }
                    if (!type.isEnabled()) continue;
                    int chance = e.chance != null ? e.chance : 100;
                    type.getInstance(chance).ifPresent(be -> {
                        if (e.conditions != null) {
                            be.setConditions(e.conditions);
                        }
                        blockData.addEffect((BlockEffect)be);
                    });
                }
            }
        }
    }

    private static Collection<BlockStateMatcher> expand(@Nonnull String blockName) {
        if (blockName.startsWith(TAG_SPECIFIER)) {
            String tagName = blockName.substring(1);
            ITag<Block> tag = TagUtils.getBlockTag(tagName);
            if (tag != null) {
                return tag.func_230236_b_().stream().map(BlockStateMatcher::create).filter(m -> !m.isEmpty()).collect(Collectors.toList());
            }
            LOGGER.debug("Unknown block tag '%s' in Block specification", tagName);
        } else {
            BlockStateMatcher matcher = BlockStateMatcher.create(blockName);
            if (!matcher.isEmpty()) {
                return ImmutableList.of((Object)matcher);
            }
            LOGGER.debug("Unknown block name '%s' in Block Specification", blockName);
        }
        return ImmutableList.of();
    }

    private static class BlockStateLibraryService
    implements IModuleService {
        private static final Type blockType = TypeToken.getParameterized(List.class, (Type[])new Type[]{BlockConfig.class}).getType();

        private BlockStateLibraryService() {
        }

        @Override
        public String name() {
            return "BlockStateLibrary";
        }

        @Override
        public void start() {
            Collection<IResourceAccessor> configs = ResourceUtils.findConfigs("dsurround", DynamicSurroundings.DATA_PATH, "blocks.json");
            IResourceAccessor.process(configs, accessor -> BlockStateLibrary.initFromConfig((List)accessor.as(blockType)));
            ForgeUtils.getBlockStates().forEach(BlockStateUtil::getData);
            ForgeUtils.getBlockStates().stream().map(BlockStateUtil::getData).forEach(BlockStateData::trim);
            BlockStateUtil.setData(Blocks.field_150350_a.func_176223_P(), BlockStateData.DEFAULT);
            BlockStateUtil.setData(Blocks.field_201941_jj.func_176223_P(), BlockStateData.DEFAULT);
            BlockStateUtil.setData(Blocks.field_201940_ji.func_176223_P(), BlockStateData.DEFAULT);
        }

        @Override
        public void log() {
            LOGGER.info("%d block states processed, %d registry entries", ForgeUtils.getBlockStates().size(), registry.size());
        }

        @Override
        public void stop() {
            registry.clear();
            ForgeUtils.getBlockStates().forEach(state -> BlockStateUtil.setData(state, null));
        }

        static {
            Validators.registerValidator(blockType, new ListValidator());
        }
    }
}

