/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.environs.library;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.environs.config.Config;
import org.orecruncher.environs.library.config.DimensionConfig;
import org.orecruncher.lib.WorldUtils;

@OnlyIn(value=Dist.CLIENT)
public class DimensionInfo {
    private static final int SPACE_HEIGHT_OFFSET = 32;
    public static final DimensionInfo NONE = new DimensionInfo();
    protected ResourceLocation name;
    protected int seaLevel;
    protected int skyHeight;
    protected int cloudHeight;
    protected int spaceHeight;
    protected boolean hasHaze = false;
    protected boolean hasAuroras = false;
    protected boolean hasFog = false;
    protected boolean alwaysOutside = false;
    protected boolean playBiomeSounds = true;
    protected final boolean isFlatWorld;

    DimensionInfo() {
        this.name = new ResourceLocation("environs", "no_dimension");
        this.isFlatWorld = false;
    }

    public DimensionInfo(@Nonnull World world, @Nullable DimensionConfig dimConfig) {
        DimensionType dt = world.func_230315_m_();
        this.name = world.func_234923_W_().func_240901_a_();
        this.seaLevel = world.func_181545_F();
        this.cloudHeight = this.skyHeight = world.func_217301_I();
        this.spaceHeight = this.skyHeight + 32;
        this.isFlatWorld = WorldUtils.isSuperFlat(world);
        if (dt.func_236043_f_() && dt.func_218272_d()) {
            this.hasAuroras = true;
            this.hasFog = true;
        }
        if (this.isFlatWorld) {
            this.seaLevel = 0;
        } else if (dt.func_236043_f_() && (Integer)Config.CLIENT.biome.worldSealevelOverride.get() > 0) {
            this.seaLevel = (Integer)Config.CLIENT.biome.worldSealevelOverride.get();
        }
        if (((List)Config.CLIENT.biome.biomeSoundBlacklist.get()).contains(this.name.toString())) {
            this.playBiomeSounds = false;
        }
        if (dimConfig != null) {
            if (dimConfig.seaLevel != null) {
                this.seaLevel = dimConfig.seaLevel;
            }
            if (dimConfig.skyHeight != null) {
                this.skyHeight = dimConfig.skyHeight;
            }
            if (dimConfig.hasHaze != null) {
                this.hasHaze = dimConfig.hasHaze;
            }
            if (dimConfig.hasAurora != null) {
                this.hasAuroras = dimConfig.hasAurora;
            }
            if (dimConfig.cloudHeight != null) {
                this.cloudHeight = dimConfig.cloudHeight;
            } else {
                int n = this.cloudHeight = this.hasHaze ? this.skyHeight / 2 : this.skyHeight;
            }
            if (dimConfig.hasFog != null) {
                this.hasFog = dimConfig.hasFog;
            }
            if (dimConfig.alwaysOutside != null) {
                this.alwaysOutside = dimConfig.alwaysOutside;
            }
            this.spaceHeight = this.skyHeight + 32;
        }
    }

    @Nonnull
    public ResourceLocation getName() {
        return this.name;
    }

    public int getSeaLevel() {
        return this.seaLevel;
    }

    public int getSkyHeight() {
        return this.skyHeight;
    }

    public int getCloudHeight() {
        return this.cloudHeight;
    }

    public int getSpaceHeight() {
        return this.spaceHeight;
    }

    public boolean hasHaze() {
        return this.hasHaze;
    }

    public boolean hasAuroras() {
        return this.hasAuroras;
    }

    public boolean hasFog() {
        return this.hasFog;
    }

    public boolean playBiomeSounds() {
        return this.playBiomeSounds;
    }

    public boolean alwaysOutside() {
        return this.alwaysOutside;
    }

    public boolean isFlatWorld() {
        return this.isFlatWorld;
    }
}

