/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.lib;

import javax.annotation.Nonnull;
import net.minecraft.world.IWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.lib.Localization;

public enum DayCycle {
    NO_SKY(false, "NoSky"),
    SUNRISE(false, "Sunrise"),
    SUNSET(true, "Sunset"),
    DAYTIME(false, "Daytime"),
    NIGHTTIME(true, "Nighttime");

    private static final float DAYTIME_THRESHOLD = 0.8f;
    private static final float SUNRISE_THRESHOLD = 0.76f;
    private static final float NIGHTTIME_THRESHOLD = 0.26f;
    private static final float SUNSET_THRESHOLD = 0.22f;
    private final boolean auroraVisible;
    private final String localizeString;

    private DayCycle(boolean auroraVisible, String localName) {
        this.auroraVisible = auroraVisible;
        this.localizeString = "sndctrl.format." + localName;
    }

    public static boolean isDaytime(@Nonnull IWorld world) {
        return DayCycle.getCycle(world) == DAYTIME;
    }

    public static boolean isNighttime(@Nonnull IWorld world) {
        return DayCycle.getCycle(world) == NIGHTTIME;
    }

    public static boolean isSunrise(@Nonnull IWorld world) {
        return DayCycle.getCycle(world) == SUNRISE;
    }

    public static boolean isSunset(@Nonnull IWorld world) {
        return DayCycle.getCycle(world) == SUNSET;
    }

    public static DayCycle getCycle(@Nonnull IWorld world) {
        if (world.func_230315_m_().func_236037_d_() || !world.func_230315_m_().func_218272_d()) {
            return NO_SKY;
        }
        float angle = world.func_242415_f(0.0f);
        if (angle > 0.8f) {
            return DAYTIME;
        }
        if (angle > 0.76f) {
            return SUNRISE;
        }
        if (angle > 0.26f) {
            return NIGHTTIME;
        }
        if (angle > 0.22f) {
            return SUNSET;
        }
        return DAYTIME;
    }

    public static float getMoonPhaseFactor(@Nonnull IWorld world) {
        return world.func_242413_ae();
    }

    public static boolean isAuroraVisible(@Nonnull IWorld world) {
        return DayCycle.getCycle(world).isAuroraVisible();
    }

    public static boolean isAuroraInvisible(@Nonnull IWorld world) {
        return !DayCycle.getCycle(world).isAuroraVisible();
    }

    public boolean isAuroraVisible() {
        return this.auroraVisible;
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nonnull
    public String getFormattedName() {
        return Localization.load(this.localizeString);
    }
}

