/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.lib.reflection;

import com.google.common.base.Preconditions;
import java.lang.reflect.Field;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.orecruncher.lib.Lib;
import org.orecruncher.lib.reflection.ReflectionHelper;

public class ObjectField<T, R> {
    @Nullable
    private final Field field;
    @Nonnull
    private final String className;
    @Nonnull
    private final String fieldName;
    @Nonnull
    private final Supplier<R> defaultValue;
    @Nonnull
    private final Function<T, R> getter;
    @Nonnull
    private final BiConsumer<T, R> setter;

    public ObjectField(@Nonnull String className, @Nonnull Supplier<R> defaultValue, String ... fieldName) {
        Preconditions.checkNotNull(defaultValue);
        Preconditions.checkNotNull((Object)className);
        Preconditions.checkArgument((fieldName.length > 0 ? 1 : 0) != 0, (Object)"Field name cannot be empty");
        this.defaultValue = defaultValue;
        this.className = className;
        this.fieldName = fieldName[0];
        this.field = ReflectionHelper.resolveField(className, fieldName);
        if (this.isNotAvailable()) {
            Lib.LOGGER.warn("Unable to locate field [%s::%s]", this.className, this.fieldName);
            this.getter = obj -> defaultValue.get();
            this.setter = (obj, v) -> {};
        } else {
            this.getter = this::getImpl;
            this.setter = this::setImpl;
        }
    }

    public ObjectField(@Nonnull Class<T> clazz, @Nonnull Supplier<R> defaultValue, String ... fieldName) {
        Preconditions.checkNotNull(defaultValue);
        Preconditions.checkNotNull(clazz);
        Preconditions.checkArgument((fieldName.length > 0 ? 1 : 0) != 0, (Object)"Field name cannot be empty");
        this.defaultValue = defaultValue;
        this.className = clazz.getName();
        this.fieldName = fieldName[0];
        this.field = ReflectionHelper.resolveField(clazz, fieldName);
        if (this.isNotAvailable()) {
            Lib.LOGGER.warn("Unable to locate field [%s::%s]", this.className, this.fieldName);
            this.getter = obj -> defaultValue.get();
            this.setter = (obj, v) -> {};
        } else {
            this.getter = this::getImpl;
            this.setter = this::setImpl;
        }
    }

    public boolean isNotAvailable() {
        return this.field == null;
    }

    public R get(@Nonnull T obj) {
        return this.getter.apply(obj);
    }

    private R getImpl(@Nonnull T obj) {
        try {
            return (R)this.field.get(obj);
        }
        catch (Throwable throwable) {
            return this.defaultValue.get();
        }
    }

    public void set(@Nonnull T obj, @Nullable R value) {
        this.setter.accept(obj, value);
    }

    private void setImpl(@Nonnull T obj, @Nullable R value) {
        try {
            this.field.set(obj, value);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void check() {
        if (this.isNotAvailable()) {
            String msg = String.format("Uninitialized field [%s::%s]", this.className, this.fieldName);
            throw new IllegalStateException(msg);
        }
    }
}

